#include <klocale.h>

#include "language.h"

// disable inclusion in okle.pot for now in here - HACK ;-)
#define a18n(m) i18n(m)

LangCode::LangCode(const QString& n,const QString& c)
{
 name = n;
 code = c;
}

void Language::init()
{
 languages.append(new LangCode(a18n("Abkhazian"),"ab"));
 languages.append(new LangCode(a18n("Afrikaans"),"af"));
 languages.append(new LangCode(a18n("Albanian"),"sq"));
 languages.append(new LangCode(a18n("Amharic"),"am"));
 languages.append(new LangCode(a18n("Arabic"),"ar"));
 languages.append(new LangCode(a18n("Armenian"),"hy"));
 languages.append(new LangCode(a18n("Assamese"),"as"));
 languages.append(new LangCode(a18n("Avestan"),"ae"));
 languages.append(new LangCode(a18n("Aymara"),"ay"));
 languages.append(new LangCode(a18n("Azerbaijani"),"az"));
 languages.append(new LangCode(a18n("Bashkir"),"ba"));
 languages.append(new LangCode(a18n("Basque"),"eu"));
 languages.append(new LangCode(a18n("Belarusian"),"be"));
 languages.append(new LangCode(a18n("Bengali"),"bn"));
 languages.append(new LangCode(a18n("Bihari"),"bh"));
 languages.append(new LangCode(a18n("Bislama"),"bi"));
 languages.append(new LangCode(a18n("Bosnian"),"bs"));
 languages.append(new LangCode(a18n("Breton"),"br"));
 languages.append(new LangCode(a18n("Bulgarian"),"bg"));
 languages.append(new LangCode(a18n("Burmese"),"my"));
 languages.append(new LangCode(a18n("Catalan"),"ca"));
 languages.append(new LangCode(a18n("Chamorro"),"ch"));
 languages.append(new LangCode(a18n("Chechen"),"ce"));
 languages.append(new LangCode(a18n("Chichewa; Nyanja"),"ny"));
 languages.append(new LangCode(a18n("Chinese"),"zh"));
 languages.append(new LangCode(a18n("Church Slavic"),"cu"));
 languages.append(new LangCode(a18n("Chuvash"),"cv"));
 languages.append(new LangCode(a18n("Cornish"),"kw"));
 languages.append(new LangCode(a18n("Corsican"),"co"));
 languages.append(new LangCode(a18n("Croatian"),"hr"));
 languages.append(new LangCode(a18n("Czech"),"cs"));
 languages.append(new LangCode(a18n("Danish"),"da"));
 languages.append(new LangCode(a18n("Dutch"),"nl"));
 languages.append(new LangCode(a18n("Dzongkha"),"dz"));
 languages.append(new LangCode(a18n("English"),"en"));
 languages.append(new LangCode(a18n("Esperanto"),"eo"));
 languages.append(new LangCode(a18n("Estonian"),"et"));
 languages.append(new LangCode(a18n("Faroese"),"fo"));
 languages.append(new LangCode(a18n("Fijian"),"fj"));
 languages.append(new LangCode(a18n("Finnish"),"fi"));
 languages.append(new LangCode(a18n("French"),"fr"));
 languages.append(new LangCode(a18n("Frisian"),"fy"));
 languages.append(new LangCode(a18n("Gaelic (Scots)"),"gd"));
 languages.append(new LangCode(a18n("Gallegan"),"gl"));
 languages.append(new LangCode(a18n("Georgian"),"ka"));
 languages.append(new LangCode(a18n("German"),"de"));
 languages.append(new LangCode(a18n("Greek"),"el"));
 languages.append(new LangCode(a18n("Guarani"),"gn"));
 languages.append(new LangCode(a18n("Gujarati"),"gu"));
 languages.append(new LangCode(a18n("Hausa"),"ha"));
 languages.append(new LangCode(a18n("Hebrew"),"he"));
 languages.append(new LangCode(a18n("Hebrew"),"iw"));
 languages.append(new LangCode(a18n("Herero"),"hz"));
 languages.append(new LangCode(a18n("Hindi"),"hi"));
 languages.append(new LangCode(a18n("Hiri Motu"),"ho"));
 languages.append(new LangCode(a18n("Hungarian"),"hu"));
 languages.append(new LangCode(a18n("Icelandic"),"is"));
 languages.append(new LangCode(a18n("Indonesian"),"id"));
 languages.append(new LangCode(a18n("Indonesian"),"in"));
 languages.append(new LangCode(a18n("Interlingua"),"ia"));
 languages.append(new LangCode(a18n("Interlingue"),"ie"));
 languages.append(new LangCode(a18n("Inuktitut"),"iu"));
 languages.append(new LangCode(a18n("Inupiaq"),"ik"));
 languages.append(new LangCode(a18n("Irish"),"ga"));
 languages.append(new LangCode(a18n("Italian"),"it"));
 languages.append(new LangCode(a18n("Japanese"),"ja"));
 languages.append(new LangCode(a18n("Javanese"),"jv"));
 languages.append(new LangCode(a18n("Javanese"),"jw"));
 languages.append(new LangCode(a18n("Kalaallisut"),"kl"));
 languages.append(new LangCode(a18n("Kannada"),"kn"));
 languages.append(new LangCode(a18n("Kashmiri"),"ks"));
 languages.append(new LangCode(a18n("Kazakh"),"kk"));
 languages.append(new LangCode(a18n("Khmer"),"km"));
 languages.append(new LangCode(a18n("Kikuyu"),"ki"));
 languages.append(new LangCode(a18n("Kinyarwanda"),"rw"));
 languages.append(new LangCode(a18n("Kirghiz"),"ky"));
 languages.append(new LangCode(a18n("Komi"),"kv"));
 languages.append(new LangCode(a18n("Korean"),"ko"));
 languages.append(new LangCode(a18n("Kuanyama"),"kj"));
 languages.append(new LangCode(a18n("Kurdish"),"ku"));
 languages.append(new LangCode(a18n("Lao"),"lo"));
 languages.append(new LangCode(a18n("Latin"),"la"));
 languages.append(new LangCode(a18n("Latvian"),"lv"));
 languages.append(new LangCode(a18n("Letzeburgesch"),"lb"));
 languages.append(new LangCode(a18n("Lingala"),"ln"));
 languages.append(new LangCode(a18n("Lithuanian"),"lt"));
 languages.append(new LangCode(a18n("Macedonian"),"mk"));
 languages.append(new LangCode(a18n("Malagasy"),"mg"));
 languages.append(new LangCode(a18n("Malay"),"ms"));
 languages.append(new LangCode(a18n("Malayalam"),"ml"));
 languages.append(new LangCode(a18n("Maltese"),"mt"));
 languages.append(new LangCode(a18n("Manx"),"gv"));
 languages.append(new LangCode(a18n("Maori"),"mi"));
 languages.append(new LangCode(a18n("Marathi"),"mr"));
 languages.append(new LangCode(a18n("Marshall"),"mh"));
 languages.append(new LangCode(a18n("Moldavian"),"mo"));
 languages.append(new LangCode(a18n("Mongolian"),"mn"));
 languages.append(new LangCode(a18n("Nauru"),"na"));
 languages.append(new LangCode(a18n("Navajo"),"nv"));
 languages.append(new LangCode(a18n("Ndebele, North"),"nd"));
 languages.append(new LangCode(a18n("Ndebele, South"),"nr"));
 languages.append(new LangCode(a18n("Ndonga"),"ng"));
 languages.append(new LangCode(a18n("Nepali"),"ne"));
 languages.append(new LangCode(a18n("Northern Sami"),"se"));
 languages.append(new LangCode(a18n("Norwegian"),"no"));
 // TRANSLATORS: this is really Bokm&#229;l
 languages.append(new LangCode(a18n("Norwegian Bokmaal"),"nb"));
 languages.append(new LangCode(a18n("Norwegian Nynorsk"),"nn"));
 languages.append(new LangCode(a18n("Nyanja; Chichewa"),"ny"));
 languages.append(new LangCode(a18n("Occitan"),"oc"));
 languages.append(new LangCode(a18n("Oriya"),"or"));
 languages.append(new LangCode(a18n("Oromo"),"om"));
 languages.append(new LangCode(a18n("Ossetian"),"os"));
 languages.append(new LangCode(a18n("Pali"),"pi"));
 languages.append(new LangCode(a18n("Panjabi"),"pa"));
 languages.append(new LangCode(a18n("Persian"),"fa"));
 languages.append(new LangCode(a18n("Polish"),"pl"));
 languages.append(new LangCode(a18n("Portuguese"),"pt"));
 // TRANSLATORS: this is really Proven&#231;al
 languages.append(new LangCode(a18n("Provenc,al"),"oc"));
 languages.append(new LangCode(a18n("Pushto"),"ps"));
 languages.append(new LangCode(a18n("Quechua"),"qu"));
 languages.append(new LangCode(a18n("Raeto-Romance"),"rm"));
 languages.append(new LangCode(a18n("Romanian"),"ro"));
 languages.append(new LangCode(a18n("Rundi"),"rn"));
 languages.append(new LangCode(a18n("Russian"),"ru"));
 languages.append(new LangCode(a18n("Samoan"),"sm"));
 languages.append(new LangCode(a18n("Sango"),"sg"));
 languages.append(new LangCode(a18n("Sanskrit"),"sa"));
 languages.append(new LangCode(a18n("Sardinian"),"sc"));
 languages.append(new LangCode(a18n("Serbian"),"sr"));
 languages.append(new LangCode(a18n("Serbo-Croatian"),"sh"));
 languages.append(new LangCode(a18n("Shona"),"sn"));
 languages.append(new LangCode(a18n("Sindhi"),"sd"));
 languages.append(new LangCode(a18n("Sinhalese"),"si"));
 languages.append(new LangCode(a18n("Slovak"),"sk"));
 languages.append(new LangCode(a18n("Slovenian"),"sl"));
 languages.append(new LangCode(a18n("Somali"),"so"));
 languages.append(new LangCode(a18n("Sotho, Southern"),"st"));
 languages.append(new LangCode(a18n("Spanish"),"es"));
 languages.append(new LangCode(a18n("Sundanese"),"su"));
 languages.append(new LangCode(a18n("Swahili"),"sw"));
 languages.append(new LangCode(a18n("Swati"),"ss"));
 languages.append(new LangCode(a18n("Swedish"),"sv"));
 languages.append(new LangCode(a18n("Tagalog"),"tl"));
 languages.append(new LangCode(a18n("Tahitian"),"ty"));
 languages.append(new LangCode(a18n("Tajik"),"tg"));
 languages.append(new LangCode(a18n("Tamil"),"ta"));
 languages.append(new LangCode(a18n("Tatar"),"tt"));
 languages.append(new LangCode(a18n("Telugu"),"te"));
 languages.append(new LangCode(a18n("Thai"),"th"));
 languages.append(new LangCode(a18n("Tibetan"),"bo"));
 languages.append(new LangCode(a18n("Tigrinya"),"ti"));
 languages.append(new LangCode(a18n("Tonga"),"to"));
 languages.append(new LangCode(a18n("Tsonga"),"ts"));
 languages.append(new LangCode(a18n("Tswana"),"tn"));
 languages.append(new LangCode(a18n("Turkish"),"tr"));
 languages.append(new LangCode(a18n("Turkmen"),"tk"));
 languages.append(new LangCode(a18n("Twi"),"tw"));
 languages.append(new LangCode(a18n("Uighur"),"ug"));
 languages.append(new LangCode(a18n("Ukrainian"),"uk"));
 languages.append(new LangCode(a18n("Urdu"),"ur"));
 languages.append(new LangCode(a18n("Uzbek"),"uz"));
 languages.append(new LangCode(a18n("Vietnamese"),"vi"));
 // TRANSLATORS: this is really Volap&#252;k
 languages.append(new LangCode(a18n("Volapuk"),"vo"));
 languages.append(new LangCode(a18n("Welsh"),"cy"));
 languages.append(new LangCode(a18n("Wolof"),"wo"));
 languages.append(new LangCode(a18n("Xhosa"),"xh"));
 languages.append(new LangCode(a18n("Yiddish"),"yi"));
 languages.append(new LangCode(a18n("Yiddish"),"ji"));
 languages.append(new LangCode(a18n("Yoruba"),"yo"));
 languages.append(new LangCode(a18n("Zhuang"),"za"));
 languages.append(new LangCode(a18n("Zulu"),"zu"));
}

QString Language::name(DVDLangID_t lang) 
{
 QString lang_code;
 lang_code[0] = lang >> 8;
 lang_code[1] = lang & 0xff;
 for(uint i=0;i<languages.count();i++)
  {
   if(languages.at(i)->code == lang_code)
    return a18n(languages.at(i)->name);
  }
 // Unknown language
 return a18n("Unknown");
}

QString Language::code(DVDLangID_t lang) 
{
 QString lang_code;
  
 lang_code[0] = lang >> 8;
 lang_code[1] = lang & 0xff;
 for(uint i=0;i<languages.count();i++)
  {
   if(languages.at(i)->code == lang_code)
    return languages.at(i)->code;
  }
 return "??";
}

QStringList Language::allNames()
{
 QStringList tmplist;
 for(uint i=0;i<languages.count();i++)
  tmplist.append(a18n(languages.at(i)->name));
 tmplist.sort();
 return tmplist;
}

QStringList Language::allCodes()
{
 QStringList tmplist;
 for(uint i=0;i<languages.count();i++)
  tmplist.append(languages.at(i)->code);
 tmplist.sort();
 return tmplist;
}

DVDLangID_t Language::id(const QString& str)
{
 DVDLangID_t langid = 0;
 QString code_639_1;
 for(uint i=0;languages.count();i++)
  {
   if(a18n(languages.at(i)->name) == str)
    {
     langid = QChar(languages.at(i)->code[0]) << 8;
     langid += QChar(languages.at(i)->code[1]);
     break;
    }
  }
 return langid;
}

QPtrList<LangCode> Language::languages;

