/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef DEMOLITIONCLIENTHOOKS_H
#define DEMOLITIONCLIENTHOOKS_H

#include <cstdlib>
#include <string>
#include "ClientHooks.h"
#include "DemolitionModel.h"
#include "PluginModel.h"
using std::string;

using namespace LibOmClient;


/** ClientHooks implementation for the Gtk client.
 *
 * These are the hooks into the GUI for the Comm class.
 *
 * \ingroup OmGtk
 */
class DemolitionClientHooks : public ClientHooks
{
public:
	DemolitionClientHooks(DemolitionModel* model);
	virtual ~DemolitionClientHooks();
	
	// OSC thread functions
	void error(const string& msg);
	
	void engine_enabled() {}
	void engine_disabled() {}
	void new_patch(PatchModel* const pm);
	void new_port(PortModel* const port_model);
	void port_removal(const string& path);
	void patch_destruction(const string& path);
	void patch_enabled(const string& path);
	void patch_disabled(const string& path);
	void new_node(NodeModel* const nm);
	void object_renamed(const string& old_path, const string& new_path);
	void node_removal(const string& path);
	void connection(ConnectionModel* const cm);
	void disconnection(const string& src_port_path, const string& dst_port_path);
	void metadata_update(MetadataModel* const mm);
	void control_change(ControlModel* const cm);
	void new_plugin(PluginModel* const pi);

private:
	DemolitionModel* m_model;
};


#endif // DEMOLITIONCLIENTHOOKS_H
