/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "ConfigWindow.h"
#include <iostream>
#include <cassert>
#include <algorithm>
#include <cctype>
#include "OmGtk.h"
#include "PatchController.h"
#include "NodeModel.h"
#include "Controller.h"
#include "OmGtkApp.h"
#include "OmPatchBayArea.h"
using std::cout; using std::cerr; using std::endl;


namespace OmGtk {

ConfigWindow::ConfigWindow(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& xml)
: Gtk::Window(cobject),
  m_state_manager(NULL)
{
	xml->get_widget("config_path_entry", m_path_entry);
	xml->get_widget("config_save_button", m_save_button);
	xml->get_widget("config_cancel_button", m_cancel_button);
	xml->get_widget("config_ok_button", m_ok_button);
	
	m_save_button->signal_clicked().connect(  sigc::mem_fun(this, &ConfigWindow::save_clicked));
	m_cancel_button->signal_clicked().connect(sigc::mem_fun(this, &ConfigWindow::cancel_clicked));
	m_ok_button->signal_clicked().connect(    sigc::mem_fun(this, &ConfigWindow::ok_clicked));
}


/** Sets the state manager for this window and initializes everything.
 *
 * This function MUST be called before using the window in any way!
 */
void
ConfigWindow::state_manager(StateManager* sm)
{
	m_state_manager = sm;
	m_path_entry->set_text(sm->patch_path());
}



///// Event Handlers //////


void
ConfigWindow::save_clicked()
{
	m_state_manager->patch_path(m_path_entry->get_text());
	m_state_manager->apply_settings();
	m_state_manager->save_settings();
}


void
ConfigWindow::cancel_clicked()
{
	hide();
}


void
ConfigWindow::ok_clicked()
{
	m_state_manager->patch_path(m_path_entry->get_text());
	m_state_manager->apply_settings();
	hide();
}


} // namespace OmGtk
