/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "MidiControlEvent.h"
#include "Om.h"
#include "Patch.h"
#include "MidiInNode.h"

namespace Om {

MidiControlEvent::MidiControlEvent(Request* request, Patch* patch, int param, int value)
: Event(request),
  m_patch(patch),
  m_param(param),
  m_value(value)
{
}


void
MidiControlEvent::execute(uint sample_offset)
{
	for (List<MidiInNode*>::iterator j = m_patch->midi_in_nodes().begin(); j != m_patch->midi_in_nodes().end(); ++j)
		(*j)->control(m_param, m_value, sample_offset);
}


} // namespace Om

