/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "MidiInNode.h"
#include "config.h"
#include "Patch.h"
#include "Om.h"
#include "AlsaDriver.h"
#include "Maid.h"

namespace Om {


MidiInNode::MidiInNode(const string& path, uint poly, Patch* parent, samplerate srate, size_t buffer_size)
: InternalNode(path, poly, parent, srate, buffer_size),
  m_listnode(NULL)
{
	m_listnode = new ListNode<MidiInNode*>(this);
}


MidiInNode::~MidiInNode()
{
	delete m_listnode;
}


void
MidiInNode::activate()
{
	InternalNode::activate();

#ifdef HAVE_ALSA
	om->alsa_driver()->add_port(parent_patch());
#endif
}


void
MidiInNode::add_to_patch()
{
	parent_patch()->midi_in_nodes().push_back(m_listnode);
	InternalNode::add_to_patch();
}


void
MidiInNode::remove_from_patch()
{
	ListNode<MidiInNode*>* ln = parent_patch()->midi_in_nodes().remove(this);
	om->maid()->push(ln);
	m_listnode = NULL;
	InternalNode::remove_from_patch();
}


} // namespace Om

