################################################################################
# [.src.lib.omniORB2.orbcore]dir.mms
################################################################################

CXXSRCS=taskqueue.cc omniServant.cc omniObjRef.cc-
	localIdentity.cc remoteIdentity.cc-
	objectAdapter.cc callDescriptor.cc-
	poa.cc portableserver.cc poamanager.cc-
	poastubs.cc
CXXSRCS_0=proxyFactory.cc omniInternal.cc anonObject.cc-
	initRefs.cc-
	constants.cc corbaObject.cc corbaOrb.cc-
	corbaBoa.cc-
	corbaString.cc
CXXSRCS_1=exception.cc giopClient.cc giopServer.cc-
	initFile.cc-
	ior.cc uri.cc-
	libcWrapper.cc mbufferedStream.cc-
	nbufferedStream.cc
CXXSRCS_2=ropeFactory.cc-
	strand.cc scavenger.cc exceptn.cc omniORB.cc-
	tracedthread.cc-
	policy.cc-
	dynamicLib.cc

CXXSRCS_3=bootstrapstub.cc Namingstub.cc

.IFDEF ALPHA
ALPHAFLOAT_SRC=CorbaIEEEFloat.cc
.ENDIF

.IFDEF useTcpSocketVaxRoutines
tcpSocketVaxRoutines_src=tcpSocketVaxRoutines.cc
.ENDIF

CXXSRCS_9=CorbaDFloat.cc CorbaGFloat.cc $(ALPHAFLOAT_SRC)-
	relStream.cc tcpSocket.cc tcpSocketMTfactory.cc logIOstream.cc-
	$(tcpSocketVaxRoutines_src)

################################################################################
# all rule
################################################################################

CONFIG_DEFAULT_LOCATION = omniCFG:omniORB.cfg

.IFDEF useTcpSocketVaxRoutines
TCPVAX_MACROS=USE_tcpSocketVaxRoutines
.ENDIF

DIR_CXXMACROS = CONFIG_DEFAULT_LOCATION=""""$(CONFIG_DEFAULT_LOCATION)""""\
	USE_omniORB_logStream _OMNIORB_LIBRARY $(TCPVAX_MACROS)

DIR_CXXINCLUDES = ./ ../
DIR_CXXREPOSITORIES=$(OMNIORB_LIB_REPOSITORY)

.ifdef cxx6
CXX6FLAGS = /Quiet
.endif
DIR_CXXFLAGS = $(OMNIORB_LIB_CXXFLAGS)/Nested_include=primary

lib = omniORB3$(DebugSuffix).olb

.IFDEF useTcpSocketVaxRoutines
tcpSocketVaxRoutines=$(lib)(tcpSocketVaxRoutines.OBJ)
.ENDIF

.IFDEF ALPHA
ALPHAFLOAT_OBJS=$(lib)(CorbaIEEEFloat)
.ENDIF

CORBAFLOAT_OBJS = $(lib)(CorbaDFloat) $(lib)(CorbaGFloat) $(ALPHAFLOAT_OBJS)

NETLIBOBJS = $(lib)(relStream) $(lib)(tcpSocket) $(lib)(tcpSocketMTfactory)
LOG_OBJS = $(lib)(logIOstream)

ORB_OBJS =\
	$(lib)(taskqueue) $(lib)(omniServant) $(lib)(omniObjRef)\
	$(lib)(localIdentity) $(lib)(remoteIdentity)\
	$(lib)(objectAdapter) $(lib)(callDescriptor)\
	$(lib)(poa) $(lib)(portableserver) $(lib)(poamanager)\
	$(lib)(poastubs)\
	$(lib)(proxyFactory) $(lib)(omniInternal) $(lib)(anonObject)\
	$(lib)(initRefs)\
	$(lib)(constants) $(lib)(corbaObject) $(lib)(corbaOrb)\
	$(lib)(corbaBoa)\
	$(lib)(corbaString)\
	$(lib)(exception) $(lib)(giopClient) $(lib)(giopServer)\
	$(lib)(initFile)\
	$(lib)(ior) $(lib)(uri)\
	$(lib)(libcWrapper) $(lib)(mbufferedStream)\
	$(lib)(nbufferedStream)\
	$(lib)(ropeFactory)\
	$(lib)(strand) $(lib)(scavenger) $(lib)(exceptn) $(lib)(omniORB)\
	$(lib)(tracedthread)\
	$(lib)(policy)\
	$(lib)(dynamicLib)\
	$(NETLIBOBJS) $(LOG_OBJS) $(lib)(bootstrapstub) $(lib)(Namingstub)\
	$(CORBAFLOAT_OBJS) $(tcpSocketVaxRoutines) $(lib)(gatekeeper)

.ifdef CXX6
.ifdef USE_SHAREABLE_IMAGES
SUBDIRS = sharedlib
.endif
.endif

all :: $(ORB_OBJS)
	@ $(MakeSubDirs)

# see comments under Win32Platform in dir.mk

gatekeeper.obj : [.gatekeepers.dummystub]gatekeeper.cc

################################################################################
# export rule
################################################################################

export :: all

export :: $(lib)
	$(ExportLibrary)
	@ $(MakeSubDirs)

clean ::
	$(RM) $(lib)

################################################################################
# Compile a CORBA::Float and CORBA::Double for each floating point format
################################################################################

corbaDFloat.obj : corbaDFloat.cc
	@ $(CxxCompile) "/Float=D_Float"

corbaGFloat.obj : corbaGFloat.cc
	@ $(CxxCompile) "/Float=G_Float"

.ifdef ALPHA

corbaIEEEFloat.obj : corbaIEEEFloat.cc
	@ $(CxxCompile) "/Float=IEEE_Float"

.endif
