// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepFill_OffsetWire_HeaderFile
#define _BRepFill_OffsetWire_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _GeomAbs_JoinType_HeaderFile
#include <GeomAbs_JoinType.hxx>
#endif
#ifndef _BRepFill_DataMapOfOrientedShapeListOfShape_HeaderFile
#include <BRepFill_DataMapOfOrientedShapeListOfShape.hxx>
#endif
#ifndef _BRepMAT2d_BisectingLocus_HeaderFile
#include <BRepMAT2d_BisectingLocus.hxx>
#endif
#ifndef _BRepMAT2d_LinkTopoBilo_HeaderFile
#include <BRepMAT2d_LinkTopoBilo.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeShape_HeaderFile
#include <TopTools_DataMapOfShapeShape.hxx>
#endif
class Standard_ConstructionError;
class Standard_NoSuchObject;
class TopoDS_Face;
class BRepMAT2d_BisectingLocus;
class BRepMAT2d_LinkTopoBilo;
class TopoDS_Shape;
class TopTools_ListOfShape;
class BRepFill_DataMapOfOrientedShapeListOfShape;


//! Constructs a Offset Wire to a spine (wire or face) <br>
//!          on the left of spine. <br>
class BRepFill_OffsetWire  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
  Standard_EXPORT   BRepFill_OffsetWire();
  
  Standard_EXPORT   BRepFill_OffsetWire(const TopoDS_Face& Spine,const GeomAbs_JoinType Join = GeomAbs_Arc);
  //! Initialize the evaluation of Offseting. <br>
  Standard_EXPORT     void Init(const TopoDS_Face& Spine,const GeomAbs_JoinType Join = GeomAbs_Arc) ;
  //! Performs  an OffsetWire at  an altitude <Alt> from <br>
//!          the  face ( According  to  the orientation of  the <br>
//!          face) <br>
  Standard_EXPORT     void Perform(const Standard_Real Offset,const Standard_Real Alt = 0.0) ;
  //! Performs an  OffsetWire <br>
  Standard_EXPORT     void PerformWithBiLo(const TopoDS_Face& WSP,const Standard_Real Offset,const BRepMAT2d_BisectingLocus& Locus,BRepMAT2d_LinkTopoBilo& Link,const GeomAbs_JoinType Join = GeomAbs_Arc,const Standard_Real Alt = 0.0) ;
  
  Standard_EXPORT     Standard_Boolean IsDone() const;
  
  Standard_EXPORT    const TopoDS_Face& Spine() const;
  //! returns the generated shape. <br>
  Standard_EXPORT    const TopoDS_Shape& Shape() const;
  //! Returns   the  shapes  created  from   a  subshape <br>
//!          <SpineShape> of the spine. <br>
//!          Returns the last computed Offset. <br>
//! <br>
  Standard_EXPORT    const TopTools_ListOfShape& GeneratedShapes(const TopoDS_Shape& SpineShape) ;
  
  Standard_EXPORT     GeomAbs_JoinType JoinType() const;





protected:





private:

  
  Standard_EXPORT     BRepFill_DataMapOfOrientedShapeListOfShape& Generated() ;
  //! Prepare the spine as follow <br>
//!          - Cut the spine-Edges at the extrema of curvature and <br>
//!            at the inflexion points. <br>
  Standard_EXPORT     void PrepareSpine() ;
  //! Add the OffsetWire <Other> to <me> and update <myMap> <br>
  Standard_EXPORT     void Add(const BRepFill_OffsetWire& Other) ;
  //! Constructs the wires with the trimmed offset edges. <br>
  Standard_EXPORT     void MakeWires() ;
  //! Fix holes between open wires where it is possible <br>
  Standard_EXPORT     void FixHoles() ;


TopoDS_Face mySpine;
TopoDS_Face myWorkSpine;
Standard_Real myOffset;
TopoDS_Shape myShape;
Standard_Boolean myIsDone;
GeomAbs_JoinType myJoinType;
BRepFill_DataMapOfOrientedShapeListOfShape myMap;
BRepMAT2d_BisectingLocus myBilo;
BRepMAT2d_LinkTopoBilo myLink;
TopTools_DataMapOfShapeShape myMapSpine;
Standard_Boolean myCallGen;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
