/* -*- Mode: C; c-file-style: "bsd" -*- */
/* context.h
 *       Copyright (C) 2002 Timo Schulz
 *
 * This file is part of OpenCDK.
 *
 * OpenCDK is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * OpenCDK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenCDK; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef CDK_CONTEXT_H
#define CDK_CONTEXT_H

#include "types.h"


struct cdk_sesskey_s {
    GCRY_MPI a;
};  

struct cdk_verify_result_s {
    int sig_ver;
    int sig_len;
    int sig_status;
    int sig_flags;
    u32 keyid[2];
    u32 created;
    u32 expires;
    int pubkey_algo;
    int digest_algo;
    char * notation;
    unsigned char * sig_data;
};

struct cdk_s2k_hd_s {
    int mode;
    unsigned char hash_algo;
    unsigned char salt[8];
    unsigned long count;
};

struct cdk_handle_s {
    int cipher_algo;
    int digest_algo;
    struct {
        int algo;
        int level;
    } compress;
    struct {
        int mode;
        int digest_algo;
        int cipher_algo;
    } _s2k;
    struct {
        unsigned armor:1;
        unsigned textmode:1;
        unsigned compress:1;
        unsigned mdc:1;
        unsigned compat:1;
        unsigned rfc1991:1;
        unsigned overwrite;
    } opt;
    struct {
        Verify_Result verify;
    } result;
    struct {
        cdkPKT_secret_key * sk;
        unsigned on:1;
    } cache;
    CDK_DEK dek;
    CDK_S2K_HD s2k;
    struct {
        CDK_KEYDB_HD sec;
        CDK_KEYDB_HD pub;
    } db;
    void (*callback) (void * opaque, int type, const char * s);
    void * callback_value;
};

struct cdk_prefitem_s {
    unsigned char type;
    unsigned char value;
};

struct cdk_subpkt_s {
    struct cdk_subpkt_s * next;
    unsigned long size;
    unsigned char type;
    unsigned char d[1];  
};

struct cdk_mpi_s {
    unsigned short bits;
    unsigned short bytes;
    unsigned char data[1];  
};

struct key_table_s {
    struct key_table_s * next;
    unsigned long offset;
    CDK_DBSEARCH desc;
};

struct key_idx_s {
    unsigned long offset;
    unsigned long keyid[2];
    unsigned char fpr[20]; 
};
  
struct cdk_keydb_handle_s {
    int type;
    CDK_STREAM buf; /* NULL if the name item is valid */
    CDK_STREAM idx;
    char * name;
    char * idx_name;
    struct key_table_s * cache;
    int ncache;
    unsigned int secret:1;
    unsigned int isopen:1;
    unsigned int no_cache:1;
};


struct cdk_keydb_search_s {
    union {
        char * pattern;
        unsigned long keyid[2];
        unsigned char fpr[20];     
    } u;
    int type;  
};

struct cdk_key_list_s {
    struct cdk_key_list_s * next;
    union {
        cdkPKT_public_key * pk;
        cdkPKT_secret_key * sk;
    } key;
    int type;  
};

struct cdk_dek_s {
    int algo;
    int keylen;
    int use_mdc;
    unsigned rfc1991:1;
    unsigned char key[32]; /* 256-bit */
};

struct cdk_string_list_s {
    struct cdk_string_list_s * next;
    char d[1]; 
};

#endif /* CDK_CONTEXT_H */

