<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/Snoopy.class.inc");
include_once("./functions/function.php");
include_once("./functions/utils.php");
include_once("./functions/fileutils.php");

/*
* @param $url
* @param $do_cache	If FALSE, will not cache the resource.  Useful for
* 					images, where we have no interest in caching them,
* 					as we rely on browser to do this.
*/
function open_url($url, $do_cache=TRUE)
{
	// from config.php
	global $CONFIG_VARS;
	global $LANG_VARS;
	
	if($do_cache!==FALSE && $CONFIG_VARS['http_cache.enable']!==FALSE)
	{
		$filename = 'cache/' . urlencode(trim($url));
		$fstat = @stat($filename); // Causes warning if !exists.
	
		// Cache data is good for how long?  IMDB and the like rarely
		// change their pages, so we shouldn't need to check them more
		// than once a week.  If there is no config entry for the
		// lifetime, default to 7 days.
		$lifetime = ($CONFIG_VARS['http_cache.lifetime']) ? $CONFIG_VARS['http_cache.lifetime'] : 86400 * 7;
		if ($fstat !== FALSE && $fstat[9] > (time() - $lifetime))
		{
			$result = read_file_contents($filename, $error);
			if($result!==FALSE)
			{
				if(!empty($result))
				{
					return($result);
				}
			}
			else
			{
				opendb_log("HTTP_CACHE:: Failed to open $filename ($error)");
				@unlink($filename);
			}
		}
	}

	$snoopy = new Snoopy;

	// if no proxy
	if ($CONFIG_VARS['proxy_server.enable']==TRUE)
	{
		$snoopy->proxy_host = $CONFIG_VARS['proxy_server.host'];
		$snoopy->proxy_port = $CONFIG_VARS['proxy_server.port'];
		$snoopy->user = $CONFIG_VARS['proxy_server.userid'];
		$snoopy->pass = $CONFIG_VARS['proxy_server.password'];
	}
	
	if($snoopy->fetch($url) && $snoopy->status == 200)
	{
		$result = $snoopy->results;
		
		if($do_cache!==FALSE && $CONFIG_VARS['http_cache.enable']!==FALSE)
		{
			$filename = 'cache/' . urlencode(trim($url));
			if(write_file_contents($filename, $result, $error))
			{
				opendb_log("HTTP_CACHE:: $filename saved.");
			}
			else
			{
				opendb_log("HTTP_CACHE:: Failed to save $filename ($error)");
				@unlink($filename);
			}
		}			
		return $result;
	}
	else
	{
		opendb_log("http::open_url() failed to open $url (".$snoopy->error.")");
		
		// The return false, will be enough to prompt the user to check the logfile.	
		return FALSE;
	}
}

/**
* Original logic for checking file upload status taken 
* from phpMyAdmin db_details.php script
*/
function is_file_upload_enabled()
{
	global $CONFIG_VARS;
	
	// Allows us to disable file upload at OpenDb level.
	if(!isset($CONFIG_VARS['file_upload_enable']))
		return (ini_get('file_uploads') == 1 || strtolower(ini_get('file_uploads')) == 'on');
	else
		return $CONFIG_VARS['file_upload_enable'];
}

/*
* It seems that some sites have ini_get as a disabled function.  So all the logic
* to ascertain register_globals is in this function, where we can implement a workaround.
*/
function is_register_globals_enabled()
{
	global $CONFIG_VARS;
	
	if(!isset($CONFIG_VARS['register_globals_enabled']))
		return (ini_get('register_globals') == 1 || strtolower(ini_get('register_globals')) == 'on');
	else
		return $CONFIG_VARS['register_globals_enabled'];
}

/**
	Get access to a server variable value in a php
	version independant manner.
*/
function get_http_env($envname)
{
	global $HTTP_SERVER_VARS;
	// Apparently this is unecessary, but since new versions
	// of php break existing functionality all the time, I will
	// leave just in case.
	global $_SERVER;

	if(is_not_empty_array($HTTP_SERVER_VARS))
		return $HTTP_SERVER_VARS[$envname];
	else if(is_not_empty_array($_SERVER))
		return $_SERVER[$envname];
	else
		return NULL; // Should never happen!
}

/**
	Check if $url has a protocol at the start. 
*/
function is_url_absolute($url)
{
	if(preg_match("!([a-zA-Z]+)://!", $url))
	{
		return TRUE;
	}
	else
		return FALSE;
}

/**
	Convert all HTTP variables into a GET string.

	// Does not include empty fields.
*/
function get_url_string($http_vars, $extra_vars_r=NULL, $exclude_keys_r=NULL)
{
	$url = "";

	// Merge - $extra_vars_r may contain new values for existing variables.
	if(is_array($extra_vars_r))
		$http_vars = array_merge($http_vars,$extra_vars_r);

	@reset($http_vars);
	while (list($key, $val) = @each($http_vars))
	{
		if(!is_array($exclude_keys_r) || !in_array($key,$exclude_keys_r))
		{
			if(is_array($val))
			{
				while(list(,$aval) = each($val))
				{
					if(strlen($aval)>0)
						$url .= $key."[]=".rawurlencode($aval)."&";
				}
			}
			else if(strlen($val)>0)
				$url .= "$key=".rawurlencode($val)."&";
		}
	}

	// Get rid of last '&'
	return substr($url,0,-1);
}

/**
	Pass all http variables onto next instance...

	Note: Includes empty fields which may cause problems in some situations.
*/
function get_url_fields($http_vars, $extra_vars_r=NULL, $exclude_keys_r = NULL)
{
	$fields = "";

	// Merge - $extra_vars_r may contain new values for existing variables.
	if(is_array($extra_vars_r))
		$http_vars = array_merge($http_vars,$extra_vars_r);

	@reset($http_vars);
	while (list ($key, $val) = each($http_vars))
	{
		if(!is_array($exclude_keys_r) || !in_array($key,$exclude_keys_r))
		{
			if(is_array($val))
			{
				while (list(,$aval) = each($val))
					$fields .= "\n<input type=\"hidden\" name=\"".$key."[]\" value=\"".htmlspecialchars($aval)."\">";
			}
			else //if (strlen($val)>0) - Include empty fields.
				$fields .= "\n<input type=\"hidden\" name=\"$key\" value=\"".htmlspecialchars($val)."\">";
		}
	}
	return $fields;
}

/**
	Fetches site url
*/
function get_site_url()
{
	global $CONFIG_VARS;

	// Override of auto hostname discovery.
	if(strlen($CONFIG_VARS['site.hostname'])>0)
	{
		$host = $CONFIG_VARS['site.hostname'];
		if(preg_match("![a-zA-Z]+://([^$]*)!", $host, $regs))
		{
			$host = $regs[1];
		}
	}		
	else
		$host = get_http_env("SERVER_NAME");
	
	// Override of auto hostport discovery.
	if(strlen($CONFIG_VARS['site.hostport'])>0)
		$port = $CONFIG_VARS['site.hostport'];
	else
		$port = get_http_env("SERVER_PORT");
	
	// It seems that Win32 uses PATH_INFO instead of SCRIPT_NAME		
	$path = ifempty(get_http_env("PATH_INFO"),
					ifempty(get_http_env("PHP_SELF"),
					get_http_env("SCRIPT_NAME")));
	
	if(get_http_env("HTTPS") == "on")
		$protocol = "https";
	else
		$protocol = "http";

	// Now process path to get rid of anything after last /
	$index = strrpos($path,"/");
	if($index !== FALSE)
		$path = substr($path,0,$index+1);

	return $protocol."://".$host.($port!=80 && $port != 443?":".$port:"").$path;
}
?>
