<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  This function will return an array of arrays.  The internal entries are
  of the form:
     "category",
	 "id",
	 "title"
	 
	The $entry['category'] is the standard CDDB genre.

	Note: We reread the page everytime we need to offset into the list.  But when
	the HTTP cache is implemented this will no longer be an expensive operation.
*/
function get_freedb_list_of_titles($words, $max_entries, $offset=NULL)
{
	$results = open_url("http://www.freedb.org/freedb_search.php?words=".urlencode($words)."&allfields=NO&fields=artist&fields=title&allcats=YES&grouping=none");
	$start = strpos($results, "freedb database search results");
	$entryBlock = substr($results, $start, strlen($results));

	$end = 0;
	$start = strpos($entryBlock,"freedb_search_fmt.php?cat=", $end);

	while( (!$entries || count($entries)<$max_entries) && $start !== FALSE)
	{
		$start = $start + 26; // 26 = "freedb_search_fmt.php?cat="
		$end = strpos($entryBlock,"</a>", $start);
	
		// Only start adding the $entries array once we have reached our offset.
		if(!is_numeric($offset) || $count_of_entries>=$offset)
		{
			// A line entry.
			$line = substr($entryBlock, $start, $end-$start);
	
			$catend = strpos($line, "&id=");
			$entry['category'] = substr($line, 0, $catend);
			$idend = strpos($line, "\">", $catend+4);
			$entry['id'] = substr($line,$catend+4,$idend-($catend+4));
	
			$entry['title'] = substr($line,$idend+2, strlen($line)-($idend+2));
			if(strpos($entry['title'], "<font size=")!==FALSE)// Need to check if it specifies a title, or whether it includes <font...
				$entry['title'] = $entries[count($entries)-1]['title'];//get last title.

			// Now lets see if the title is a standard format: "artist / title"
			// Some titles are not in standard format, which is a pain in the proverbial...
			$idx = strpos($entry['title'], "/");
			if($idx!==FALSE)
			{
				$entry['artist'] = trim(substr($entry['title'],0, $idx));
				$entry['title'] = trim(substr($entry['title'],$idx+1,strlen($entry['title'])-$idx));
				// Now format the title nicely.
				$entry['title'] = ucwords(strtolower($entry['title']));
			}
		
			// Add it to the list - not much point if the title is empty.
			if(strlen($entry['title'])>0 && !is_freedb_title_found($entries, $entry['title']))
			{
				$entries[] = $entry;
			}
		}
	
		$start = strpos($entryBlock,"freedb_search_fmt.php?cat=", $end);
		$count_of_entries++;
	}
	return $entries;
}

/*
	Returns TRUE if title already found in entries.
	
	Comparison is NOT case sensitive.
*/
function is_freedb_title_found($entries, $title)
{
	for($i=0; $i<count($entries); $i++)
	{
		// Will do case insensitive test!
		if(strtolower($entries[$i]['title']) == strtolower($title))
			return TRUE;
	}
	//else
	return FALSE;
}

/*
	Display a list of <br> delimited entries from the entries array with links back to
	site.php?site=freedb&op=choose
*/
function get_freedb_entry_chooser($entries, $offset, $HTTP_VARS)
{
	// The third parameter lists all those variables that should _not_ be passed on; this is either because they
	// are already included, or it is extraneous information we do not require anymore.  The 'cddbgenre' and 
	// 'freedb_id' are removed, because they are passed in from item_add.php
	$http_vars_url = get_url_string($HTTP_VARS, NULL, array('words','site','op','offset','title','cddbgenre','freedb_id'));

	// Add one to offset, because otherwise we are repeating ourselves with the list numbers.
	$buf .= "<ol start=".ifempty($offset+1,"1").">";
	for($i = 0; $i<count($entries); $i++)
	{
		if(strlen($entries[$i]['title'])>0)
			$text = htmlspecialchars($entries[$i]['artist'])."&nbsp;/&nbsp;".htmlspecialchars($entries[$i]['title']);
		else
			$text = $entries[$i]['artist'];
		
		$buf .= "\n<li><a href=\"site.php?site=freedb&op=choose&artist=".urlencode($entries[$i]['artist'])."&title=".urlencode($entries[$i]['title'])."&id=".$entries[$i]['id']."&category=".$entries[$i]['category']."&$http_vars_url\">".$text."</a></li>";
	}
	return $buf."</ol>";
}

/*
	Will return an array of the following format:
	Array(
    	[run_time] => "runtime"
		[genre]=>extended genre,
		[year]=>year
	    [tracks] => Array(...)
	)
	
	The $entry['genre'] is the extended genre for some entries.
*/
function get_freedb_entry_details($cat, $id)
{
	$entryBlock = open_url("http://www.freedb.org/freedb/$cat/$id");
	
	// Get runtime
	if(preg_match("/^# Disc length: ([^$]+)$/mU", $entryBlock, $regs))
	{
		if(preg_match("/([0-9]+) seconds/", $regs[1], $regs2))
		{
			$minutes = (int) ($regs2[1] / 60);
			$seconds = $regs2[1] % 60;
			
			//Prefix "0", so that seconds are properly formatted.
			if(strlen($seconds)<2)
				$seconds = "0".$seconds;
			$entry['run_time'] = "$minutes:$seconds";
		}
	}
	
	// get title.
	$entry['title'] = '';
	if(preg_match_all("/^DTITLE=([^$]+)$/mU", $entryBlock, $matches))
	{
		for ($i = 0; $i < count($matches[1]); $i++)
		{
			$entry['title'] .= $matches[1][$i];
		}
		
		$index = strpos($entry['title'],"/");
		if($index !== FALSE)
			$entry['title'] = trim(substr($entry['title'], $index+1));//1="/"
			
		// Ensure title is properly formatted.
		$entry['title'] = ucwords(strtolower($entry['title']));
	}
	
	//get year
	if(preg_match("/^DYEAR=([^$]+)$/mU", $entryBlock, $regs))
	{
		$entry['year'] = trim($regs[1]);
	}
	
	// get extended genre
	if(preg_match("/^DGENRE=([^$]+)$/mU", $entryBlock, $regs))
	{
		$entry['genre'] = trim($regs[1]);
	}
	
	if(preg_match_all("/^TTITLE([0-9]+)=([^$]+)$/mU", $entryBlock, $matches))
	{
		for ($i = 0; $i < count($matches[2]); $i++)
		{
			$entry['tracks'][] = ucwords(strtolower(preg_replace('/[\s]+/', ' ', trim($matches[2][$i]))));
		}
	}
	
	//echo("<pre>");
	//print_r($entry);
	//echo("</pre>");
	
	return $entry;
}
?>
