<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/item.php");
include_once("./functions/review.php");
include_once("./functions/theme.php");
include_once("./functions/status_type.php");
include_once("./functions/borrowed_item.php");

function whats_new($update_on, $user_id=NULL)
{
	global $LANG_VARS;
	global $CONFIG_VARS;
	
	//$page.= _theme_image("whatsnew.gif", "", NULL, "absmiddle");
	$page .= "<h3>".$LANG_VARS['whats_new']."</h3>";
	
	// Get the list of valid status_types, which we can display in this whatsnew page.
	$results = fetch_whatsnew_status_type_rs();
    if($results)
	{
		$page .= "<ul>";
        while ($status_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
		{
			$status_items_updated = fetch_item_listing_cnt(from_and_where_clause(array(update_on=>$update_on,not_owner_id=>$user_id,s_status_type=>$status_type_r['s_status_type'])));
			$status_title = replace_lang_vars(array('count'=>$status_items_updated,'s_status_type_desc'=>$status_type_r['description']), $LANG_VARS['cnt_item(s)_added_updated']);
			if($status_items_updated>0)// No sense providing a link if nothing updated...
				$page .= "<li><a class=\"whatsnew\" href=\"listings.php?".(strlen($user_id)>0?"not_owner_id=$user_id&s_status_type=".$status_type_r['s_status_type']:"")."&update_on=".urlencode($update_on)."\">".$status_title."</a></li>";
			else
				$page .= "<li>".$status_title."</li>";
		}
        mysql_free_result($results);
		$page .= "</ul>";
    }
		
	if($CONFIG_VARS['whatsnew.review_stats']!==FALSE)
	{
		$page .= "<ul>";
		$page .= "<li>".replace_lang_var("count", fetch_review_atdate_cnt($update_on), $LANG_VARS['cnt_review(s)'])."</li>";
		$page .= "</ul>";
	}

	if($CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['whatsnew.borrow_stats']!==FALSE)
	{
		$page .= "<ul>";
		$page .= "<li>".replace_lang_var("count", fetch_borrowed_item_status_atdate_cnt('C', $update_on), $LANG_VARS['cnt_item(s)_returned'])."</li>";
		$page .= "<li>".replace_lang_var("count", fetch_borrowed_item_status_atdate_cnt('B', $update_on), $LANG_VARS['cnt_item(s)_borrowed'])."</li>";
		$page .= "<li>".replace_lang_var("count", fetch_borrowed_item_status_atdate_cnt('R', $update_on), $LANG_VARS['cnt_item(s)_reserved'])."</li>";
		$page .= "</ul>";
	}

	return $page;
}	
?>
