<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./functions/function.php");
include_once("./functions/http.php");
include_once("./functions/user.php");
include_once("./functions/email.php");
include_once("./functions/whatsnew.php");
include_once("./functions/language.php");

session_start();

// Backwards compatibility!
if(strlen($HTTP_VARS['from'])>0)
	$HTTP_VARS['redirect'] = $HTTP_VARS['from'];

// If the system is reloaded, then we do not want the login page to display unless
// there is no valid user.  So wrap the whole login page in this.
if(is_opendb_valid_session())
{
	if(strlen($HTTP_VARS['redirect'])>0)
	{
		// Redirect to requested page, as already logged in.
		header('Location: ' . urldecode($HTTP_VARS['redirect']));
	}
	else
	{
		include_once("./include/language.php");
		include_once("./include/theme.php");
		
		echo(_theme_header(""));
		echo("<p>".replace_lang_vars(array('site'=>$CONFIG_VARS['site.title'],
										'version'=>$CONFIG_VARS['site.version']),
										ifempty($LANG_VARS['logged_in_welcome'], $LANG_VARS['login_welcome'])).
			"</p>");
		echo(_theme_footer());
	}
}
else // login invalid!
{
	// Specifies that we should show the login section.
	$show_form = TRUE;
	$show_welcome = TRUE;
	$refresh_menu = FALSE;
	$show_signup_link = FALSE;

	//
	// Since we are at the login screen, it is a good idea to unregister
	// all variables, so they cannot be misused!!!
	//
	if(is_register_globals_enabled())
	{
		session_unregister("user_id");
		session_unregister("user_theme");
		session_unregister("user_language");
		session_unregister("user_type");
		session_unregister("hash_check");
		session_unregister("login_time");
		session_unregister("last_access_time");
	}
	
	// Explicitly set to null here so things like themes can be set back to default!
	$HTTP_SESSION_VARS['user_id'] = NULL;
	$HTTP_SESSION_VARS['user_theme'] = NULL;
	$HTTP_SESSION_VARS['user_language'] = NULL;
	$HTTP_SESSION_VARS['user_type'] = NULL;
	$HTTP_SESSION_VARS['hash_check'] = NULL;
	$HTTP_SESSION_VARS['login_time'] = NULL;
	$HTTP_SESSION_VARS['last_access_time'] = NULL;

	// User has requested a new password and email
	if($HTTP_VARS['op'] == "newpassword" && strlen($HTTP_VARS['uid'])>0 && $CONFIG_VARS['login.enable_new_pwd_gen']!==FALSE)
	{
		include_once("./include/language.php");
		
		opendb_log("User requested to be emailed a new password. (user_id=".$HTTP_VARS['uid'].")");
		
		// Do not allow new password operation for 'deactivated' user.
		if(is_user_valid($HTTP_VARS['uid']) && !is_user_active($HTTP_VARS['uid']))
		{
			// Make deactivated username look valid!
			$email_result = TRUE;
			$pass_result = TRUE;

			opendb_log("New password request failure: User is deactivated. (user_id=".$HTTP_VARS['uid'].")");
		}
		else if(is_user_guest($HTTP_VARS['uid']))
		{
			$email_result = TRUE;
			$pass_result = TRUE;

			opendb_log("New password request failure: User is a guest. (user_id=".$HTTP_VARS['uid'].")");
		}
		else
		{
			// lookup email for this username
			$user_name  = fetch_user_name($HTTP_VARS['uid']);
			$user_email = fetch_user_email($HTTP_VARS['uid']);
			$user_pass  = generate_password(8);

			// Only check email if the user actually exists.
			if($user_name===FALSE)
			{
				// Make bad usernames look right!
				$email_result = TRUE;
				$pass_result = TRUE;

				opendb_log("New password request failure: User does not exist. (user_id=".$HTTP_VARS['uid'].")");
			}
			else
			{
				// only send if valid user (email)
				if(strlen($user_email)>0)
				{
					$pass_result = update_user_passwd($HTTP_VARS['uid'], $user_pass);
					if($pass_result===TRUE)
					{
						$from       = $CONFIG_VARS['site.admin_email'];
						$from_name  = $CONFIG_VARS['site.title'];
						$subject    = $LANG_VARS['lost_password'];
						$message    = replace_lang_var("fullname", $user_name, expand_langvar_newlines($LANG_VARS['to_user_email_intro'])).
									"\n\n".
									expand_langvar_newlines($LANG_VARS['new_passwd_email']).
									  "\n\n".
					        	      $LANG_VARS['userid'].": ".$HTTP_VARS['uid']."\n".
					            	  $LANG_VARS['password'].": ".$user_pass;

						$email_result = opendb_email($user_email, $user_name, $from, $from_name, $subject, $message);
					}
				}
				else
				{
					$email_result[] = "User '".$HTTP_VARS['uid']."' does not have a valid email address.";
				}
			}
		}
		
		if($pass_result===TRUE && $email_result===TRUE)
		{
			$page_buffer .= "<p class=\"colortext\"><b><i>".$LANG_VARS['new_passwd_sent']."</i></b></p>\n";
		}
		else //if($pass_result!==TRUE || $email_result!==TRUE)
		{
			$page_buffer .= "<div class=\"error\">";
			if($email_result!==TRUE)
			{
				$page_buffer .= $LANG_VARS['error_sending_email'];

				// Process all errors in variable.
				while(list(,$result) = @each($email_result))
				{
					$errors .= $result;
				}
				opendb_log("New password request failure: ".$errors);
			}
			else// $pass_result!==TRUE
			{
				$page_buffer .= $LANG_VARS['error_updating_pwd'];				
			}

			$url = "email.php?op=send_to_site_admin&subject=".urlencode($LANG_VARS['lost_pwd_request_problem'])."&redirect_link=".urlencode($LANG_VARS['return_to_login_page'])."&redirect_url=login.php";
			$page_buffer .= "\n<div class=\"smerror\"><br>".
						replace_lang_vars(array('url'=>$url,'site'=>$CONFIG_VARS['site.title']), $LANG_VARS['if_problem_persists_contact_your_administrator']).
						"</div>".
						"</div><br>\n";
		}
	}
	else if($HTTP_VARS['op'] == "login")// The login dialog sets this, to indicate that we should process login details.
	{
		$HTTP_VARS['uid'] = strtolower($HTTP_VARS['uid']);// make lowercase
		if(is_user_active($HTTP_VARS['uid']) && validate_user_passwd($HTTP_VARS['uid'], $HTTP_VARS['pass']))
		{
			$HTTP_SESSION_VARS['login_time'] = time();
			$HTTP_SESSION_VARS['last_access_time'] = $HTTP_SESSION_VARS['login_time'];
			
			$user_r = fetch_user_r($HTTP_VARS['uid']);
			$HTTP_SESSION_VARS['user_id'] = $HTTP_VARS['uid'];
			$HTTP_SESSION_VARS['user_theme'] = $user_r['theme'];
			$HTTP_SESSION_VARS['user_language'] = $user_r['language'];
			$HTTP_SESSION_VARS['user_type'] = $user_r['type'];

			// Now register security hash, so we can compare.
			$HTTP_SESSION_VARS['hash_check'] = $CONFIG_VARS['site.security_hash'];
			
			if(is_register_globals_enabled())
			{
				session_register("login_time");
				session_register("last_access_time");
				session_register("user_id");
				session_register("user_theme");
				session_register("user_language");
				session_register("user_type");
				session_register("hash_check");
				
				$hash_check = $HTTP_SESSION_VARS['hash_check'];
				$login_time = $HTTP_SESSION_VARS['login_time'];
				$last_access_time = $HTTP_SESSION_VARS['login_time'];
				$user_id = $HTTP_SESSION_VARS['user_id'];
				$user_theme = $HTTP_SESSION_VARS['user_theme'];
				$user_language = $HTTP_SESSION_VARS['user_language'];
				$user_type = $HTTP_SESSION_VARS['user_type'];
			}

			// Get the previous last visit so we can use in whats new page.
			$update_on = fetch_user_lastvisit($HTTP_VARS['uid']);

			opendb_log("User logged in (user_id=".$HTTP_VARS['uid'].")"); // log "user login"

			// Not much we can do if it does not update.
			update_user_lastvisit($HTTP_VARS['uid']);
			
			// Note: We will enable this again once we work out what has been happening
			// for some users, where the login page redirects back to root!!!
			if(strlen($HTTP_VARS['redirect'])>0)
			{
				// User tried to get in with an invalid session.
				// We've just given her a valid one, so log it
				// appropriately and send a redirect to where she
				// really wanted to go.
				header('Location: ' . urldecode($HTTP_VARS['redirect']));
			}
			else
			{
				include_once("./include/language.php");
				
				$show_form = FALSE;
				$page_buffer .= "<h2>".$LANG_VARS['login_successful']."</h2>";

				// In some cases this will cause menu frame to be refreshed.
				$refresh_menu = TRUE;
			
				// If no logged_in_welcome variable defined, the login_welcome
				// will automatically be used anyway.
				$lang_login_welcome = $LANG_VARS['logged_in_welcome'];

				// Now display the whats new page, as long 
				if($CONFIG_VARS['login.show_whats_new'])
				{
					$page_buffer .= "<table border=0 width=100%><tr><td width=5%>&nbsp;</td><td>".
						whats_new($update_on, $HTTP_SESSION_VARS['user_id']).
						"</td></tr></table>";
				}
			}
		}
		else
		{
			include_once("./include/language.php");
			
			// If uid specified, then user has attempted to login.
			if(strlen($HTTP_VARS['uid'])>0)
			{
				$page_buffer .= "<h2>".$LANG_VARS['login_failure']."</h2>".
					"<div class=\"error\">".$LANG_VARS['double_check_info']."</div>";
					
				opendb_log("User tried to log in [login failure] (user_id=".$HTTP_VARS['uid'].")");
			}
		}
	}
	else if($HTTP_VARS['invalidsession'] == "true")
	{
		include_once("./include/language.php");
		
		// In some cases this will cause menu frame to be refreshed.
		$refresh_menu = TRUE;
		
		if($CONFIG_VARS['site.enable']!==FALSE && $CONFIG_VARS['site.public_access.enable']!==TRUE)
		{
			$page_buffer .= "<h2>".$LANG_VARS['session_invalid']."</h2>".
				"<div class=\"error\">".$LANG_VARS['session_has_expired']."</div>";
		}
		else
		{
			$page_buffer .= "<div class=\"error\">".$LANG_VARS['site_is_disabled']."</div>";
			
			$show_form = FALSE;
			$show_welcome = FALSE;
		}
	}
	
	// Should we display login page?
	if($show_form)
	{
		include_once("./include/language.php");

		$page_buffer .= "<br>".
			"\n<form action=\"login.php\" method=\"post\">".
			"\n<input type=hidden name=\"op\" value=\"login\">".
			"\n<table border=0>".
			"\n<tr>".
			"\n<td align=right class=\"prompt\">".$LANG_VARS['userid'].":&nbsp;</td>".
			"\n<td class=\"data\"><input type=\"text\" name=\"uid\" value=\"".$HTTP_VARS['uid']."\"></td>".
			"\n</tr>".
			"\n<tr>".
			"\n<td align=right class=\"prompt\">".$LANG_VARS['password'].":&nbsp;</td>".
			"\n<td class=\"data\"><input type=\"password\" name=\"pass\"></td>".
			"\n</tr>".
			"\n<tr>".
			"\n<td colspan=2 align=right><input type=\"submit\" value=\"".replace_lang_var("site", $CONFIG_VARS['site.title'], $LANG_VARS['site_login'])."\"></td>".
			"\n</tr>";
	
		// The user tried to go straight to a menu item with an invalid session.  
		// Set a "from" variable here so that after we give them a full session
		// we can redirect them back to the page they really wanted.
		if(strlen($HTTP_VARS['redirect'])==0)
		{
			// Do not include a $redirect link if we are starting at login.php
			if(substr($PHP_SELF, -9) != "login.php") // 9="login.php"
			{
				$url = get_url_string($HTTP_VARS, NULL, array('invalidsession')); // don't include invalidsession variable!
				$redirect = urlencode($PHP_SELF . (strlen($url)>0?"?$url":""));
			}
		}
		else // otherwise repass $from variable in case of incorrect login attempt...
			$redirect = $HTTP_VARS['redirect'];

		if(strlen($redirect)>0)
			$page_buffer .= "<input type=\"hidden\" name=\"redirect\" value=\"".$redirect."\">";

		// if configuration permits PHP email, allow email new password
		if($CONFIG_VARS['email.use_php_mail']!==FALSE && strlen($HTTP_VARS['uid'])>0 && $CONFIG_VARS['login.enable_new_pwd_gen']!==FALSE)
		{
			$page_buffer .= "<tr><td colspan=2 align=right class=\"footer\">".
				"<a href=\"".$PHP_SELF."?op=newpassword&uid=".urlencode($HTTP_VARS['uid'])."\">".$LANG_VARS['forgot_your_pwd']."</a>".
				"</td></tr>";
		}
		
	   $page_buffer .= "\n</table>".
			"\n</form>".
			"\n<br><p>";
		
		// Indicate we should show the signup link.
		if($CONFIG_VARS['newuser.signup_enable']!==FALSE)
		{
			$page_buffer .= "<div class=\"footer\"><a href=\"newuser.php\">"._theme_image("email.gif","",NULL,"absmiddle")."</a>".
					"<a href=\"newuser.php\">".$LANG_VARS['sign_me_up']."</a>".
					"\n</div></p>";
		}
	}//if($show_form)
	
	// Now include theme stuff here, so we can force the theme to change for new user.
	include_once("./include/theme.php");

	echo(_theme_header(replace_lang_var("site", $CONFIG_VARS['site.title'], $LANG_VARS['site_login'])));
	
	if($show_welcome)
	{
		echo("<p>".replace_lang_vars(array('site'=>$CONFIG_VARS['site.title'],
										'version'=>$CONFIG_VARS['site.version']),
										ifempty($lang_login_welcome, $LANG_VARS['login_welcome'])).
			"</p>");
	}

	echo($page_buffer);

	// many themes will ignore this call, but we make it for those that do need to refresh
	// their separate menu frame.  The original 'default' theme is one which must do this!
	if($refresh_menu)
	{
		echo(_theme_refresh_menu());
	}	
	echo(_theme_footer());
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>