<?php
/*	
 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

This script produces a table, one row per HTTP cache file, sorted by
descending expiry date (freshest file at the top, oldest at the bottom).

TODO: only print "delete all stale entries" if there are stale entries.
Tricky (ugly) to do without putting the link after the list, which would
force users to scroll to the bottom to find it.
*/
include_once("./functions/datetime.php");
include_once("./functions/sortutils.php");
include_once("./functions/filecache.php");

session_start();
if (is_opendb_valid_session())
{ 
	@set_time_limit(600);
	
	if (is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
	{
		if(file_cache_check_is_installed())
		{
			if($HTTP_VARS['op'] == 'flushexpired' || $HTTP_VARS['op'] == 'flush')
			{
				if($HTTP_VARS['op'] == 'flushexpired')
				{
					$files_deleted = file_cache_delete_expired_files('HTTP');
				}
				else if($HTTP_VARS['op'] == 'flush')
				{
					$files_deleted = file_cache_delete_files('HTTP');
				}
		
				if($files_deleted>0)
				{
					echo("<div class=\"success\">Deleted $files_deleted cache files.</div>");
					opendb_log("HTTP_CACHE: Deleted $files_deleted cache files. (update_who=".$HTTP_SESSION_VARS['user_id'].")");
				}
				else
				{
					echo("<div class=\"success\">Deleted 0 cache files.</div>");
				}
			}//if($HTTP_VARS['op'] == 'flushstale' || $HTTP_VARS['op'] == 'flush')
			
			// Do not display links if no files to operate on.
				echo("<table width=98% cellspacing=1 border=0>".
					"<tr><td align=\"center\" colspan=3>"
					."<p>[<a href=\"admin.php?type=$ADMIN_TYPE&op=flushexpired\">Delete expired cache entries</a>]&nbsp;"
					."[<a href=\"admin.php?type=$ADMIN_TYPE&op=flush\">Delete all cache entries</a>]</p>"
					."</td></tr></table>");
			
			echo("<table width=98% cellspacing=1 border=0>".
					"<tr><td class=\"navbar\" width=60%>URL</td>".
					"<td class=\"navbar\" width=20%>Cached</td>".
					"<td class=\"navbar\" width=20%>Expires</td></tr>");
					
			$results = fetch_file_cache_rs('HTTP');
			if($results)
			{
				$toggle = TRUE;
				while($file_cache_r = mysql_fetch_array($results, MYSQL_ASSOC))
				{
					if($toggle)
						$color="top";
					else
		 				$color="top2";
					$toggle = !$toggle;
					
					echo("<tr>");
						
					echo("<td class=\"$color\">"
							.wordwrap($file_cache_r['url'],80,"\n",1)
							."</td>");
							
					echo("<td align=\"center\" class=\"$color\">"
							.get_localised_timestamp($CONFIG_VARS['http_cache.datetime_mask'], $file_cache_r['cache_date'])
						 	."</td>");
					
					
					echo("<td align=\"center\" class=\"$color\">");
					if($file_cache_r['expired_ind']=='Y')
						echo("<font class=\"error\">");
					
					echo (get_localised_timestamp($CONFIG_VARS['http_cache.datetime_mask'], $file_cache_r['expire_date']));

					if($file_cache_r['expired_ind']=='Y')
						echo("</font>");
						
					echo("</td>");
							
					echo("</tr>");
				}//while
				mysql_free_result($results);
				
				echo("</table>");
			}
			else
			{
				echo("\n<tr><td colspan=3 align=center><div class=\"error\"><b>- No Files Found -</b></div></td></tr>");
			}
			echo("</table>");
			//echo(format_help_block($http_cache_help));
		}
		else//if(file_cache_check_is_installed())
		{
			echo _theme_error('File Cache table is not installed.');
		}
	}
	else
	{
		echo _theme_error($LANG_VARS['not_authorized_to_page']);
	}	
	echo _theme_footer();
}//(is_opendb_valid_session())
?>
