<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/database.php");
include_once("./functions/logging.php");
include_once("./functions/utils.php");

function file_cache_check_is_installed()
{
	// Only get one row, to save processing them.
	$query = "SELECT 'x' FROM file_cache LIMIT 0,1";
	
	// In this case the run_opendb_query() would return FALSE, if
    // table does not exist.
	$result = run_opendb_query($query);
	if($result)	
	{
		mysql_free_result($result);

		// The table exists (Does not have to have any records!)
		return TRUE;
	}

	//else
	return FALSE;
}

/*
*/
function file_cache_is_exists_url($url, $cache_type='HTTP')
{
	$query = "SELECT sequence_number FROM file_cache WHERE cache_type = '$cache_type' AND url = '".trim($url)."' AND expire_date > NOW()";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		if ($found!== FALSE)
			return $found['sequence_number'];
	}

	//else
	return FALSE;
}

/**
* Will include expired files.
*/
function fetch_file_cache_rs($cache_type='HTTP')
{
	$query = "SELECT sequence_number, url, location, content_type, content_length, UNIX_TIMESTAMP(cache_date) as cache_date, UNIX_TIMESTAMP(expire_date) as expire_date, IF(expire_date<=NOW(),'Y','N') as expired_ind ".
		"FROM file_cache ".
		"WHERE cache_type = '$cache_type' ".
		"ORDER BY expire_date ASC ";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else
		return FALSE;
}

/**
* Assumed used file_cache_is_exists_url(...) or checked expired_ind if
* using fetch_file_cache_rs so as not to return expired file.
* 
* @$include_content if TRUE, will request content as well.
*/
function fetch_file_cache_r($sequence_number)
{
	$query = "SELECT sequence_number, url, location, content_type, content_length, UNIX_TIMESTAMP(cache_date) as cache_date, UNIX_TIMESTAMP(expire_date) as expire_date ".
		"FROM file_cache ".
		"WHERE sequence_number = '$sequence_number'";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found;
	}

	//else
	return FALSE;
}

/**
* Assumed used file_cache_is_exists_url(...) or checked expired_ind if
* using fetch_file_cache_rs so as not to return expired file.
*/
function file_cache_fetch_content($sequence_number)
{
	$query = "SELECT content, gzcompress_level FROM file_cache WHERE sequence_number = '$sequence_number'";
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		if ($found!== FALSE)
		{
			if(is_numeric($found['gzcompress_level']) && $found['gzcompress_level']>0)
				return gzuncompress($found['content']);
			else
				return $found['content'];
		}
	}

	//else
	return FALSE;
}

/*
* File Cache - create cache file
* 
* This function will automatically insert the create_date and expiry_date fields
* based on the include/config.php variable $CONFIG_VARS['http_cache.lifetime']
* 
* This function will also use the include/config.php variable $CONFIG_VARS['http_cache.max_cache_size']
* to determine whether existing records need to be purged to make room for this one.
* 
* It will lock the table at the beginning of the operation to ensure everything
* is done as a single atomic operation.
*/
function file_cache_insert_file($url, $location, $content_type, $content, $cache_type='HTTP')
{
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;
	
	$url = trim($url);
	$location = trim($location);
	
	$gzcompress_level = 0;
	if(is_numeric($CONFIG_VARS['http_cache.gzcompress.level']) && $CONFIG_VARS['http_cache.gzcompress.level']>0)
	{
		$gzcompress_level = $CONFIG_VARS['http_cache.gzcompress.level'];
		$content = gzcompress($content, $gzcompress_level);
	}
	$content_length = strlen($content);
	
	if(run_opendb_query("LOCK TABLES file_cache WRITE"))
	{
		if(file_cache_is_exists_url($url, $cache_type)===FALSE)
		{
			if(is_numeric($CONFIG_VARS['http_cache.max_cache_size']))
			{
				// if current size of cache is too big, we need to reduce it.
				$total_cache_size = file_cache_fetch_cache_size($cache_type);
			
				// if total cache size + the content_length do not exceed max
				// cache size, we can just go ahead and insert the file.
				if(($total_cache_size + $content_length) >= $CONFIG_VARS['http_cache.max_cache_size'])
				{
					// if we did delete some files, we want to check if we have room or
					// not, before we go trying to make room.
					$delete_expired_files_count = file_cache_delete_expired_files($cache_type);
					// reset the total cache size.				
					if($delete_expired_files_count>0)
					{
						$total_cache_size = file_cache_fetch_cache_size($cache_type);
					}
					
					if(($total_cache_size + $content_length) >= $CONFIG_VARS['http_cache.max_cache_size'])
					{
						// if failure to make room, we have to abort.
						if(file_cache_delete_files_to_fit($content_length, $cache_type)===FALSE)
						{
							run_opendb_query("UNLOCK TABLES");
							return FALSE;
						}
					}
				}//else we have enough room.
			}
		
			$content = addslashes($content);
			
			//else insert new cache record here.
			$query = "INSERT INTO file_cache (cache_type, url, location, content_type, content_length, cache_date, expire_date, gzcompress_level, content)".
					" VALUES ('$cache_type','$url','$location','$content_type','$content_length',NOW(),".(is_numeric($CONFIG_VARS['http_cache.lifetime'])?"NOW()+ INTERVAL ".$CONFIG_VARS['http_cache.lifetime']." SECOND":"NULL").", $gzcompress_level, '$content')";

			$insert = run_opendb_query($query);
			if ($insert && mysql_affected_rows() > 0)
			{
				$new_sequence_number = mysql_insert_id();
				
				run_opendb_query("UNLOCK TABLES");
				opendb_log("Inserted file_cache record (sequence_number=$new_sequence_number, cache_type=$cache_type, url=$url, content_type=$content_type, content_length=$content_length, update_who=".$HTTP_SESSION_VARS['user_id'].")");
				return $new_sequence_number;
			}
			else
			{
				run_opendb_query("UNLOCK TABLES");
				opendb_log("Failed to insert file_cache record (cache_type=$cache_type, url=$url, content_type=$content_type, content_length=$content_length, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
				return FALSE;
			}
		}//if(file_cache_is_exists_url($url, $cache_type)!==FALSE)
		else
		{
			run_opendb_query("UNLOCK TABLES");
			
			opendb_log("Failed to insert file_cache record (cache_type=$cache_type, url=$url, content_type=$content_type, content_length=$content_length, update_who=".$HTTP_SESSION_VARS['user_id'].") [URL already exists]");
		
			// file already exists, and has not expired.
			return FALSE;
		}
	}
	else
	{
		opendb_log("Could not lock file_cache for write (update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
			
		// could not lock table.
		return FALSE;
	}
}

/*
* NOTE: Assumes file_cache lock
*/
function file_cache_fetch_cache_size($cache_type='HTTP')
{
	$query = "SELECT SUM(content_length) AS total_size FROM file_cache WHERE cache_type = '$cache_type'";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		if ($found!== FALSE)
		{
			if(is_numeric($found['total_size']))
				return $found['total_size'];
			else
				return 0;
		}
	}

	//else
	return FALSE;
}

/**
* NOTE: Assumes file_cache lock
* 
* Return number of files deleted or FALSE. Be sure to use ===FALSE, so you do not get
* confused with successful completion, but no files deleted.
*/
function file_cache_delete_expired_files($cache_type='HTTP')
{
	global $HTTP_SESSION_VARS;
	
	$query ="DELETE FROM file_cache WHERE cache_type = '$cache_type' AND expire_date <= NOW()";
	$delete = run_opendb_query($query);
	
	// still successful even if no expired records to delete.
	if( $delete )
	{
		opendb_log("Deleted expired file_cache records (cache_type=$cache_type, rows_deleted=".mysql_affected_rows().", update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return mysql_affected_rows();
	}
	else
	{
		opendb_log("Failed to delete expired file_cache records (cache_type=$cache_type, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
}

function file_cache_delete_files($cache_type='HTTP')
{
	global $HTTP_SESSION_VARS;
	
	$query ="DELETE FROM file_cache WHERE cache_type = '$cache_type'";
	$delete = run_opendb_query($query);
	
	// still successful even if no expired records to delete.
	if( $delete )
	{
		opendb_log("Deleted all file_cache records (cache_type=$cache_type, rows_deleted=".mysql_affected_rows().", update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return mysql_affected_rows();
	}
	else
	{
		opendb_log("Failed to delete all file_cache records (cache_type=$cache_type, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
}

/*
* This function assumes you have checked the file cache total size, and need
* to delete a number of files to make room.  It will start with the oldest
* files (create_date desc) and delete files with the sume of content_lengths
* equal to the present file content_length.
* 
* Note: Assumes the cache is too big to fit current file, so we have to
* reduce it by the number of files.
* 
* NOTE: Assumes file_cache lock
*/
function file_cache_delete_files_to_fit($content_length, $cache_type='HTTP')
{
	global $HTTP_SESSION_VARS;
	
	// this logic is not very efficient, because we are selecting the complete
	// table here, need to think of more efficient method of working out how
	// to clean up the table.
	// One method would be to select a row at a time, and delete that row until
	// the sum of the content lengths of the deleted rows equals the content
	// length we need for the new record, but for now will leave as is.
	$query = "SELECT sequence_number, content_length FROM file_cache ORDER BY expire_date ASC";
	$results = run_opendb_query($query);
	if($results)
	{
		$sequence_numbers = NULL;
		$cache_content_length = 0;
		while($file_cache_r = mysql_fetch_array($results, MYSQL_ASSOC))
		{
			if(is_numeric($file_cache_r['content_length']))
			{
				// save sequence number, cos we are going to delete it soon.
				$sequence_numbers[] = $file_cache_r['sequence_number'];
				$cache_content_length += $file_cache_r['content_length'];
				
				// do we have enough space yet?
				if($cache_content_length >= $content_length)
				{
					break;
				}
			}
		}
		mysql_free_result($results);
		
		// could not delete enough cache files to make room.
		if($cache_content_length >= $content_length)
		{
			if(is_not_empty_array($sequence_numbers))
			{
				// now lets delete those sequence numbers.
				$query ="DELETE FROM file_cache WHERE cache_type = '$cache_type' AND sequence_number IN(".format_sql_in_clause($sequence_numbers).")";
				$delete = run_opendb_query($query);
	
				// still successful even if no expired records to delete.
				if( $delete )
				{
					opendb_log("Deleted old file_cache records (cache_type=$cache_type, new_content_length=$content_length, rows_deleted=".mysql_affected_rows().", update_who=".$HTTP_SESSION_VARS['user_id'].")");
					return mysql_affected_rows();
				}
				else
				{
					opendb_log("Failed to old file_cache records (cache_type=$cache_type, new_content_length=$content_length, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
					return FALSE;
				}
			}
		}
		else
		{
			// file is too big for cache.
			return FALSE;
		}
	}//if($results)
	
	//else - no records to delete
	return 0;
}
?>