<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/item_attribute.php");
include_once("./functions/item.php");
include_once("./functions/item_type.php");
include_once("./functions/utils.php");
include_once("./functions/status_type.php");
include_once("./functions/widgets.php");

class Item
{
	var $_item_type;
	var $_title;
	var $_category;
	var $_attribute_rs;
	var $_instance_rs;
	var $_is_linked;
	
	function Item($is_linked_item = FALSE)
	{
		$this->_is_linked = $is_linked_item;
	}
	
	/**
	* To be considered complete the item_type and title have to be defined AND either item 
	* is a linked item, or it has at least one instance.
	*/
	function isItemCompleted()
	{
		if(strlen($this->_item_type)>0 && 
				strlen($this->_title)>0) // &&
				//strlen($this->_category)>0)
		{
			if($this->_is_linked)
				return TRUE;
			else if($this->getInstanceCount() > 0)
				return TRUE;
		}
		
		//else
		return FALSE;
	}
	
	function setItemType($s_item_type)
	{
		$this->_item_type = $s_item_type;
	}
	
	function setTitle($title)
	{
		$this->_title = $title;
	}
	
	/**
	* @param $category will convert to array if not already.
	*/
	function setCategory($category)
	{
		if(is_array($category))
			$this->_category = $category;
		else if(strlen(trim($category))>0)
			$this->_category[] = $category;
		else
			$this->_category = NULL;
	}
	
	/**
	* if $attribute_type is a lookup attribute type, the attribute_val will
	* be converted to an array.
	*/
	function addAttribute($attribute_type, $order_no, $attribute_val)
	{
		$this->_attribute_rs[] = array(
					s_attribute_type=>$attribute_type, 
					order_no=>$order_no, 
					attribute_val=>$attribute_val);
	}
	
	function addLookupAttribute($attribute_type, $order_no, $attribute_val)
	{
		// Look for an existing lookup s_attribute_type:order_no to add this value to.
		$index = -1;
		if(is_array($this->_attribute_rs))
		{
			for($i=0; $i<count($this->_attribute_rs); $i++)
			{
				if($this->_attribute_rs[$i]['s_attribute_type'] == $attribute_type && 
						$this->_attribute_rs[$i]['order_no'] == $order_no)
				{
					$index = $i;
					break;
				}
			}
		}
		
		// an existing lookup attribute val set.
		if($index != -1)
		{
			$attribute_val_r = $this->_attribute_rs[$index]['attribute_val'];
		}

		if(is_array($attribute_val))
		{
			for($i=0; $i<count($attribute_val); $i++)
			{
				// do not include duplicates.
				if(!is_array($attribute_val_r) || !in_array($attribute_val[$i], $attribute_val_r))
				{
					$attribute_val_r[] = $attribute_val[$i];
				}
			}
		}
		
		if($index != -1)
		{
			$this->_attribute_rs[$index]['attribute_val'] =& $attribute_val_r;
		}
		else
		{
			$this->_attribute_rs[] = array(
					s_attribute_type=>$attribute_type, 
					order_no=>$order_no, 
					attribute_val=>$attribute_val_r);
		}
	}
	
	function addInstance($owner_id, $status_type, $status_comment, $borrow_duration)
	{
		$this->_instance_rs[] = array(owner_id=>$owner_id, s_status_type=>$status_type, status_comment=>$status_comment, borrow_duration=>$borrow_duration);
	}
	
	function getLastOrderNo($s_attribute_type)
	{
		if(is_array($this->_attribute_rs))
		{
			for($i=count($this->_attribute_rs)-1; $i>=0; $i--)
			{
				if($this->_attribute_rs[$i]['s_attribute_type'] == $s_attribute_type)
				{
					return $this->_attribute_rs[$i]['order_no'];
				}
			}
		}
		
		//else - none found
		return NULL;
	}
	
	function getItemType()
	{
		return $this->_item_type;
	}
	
	function getTitle()
	{
		return $this->_title;
	}
	
	function getCategory()
	{
		return $this->_category;
	}
	
	function &getAttributes()
	{
		return $this->_attribute_rs;
	}
	
	function &getInstances()
	{
		return $this->_instance_rs;
	}
	
	function getInstanceCount()
	{
		if(is_array($this->_instance_rs))
			return count($this->_instance_rs);
		else
			return 0;
	}
}

class ItemImportHandler
{
	var $_errors;
	
	var $_item_obj;
	var $_linked_item_obj_rs;

	// indicator of whether we are operating on a linked item or not.  If
	// we are, then it will be the last Item in the $_linked_item_obj_rs array.
	var $_is_linked_item;

	// state info - what context are we inserting for!	
	var $_owner_id;
	
	var $_endItem_Callback_Function;
	
	// Once final endItem is called, this is set to TRUE.  Until clear() is called
	// no operations against this item are allowed.
	var $_is_item_finished;
	
	// save the s_attribute_type/order_no structure once in an array, so we
	// do not have to continually query the database.
	var $_item_type_structure_rs;
	var $_lookup_attribute_type_rs;
	
	/*
	* @param $owner_id - Will be used for item_instance insert, as well as validation
	* 					of any owner insert restrictions.
	*/
	function ItemImportHandler($owner_id, $endItem_Callback_Function = NULL)
	{
		$this->_owner_id = $owner_id;
		$this->_endItem_Callback_Function = $endItem_Callback_Function;
		
		$this->clear();
	}
	
	function addError($method, $error, $dberror = NULL)
	{
		$this->_errors[] = array('method'=>$method, 'error'=>$error, 'dbdetails'=>$dberror);
	}
	
	function getErrors()
	{
		if(is_not_empty_array($this->_errors))
		{
			for($i=0; $i<count($this->_errors); $i++)
			{
				$errors[] = $this->_errors[$i]['method'].': '.$this->_errors[$i]['error'].' '.( (strlen($this->_errors[$i]['dbdetails'])>0)?' ['.$this->_errors[$i]['dbdetails'].']':'');
			}
			
			return $errors;
		}
		else
		{
			return NULL;
		}
	}
	
	function getRawErrors()
	{
		return $this->_errors;
	}
	
	function isError()
	{
		return is_not_empty_array($this->_errors);
	}
	
	/*
	* Reset Error condition, and internal parser structures.
	*/
	function clear()
	{
		$this->_errors = NULL;
		$this->_item_obj = NULL;
		$this->_linked_item_obj_rs = NULL;
		$this->_is_linked_item = FALSE;
		$this->_is_item_finished = FALSE;
	}
	
	/**
	* Will check that all processing for the current
	* item has been completed successfully.
	* 
	* No point calling this after a 'clear()' call.
	*/
	function isItemStructureValid()
	{
		if($this->isError()!==TRUE && $this->_is_item_finished && $this->_item_obj!=NULL && $this->_item_obj->isItemCompleted())
		{
			if(is_array($this->_linked_item_obj_rs))
			{
				for($i=0; $i<count($this->_linked_item_obj_rs); $i++)
				{
					$tmpItem =& $this->_linked_item_obj_rs[$i];
					if(!$tmpItem->isItemCompleted())
					{
						return FALSE;
					}
				}
				
				//else
				return TRUE;
			}
			else
			{	
				// no linked items, so we are done.
				return TRUE;
			}
		}
		else
		{
			return FALSE;
		}
	}
	
	function getOwner()
	{
		return $this->_owner_id;
	}
	
	function &getItem()
	{
		return $this->_item_obj;
	}
	
	function &getLinkedItems()
	{
		return $this->_linked_item_obj_rs;
	}
	
	function startItem($s_item_type, $title = NULL, $category = NULL)
	{
		global $LANG_VARS;
		
		if($this->_is_item_finished)
		{
			// clear parser structures for new item.					
			$this->clear();
		}
		
		if($this->_item_obj != NULL) // we have a active parent item.
		{
			// No child item active
			if($this->_is_linked_item !== TRUE)
			{
				$this->_linked_item_obj_rs[] = new Item(TRUE);
				$this->_is_linked_item = TRUE;
					
				$tmpItem =& $this->_linked_item_obj_rs[count($this->_linked_item_obj_rs) - 1];
				// save s_item_type Structure for later use.
				if($this->_save_item_type_attrib_details($s_item_type))
				{
					$tmpItem->setItemType($s_item_type);
					$tmpItem->setTitle($title);
					$tmpItem->setCategory($category);
					return TRUE;
				}
				else
				{
					$this->addError('startItem', replace_lang_var('s_item_type', $s_item_type, $LANG_VARS['invalid_s_item_type']));
					return FALSE;
				}
			}
			else
			{
				$this->addError('startItem', $LANG_VARS['undefined_error']);
				return FALSE;
			}
		}
		else // new parent
		{
			$this->_item_obj =& new Item();
			
			// save s_item_type Structure for later use.
			if($this->_save_item_type_attrib_details($s_item_type))
			{
				$this->_item_obj->setItemType($s_item_type);
				$this->_item_obj->setTitle($title);
				$this->_item_obj->setCategory($category);
				return TRUE;
			}
			else
			{
				$this->addError('startItem', replace_lang_var('s_item_type', $s_item_type, $LANG_VARS['invalid_s_item_type']));
				return FALSE;
			}
		}
	}
	
	function setTitle($title)
	{
		global $LANG_VARS;
		
		if($this->_is_item_finished !== TRUE)
		{
			// parent item must be defined.
			if($this->_item_obj != NULL)
			{
				$this->_item_obj->setTitle($title);
			}//if($this->_item_obj != NULL)
			else
			{
				$this->addError('setTitle', $LANG_VARS['undefined_error']);
				return FALSE;
			}
		}
		else // if($this->isError() !== TRUE)
		{
			return FALSE;
		}
	}
	
	function setCategory($category)
	{
		global $LANG_VARS;
		
		if($this->_is_item_finished !== TRUE)
		{
			// parent item must be defined.
			if($this->_item_obj != NULL)
			{
				$this->_item_obj->setCategory($category);
			}//if($this->_item_obj != NULL)
			else
			{
				$this->addError('setCategory', $LANG_VARS['undefined_error']);
				return FALSE;
			}
		}
		else // if($this->isError() !== TRUE)
		{
			return FALSE;
		}
	}

	/**
	*/
	function itemInstance($s_status_type = NULL, $status_comment = NULL, $borrow_duration = NULL)
	{
		global $LANG_VARS;
		
		if($this->_is_item_finished !== TRUE)
		{
			// parent item must be defined.
			if($this->_item_obj != NULL)
			{
				// not a child item
				if($this->_is_linked_item !== TRUE)
				{
					$this->_item_obj->addInstance($this->_owner_id, $s_status_type, $status_comment, $borrow_duration);
				}// child item is current!!!
				else
				{
					$this->addError('itemInstance', $LANG_VARS['undefined_error']);
					return FALSE;
				}
			}//if($this->_item_obj != NULL)
			else
			{
				$this->addError('itemInstance', $LANG_VARS['undefined_error']);
				return FALSE;
			}
		}
		else // if($this->isError() !== TRUE)
		{
			return FALSE;
		}
	}

	/*
	* 
	*/
	function itemAttribute($s_attribute_type, $order_no, $attribute_val)
	{
		global $LANG_VARS;
		
		if($this->_is_item_finished !== TRUE)
		{
			if($this->_item_obj != NULL)
			{
				if($this->_is_linked_item)
				{
					$tmpItem =& $this->_linked_item_obj_rs[count($this->_linked_item_obj_rs) - 1];
				}
				else
				{
					$tmpItem =& $this->_item_obj;
				}
				
				// If no $order_no provided.
				if($this->is_lookup_attribute_type($s_attribute_type))
				{
					if(!is_numeric($order_no))
					{
						$last_order_no = $tmpItem->getLastOrderNo($s_attribute_type);
						if(is_numeric($last_order_no))
							$order_no = $last_order_no;
						else
							$order_no = $this->get_s_item_attribute_type_next_order_no($tmpItem->getItemType(), $s_attribute_type);
					}
							
					if(is_numeric($order_no))
					{
						if(is_array($attribute_val))
							$tmp_attribute_val_r = $attribute_val;
						else
							$tmp_attribute_val_r[] = $attribute_val;
						
						for($i=0; $i<count($tmp_attribute_val_r); $i++)
						{
							// do not include duplicates.
							if($this->is_exists_lookup_value($s_attribute_type, $tmp_attribute_val_r[$i]))
							{
								$attribute_val_r[] = $tmp_attribute_val_r[$i];
							}
						}
						
						$tmpItem->addLookupAttribute($s_attribute_type, $order_no, $attribute_val_r);
						return TRUE;
					}//if(is_numeric($order_no))
					else
					{
						return FALSE;
					}
				}
				else
				{
					if(!is_numeric($order_no))
					{
						$last_order_no = $tmpItem->getLastOrderNo($s_attribute_type);
						if(is_numeric($last_order_no))
							$order_no = $this->get_s_item_attribute_type_next_order_no($tmpItem->getItemType(), $s_attribute_type, $last_order_no);
						else
							$order_no = $this->get_s_item_attribute_type_next_order_no($tmpItem->getItemType(), $s_attribute_type);
					}
							
					if(is_numeric($order_no))
					{
						$tmpItem->addAttribute($s_attribute_type, $order_no, $attribute_val);
						return TRUE;
					}//if(is_numeric($order_no))
					else
					{
						return FALSE;
					}
				}
			}//if($this->_item_obj != NULL)
			else
			{
				$this->addError('itemAttribute', $LANG_VARS['undefined_error']);
				return FALSE;
			}
		}
		else // if($this->isError() !== TRUE)
		{
			return FALSE;
		}
	}

	/*
	*/
	function endItem()
	{
		global $LANG_VARS;
		
		if($this->_is_item_finished !== TRUE)
		{
			if($this->_item_obj != NULL)
			{
				if($this->_is_linked_item)
				{
					$this->_is_linked_item = FALSE;
				}
				else
				{
					// The item is finished, no more additions are allowed, until the
					// startItem method is called again.
					$this->_is_item_finished = TRUE;
				
					// perform callback here!!!
					if(strlen($this->_endItem_Callback_Function)>0)
					{
						// perform callback!
						$callback_function = $this->_endItem_Callback_Function;
						if(function_exists($callback_function))
						{
							$callback_function($this);
						}
					}
					
					// else - end of parent item.
					return TRUE;
				}
			}
			else
			{
				$this->addError('endItem', $LANG_VARS['undefined_error']);
				return FALSE;
			}
		}
		else // if($this->isError() !== TRUE)
		{
			return FALSE;
		}
	}
	
	function is_lookup_attribute_type($s_attribute_type)
	{
		// save unique s_attribute_type structure.
		if(!isset($this->_lookup_attribute_type_rs[$s_attribute_type]))
		{
			if(is_lookup_attribute_type($s_attribute_type))
			{
				$results = fetch_s_attribute_type_lookup_rs($s_attribute_type, FALSE);
				if($results)
				{
					while($lookup_attribute_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
					{
						$this->_lookup_attribute_type_rs[$s_attribute_type][] = $lookup_attribute_type_r['value'];
					}
					mysql_free_result($results);
				}
			}
			else
			{
				// no lookups.
				$this->_lookup_attribute_type_rs[$s_attribute_type] = FALSE;
			}
		}
		
		if(is_not_empty_array($this->_lookup_attribute_type_rs[$s_attribute_type]))
		{
			return TRUE;
		}
		else //$this->_lookup_attribute_type_rs[$s_attribute_type] === FALSE
		{
			return FALSE;
		}
	}
	
	/**
	* Assumes $s_attribute_type is_lookup_attribute_type
	*/
	function is_exists_lookup_value($s_attribute_type, $attribute_val)
	{
		if(is_not_empty_array($this->_lookup_attribute_type_rs[$s_attribute_type]))
		{
			if(in_array($attribute_val, $this->_lookup_attribute_type_rs[$s_attribute_type]))
			{
				return TRUE;
			}
		}
		
		//else
		return FALSE;
	}
	
	/**
	* Assumes that this method will NOT be called for lookup attributes where $last_order_no is provided.
	*/
	function get_s_item_attribute_type_next_order_no($s_item_type, $s_attribute_type, $last_order_no = NULL)
	{
		if(is_not_empty_array($this->_item_type_structure_rs[$s_item_type]))
		{
			$start_index = 0;
			if(is_numeric($last_order_no))
			{
				for($i=0; $i<count($this->_item_type_structure_rs[$s_item_type]); $i++)
				{
					if(strcasecmp($this->_item_type_structure_rs[$s_item_type][$i]['s_attribute_type'], $s_attribute_type)===0 && 
								$this->_item_type_structure_rs[$s_item_type][$i]['order_no'] == $last_order_no)
					{
						$start_index = ++$i; // need to move past this one.
						break;
					}
				}
			}
			
			for($i=$start_index; $i<count($this->_item_type_structure_rs[$s_item_type]); $i++)
			{
				// look for next attribute type.
				if(strcasecmp($this->_item_type_structure_rs[$s_item_type][$i]['s_attribute_type'], $s_attribute_type)===0)
				{
					return $this->_item_type_structure_rs[$s_item_type][$i]['order_no'];
				}
			}
			
			//else - what else can I do here!
			return -1;
		}
		else
		{
			return FALSE;
		}
	}
	
	// return FALSE if item does not exist.
	function _save_item_type_attrib_details($s_item_type)
	{
		// save the structure of the item type once, including whether s_attribute_type is a lookup or not.
		if(is_empty_or_not_array($this->_item_type_structure_rs[$s_item_type]))
		{
			if(is_exists_item_type($s_item_type))
			{
				$results = fetch_item_attribute_type_rs($s_item_type, TRUE);
				if($results)
				{
					while($item_attribute_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
					{
						// save s_item_attribute_type structure.
						$this->_item_type_structure_rs[$s_item_type][] = $item_attribute_type_r;
					}
					mysql_free_result($results);
				}
				
				return TRUE;
			}
			else
			{
				// s_item_type does not exist.
				return FALSE;
			}
		}
		else
		{
			return TRUE;
		}
	}
}
?>