<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


// Functions for use with language functionality

/**
	All we need to do is check if there is a 
	matching lang/$language.inc.php script.
	
	When user level languages are added, there
	will be a new languages table added as well,
	but until then, we do not have to bother
	with that.
*/
function is_legal_language($language)
{
	if(!starts_with($language, "local.") && @file_exists("./lang/".$language.".inc.php"))
		return true;
	else
		return false;
}

/**
	Generate a list of user languages
*/
function get_language_r()
{
	$handle=opendir('lang');
	while ($lang = readdir($handle))
    {
		// Ensure valid language name.  
		if ( strlen($lang)<=(20+strlen('.inc.php')) && !preg_match("/^\./",$lang) && !starts_with($lang, "local.") && preg_match("/(.*).inc.php$/",$lang,$regs))
		{
			$language[] = $regs[1];
		}
	}
	closedir($handle);
    
    if(is_array($language) && count($language)>0)
		return $language;
	else // empty array as last resort.
		return array();
}

/**
	I am not sure that str_replace is currrently working properly,
	where find and replace are both arrays, so we are forcing it
	here.

	@param $arg1
	@param $arg2
	@param $arg3

	Where $arg1 && $arg2 are both arrays, we assume the old functionality,
	where we specify a list of variables to find and a matching list of
	values to replace.  $arg3 is the $LANG_VARS;

	Otherwise the new functionality allows for $arg1 to be the array,
	and its keys to be the search variables.  The matching values are
	what is being replaced.  $arg2 is the $LANG_VARS.
*/ 
function replace_lang_vars($arg1, $arg2, $arg3=NULL)
{
	// Original functionality.
	if(is_array($arg1) && is_array($arg2))
	{
		// This test in case the language variable is not defined.
		if(strlen($arg3)>0)
		{
			for ($j=0; $j<count($arg1); $j++)
			{
				if(strlen($arg1[$j])>0)
				{
					if(strlen($arg2[$j])>0)
						$arg3 = str_replace("{".$arg1[$j]."}", $arg2[$j], $arg3);
					else
						$arg3 = str_replace("{".$arg1[$j]."}", "", $arg3);
				}
			}
		}
		// else
		return $arg3;
	}
	else // New functionality - the first argument keys will be used as the find arguments!
	{
		// This test in case the language variable is not defined.
		if(strlen($arg2)>0)
		{
			while(list($key,$value) = @each($arg1))
			{
				if(strlen($value)>0)
					$arg2 = str_replace("{".$key."}", $value, $arg2);
				else
					$arg2 = str_replace("{".$key."}", "", $arg2);
			}
		}
		//else
		return $arg2;
	}
}

/**
	Replace a single value.
*/
function replace_lang_var($find, $replace, $langvar)
{
	return str_replace("{".$find."}", $replace, $langvar);
}

/**
	Any \n will be expanded to actual newlines using this function.  For some
	reason strings surrounded by single quotes do not expand the \n, but they
	are treated as actual '\n' two character sequences.
*/
function expand_langvar_newlines($langvar)
{
	return str_replace("\\n", "\n", $langvar);
}
?>