<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// Set error reporting to something OpenDb is capable of handling
$_OPENDB_ERROR_REPORTING = error_reporting(E_ALL & ~E_NOTICE);

// In case session handler error
//ini_set('session.save_handler', 'files'); 

// --------------------------------------------------------------------------
// This script contains any code that needs to be executed at the start of
// each and every runnable script.
// --------------------------------------------------------------------------

include_once("./functions/http.php");
include_once("./functions/utils.php");
include_once("./functions/auth.php");

// Include the config file here instead.
include_once("./include/config.php");

//---------------------------------------------------------------------
// Now include the local site's configuration file, which will override
// anything we've set above.  This saves administrators having to
// re-edit this file after they upgrade OpenDb.
//---------------------------------------------------------------------
if(file_exists("./include/local_config.php"))
{
	include_once("./include/local_config.php");
}

// OpenDb will not work with this on!!! 
if(get_magic_quotes_runtime())
{
	set_magic_quotes_runtime(false);
	$_OPENDB_MAGIC_QUOTES_RUNTIME=TRUE;
}

// Only if $PHP_SELF is not already defined.
if(!isset($PHP_SELF))
{
	// get_http_env is a OpenDb function!
	$PHP_SELF = get_http_env("PHP_SELF");
}

// We want all the HTTP variables into the $HTTP_VARS array, so
// we can reference everything from the one place.
if(!empty($HTTP_GET_VARS))
{
	$HTTP_VARS = $HTTP_GET_VARS;
}
else if(!empty($HTTP_POST_VARS))
{
	$HTTP_VARS = $HTTP_POST_VARS;
}
else if(!empty($_GET))
{
	$HTTP_VARS = $_GET;
}
else if(!empty($_POST))
{
	$HTTP_VARS = $_POST;
	
	// Now do the upload array if applicable.
	if (!empty($_FILES))
	{
		// For some stupid reason the $HTTP_POST_FILES array
		// may not be defined for later versions (4.2!) of 
		// php so we make a reference to the $_FILES 
		// manually in case.
		if(is_empty_array($HTTP_POST_FILES))
			$HTTP_POST_FILES = $_FILES;
	}
}

// Strip all slashes from this array.
if(get_magic_quotes_gpc())
{
	//
	// Only tested with normal $HTTP_VARS arrays which generally will
	// not go deeper than 2 levels in OpenDb.
	//
	function stripslashes_array($array)
	{ 
		$rs = array(); 
		while (list($key,$val) = @each($array))
		{
			if(is_array($array[$key]))
			{
				$rs[$key] = stripslashes_array($array[$key]);
			}
			else
			{
				$rs[$key] = stripslashes($val); 
			}			
		} 
		return $rs; 
	}
	$HTTP_VARS = stripslashes_array($HTTP_VARS);
}

// Buffer output for possible pushing through ob_gzhandler handler
if($CONFIG_VARS['output_buffer.enable'] === TRUE)
{
	// TODO: Need to check that browser supports the encoding: 
	//	strpos(get_http_env('HTTP_ACCEPT_ENCODING'), 'gzip')!==FALSE
	
	// It appears as though ob_start does its own function_exists check, and ignores callback if not defined.
	if(strlen($CONFIG_VARS['output_buffer.handler'])>0)
		ob_start($CONFIG_VARS['output_buffer.handler']);
	else
		ob_start();
}
	
// if site is disabled don't do any variable processing.
if($CONFIG_VARS['site.enable']!==FALSE)
{
	// Restrict cookie to site host and path.
	if($CONFIG_VARS['site.restrict_session_cookie_to_host_path']===TRUE)
	{
		session_set_cookie_params(
					0, 
					get_site_path(),
					get_site_host());
	}

	// Do not even include the functions if turned off.
	if($CONFIG_VARS['session_handler.enable'] === TRUE)
	{
		// Ensure we have a complete connection definition for the session_handler table.
		$CONFIG_VARS['session_handler.host'] = ifempty($CONFIG_VARS['session_handler.host'],$CONFIG_VARS['db_server.host']); 
		$CONFIG_VARS['session_handler.dbname'] = ifempty($CONFIG_VARS['session_handler.dbname'],$CONFIG_VARS['db_server.dbname']); 
		$CONFIG_VARS['session_handler.username'] = ifempty($CONFIG_VARS['session_handler.username'],$CONFIG_VARS['db_server.username']); 
		$CONFIG_VARS['session_handler.passwd'] = ifempty($CONFIG_VARS['session_handler.passwd'],$CONFIG_VARS['db_server.passwd']); 
		$CONFIG_VARS['session_handler.debug-sql'] = ifempty($CONFIG_VARS['session_handler.debug-sql'],$CONFIG_VARS['db_server.debug-sql']); 
	
		// The default table is 'php_session'
		$CONFIG_VARS['session_handler.session_table'] = ifempty($CONFIG_VARS['session_handler.session_table'],'php_session');

		// Include the session handling functions here.
		require_once("./include/session.php");
	}

	// do not attempt to start a session if site is disabled.

	// We want to start the session here, so we can get access to the
	// $HTTP_SESSION_VARS properly.
	session_start();

	// Just in case redefine $HTTP_SESSION_VARS.
	if(!empty($_SESSION))
	{
		if(empty($HTTP_SESSION_VARS))
			$HTTP_SESSION_VARS = $_SESSION;
	}

	// Only do public access if no current login exists
	if(!is_opendb_valid_session())
	{
		if($CONFIG_VARS['site.public_access.enable']===TRUE)
		{
			if(strlen($HTTP_SESSION_VARS['user_id'])==0 || 
						$HTTP_SESSION_VARS['user_id'] === $CONFIG_VARS['site.public_access.user_id'])
			{
				$user_r = fetch_user_r($CONFIG_VARS['site.public_access.user_id']);
				if(is_not_empty_array($user_r))
				{
					$HTTP_SESSION_VARS['user_id'] = $user_r['user_id'];
					$HTTP_SESSION_VARS['user_theme'] = $user_r['theme'];
					$HTTP_SESSION_VARS['user_language'] = $user_r['language'];
					$HTTP_SESSION_VARS['user_type'] = $user_r['type'];
				}
				else
				{
					$HTTP_SESSION_VARS['user_id'] = NULL;
					$HTTP_SESSION_VARS['user_theme'] = NULL;
					$HTTP_SESSION_VARS['user_language'] = NULL;
					$HTTP_SESSION_VARS['user_type'] = NULL;
				}
				unset($user_r);
			}
			else
			{
				// otherwise disable public access for this page request.
				$CONFIG_VARS['site.public_access.enable'] = FALSE;
			}
		}
	}
}//if($CONFIG_VARS['site.enable']!==FALSE)
?>