<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/database.php");
include_once("./functions/auth.php");
include_once("./functions/logging.php");

include_once("./functions/user.php");
include_once("./functions/datetime.php");
include_once("./functions/borrowed_item.php");
include_once("./functions/listutils.php");
include_once("./functions/HTML_Listing.class.inc");

if($CONFIG_VARS['site.enable']!==FALSE)
{
	session_start();
	if (is_opendb_valid_session())
	{ 
		if (is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
		{
			if($HTTP_VARS['mode'] == 'printable')
			{
				if(ifempty($HTTP_VARS['content_type'],'HTML') == 'HTML')
				{
					echo(_theme_header($LANG_VARS['user_list']));
				}
	
				switch($HTTP_VARS['content_type'])
				{
					//case 'PDF':
					//	break;
					default:
						$listingObject =& new HTML_Listing($PHP_SELF, $HTTP_VARS, $HTTP_VARS['mode']);
				}
			}
			else
			{
				echo(_theme_header($LANG_VARS['user_list']));
				echo("<h2>".$LANG_VARS['user_list']."</h2>");
				
				$listingObject =& new HTML_Listing($PHP_SELF, $HTTP_VARS, $HTTP_VARS['mode']);
				$listingObject->setCheckBoxColumnAndInitList('user_id_rs', $CONFIG_VARS['email.use_php_mail']!==FALSE, $LANG_VARS['no_users_checked']);
			}
			
			$listingObject->startListing();
	
			$listingObject->addHeaderColumn($LANG_VARS['user'], 'user_id');
			if($HTTP_VARS['mode'] != 'printable')
			{
				$listingObject->addHeaderColumn($LANG_VARS['action']);
			}
			$listingObject->addHeaderColumn($LANG_VARS['user_type'], 'type');
			$listingObject->addHeaderColumn($LANG_VARS['last_visit'], 'lastvisit');
			
			if(is_numeric($listingObject->getItemsPerPage()))
			{
				$listingObject->setTotalItems(fetch_user_cnt(NULL, TRUE));
				if($listingObject->getTotalItemCount()>0)
				{
					$result = fetch_user_rs(
							NULL, //$user_types
							$listingObject->getCurrentOrderBy(), 
							$listingObject->getCurrentSortOrder(),
							TRUE, //$include_deactivated_users
							NULL, //$exclude_user
							$listingObject->getStartIndex(),
							$listingObject->getItemsPerPage());
				}
			}
			else
			{
				$result = fetch_user_rs(
							NULL, //$user_types
							$listingObject->getCurrentOrderBy(), 
							$listingObject->getCurrentSortOrder(),
							TRUE); //$include_deactivated_users
			}
			
			if($result)
			{
				while ($user_r = mysql_fetch_array($result))
				{
					$listingObject->startRow();
	
					// checkbox
					if($listingObject->isCheckBoxColumn())
					{
						$listingObject->addColumn($user_r['user_id']);
					}
					
					$user_name = replace_lang_vars(
									array('fullname'=>str_replace(" ", "&nbsp;", $user_r['fullname']), 'user_id'=>$user_r['user_id']), 
									$LANG_VARS['user_name']);
					
					$redirectUrl = get_url_string(
										$HTTP_VARS,
										NULL, //extra
										array('internal_link', 'redirect_url', 'redirect_link', 'subject', 'user_id_rs', 'checked_user_id_rs', 'checked_user_id_rs_list'));//exclude
										
					$redirect_link = urlencode($LANG_VARS['back_to_user_listing']);			
					if(strlen($redirectUrl)>0)
						$redirect_url = urlencode("$PHP_SELF?$redirectUrl");
					else
						$redirect_url = urlencode($PHP_SELF);
					
					if($HTTP_VARS['mode'] != 'printable')
						$listingObject->addColumn('<a href="user_address.php?uid='.$user_r['user_id'].'&user_listing_link=y&listing_url_vars='.$redirect_url.'">'.$user_name.'</a>');
					else
						$listingObject->addColumn($user_name);
	
					if($HTTP_VARS['mode'] != 'printable')
					{
						$action_links_rs = NULL;
						$action_links_rs[] = array(url=>'user_admin.php?op=edit&user_id='.$user_r['user_id'],img=>'edit.gif',text=>$LANG_VARS['edit']);
	
						if(is_user_active($user_r['user_id']))
						{
							if($user_r['user_id'] != $HTTP_SESSION_VARS['user_id'])
							{
								if($CONFIG_VARS['user_admin.user_delete_support'] === TRUE)
									$action_links_rs[] = array(url=>'user_admin.php?op=delete&user_id='.$user_r['user_id'],img=>'delete.gif',text=>$LANG_VARS['delete_user']);
								else if($CONFIG_VARS['user_admin.user_delete_support'] === 'deactivate')
									$action_links_rs[] = array(url=>'user_admin.php?op=deactivate&user_id='.$user_r['user_id'],img=>'delete.gif',text=>$LANG_VARS['deactivate_user']);
							}
						}
						else//if(is_user_active($user_r['user_id']))
						{
							$action_links_rs[] = array(url=>'user_admin.php?op=activate&user_id='.$user_r['user_id'],img=>'undelete.gif',text=>$LANG_VARS['activate_user']);
						}
						$action_links_rs[] = array(url=>'email.php?op=send_to_uid&uid='.$user_r['user_id'].'&subject='.urlencode($LANG_VARS['no_subject']).'&redirect_link='.$redirect_link.'&redirect_url='.$redirect_url,img=>'email.gif',text=>$LANG_VARS['send_email']);
						
						$listingObject->addActionColumn(
								$action_links_rs);
					}
					
					$listingObject->addColumn(
							(is_user_active($user_r['user_id'])?get_usertype_description($user_r['type']):$LANG_VARS['deactivated']));
							
					$listingObject->addColumn(
							(strlen($user_r['lastvisit'])>0?get_localised_timestamp($CONFIG_VARS['user_admin.datetime_mask'],$user_r['lastvisit']):$LANG_VARS['never_logged_in']));
					
					$listingObject->endRow();
				}
				mysql_free_result($result);
			} //if($result)
			
			if($HTTP_VARS['mode'] != 'printable')
			{	
				if($CONFIG_VARS['email.use_php_mail']!==FALSE)
				{
					$listingObject->addListOpAction(
									$LANG_VARS['email_users'], 
									'email.php', 
									'send_to_uids', 
									$listingObject->getCheckedListCount() == 0);
				}
				
				while(list(,$help) = @each($LANG_VARS['user_listing_help']))
				{
					$listingObject->addHelpEntry($help);
				}
			}
			
			$listingObject->endListing();
			
			if($HTTP_VARS['mode'] != 'printable' || ifempty($HTTP_VARS['content_type'],'HTML') == 'HTML')
			{
				echo(_theme_footer());
			}
		}//not an administrator or own user.
		else
		{
			echo _theme_header($LANG_VARS['not_authorized_to_page']);
			echo _theme_error($LANG_VARS['not_authorized_to_page']);
			echo(_theme_footer());
		}	
	}
	else
	{
		// invalid login, so login instead.
		include("./login.php");
	}
}//if($CONFIG_VARS['site.enable']!==FALSE)
else
{
	echo _theme_header($LANG_VARS['site_is_disabled'], FALSE);
	echo _theme_error($LANG_VARS['site_is_disabled']);
	echo _theme_footer();
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
