<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/utils.php");
include_once("./functions/http.php");
include_once("./functions/theme.php");
include_once("./functions/item_attribute.php");
include_once("./functions/item_type_group.php");
include_once("./functions/thumbnails.php");

function get_cover_image($imageurl, $prompt = NULL, $override_thumbnailurlsize = NULL, $default_thumbnailurlsize = NULL, $default_imageurlsize = NULL, $include_popup_link = FALSE)
{
	$image_r = get_cover_image_r($imageurl, $override_thumbnailurlsize, $default_thumbnailurlsize, $default_imageurlsize);
	if($image_r !== FALSE)
	{
		$imageBlock = '';
		
		if($include_popup_link)
		{
			$imageBlock .= "<a href=\"javascript:popup('".htmlspecialchars($image_r['imageurl'])."','".($image_r['imageurlsize']['width']+20)."', '".($image_r['imageurlsize']['height']+25)."')\">";
		}
		
		$imageBlock .= "<img src=\"".(strlen($image_r['thumbnailurl'])>0?$image_r['thumbnailurl']:$image_r['imageurl'])."\" border=0 title=\"".htmlspecialchars($prompt)."\" ";
		
		if(is_numeric($image_r['thumbnailurlsize']['width']))
			$imageBlock .= ' width="'.$image_r['thumbnailurlsize']['width'].'"';
		if(is_numeric($image_r['thumbnailurlsize']['height']))
			$imageBlock .=  ' height="'.$image_r['thumbnailurlsize']['height'].'"';
		
		$imageBlock .= ">";
		
		if($include_popup_link)
			$imageBlock .= "</a>";
			
		return $imageBlock;
	}
	else
	{
		return FALSE;
	}
}

/**
* @param $imageurl
* @param $override_thumbnailurlsize - the size of the thumbnail, even where a thumbnail file itself
* 									exists, this value will cause the thumbnail to be dithered in the
* 									browser.
* @param $default_thumbnailurlsize
*/
function get_cover_image_r($imageurl, $override_thumbnailurlsize = NULL, $default_thumbnailurlsize = NULL)
{
	global $CONFIG_VARS;
	
	// No need to check_url() as we will show a broken image if not found.
	if(strlen($imageurl)>0 && ( (is_url_absolute($imageurl)) || file_exists($imageurl) ) )
	{
		// need to work out whether this image is a cover image, or a no-image replacement
		if(substr($CONFIG_VARS['item_input.item_attr_save_dir'],-1) == '/')
			$itemFilesDir = substr($CONFIG_VARS['item_input.item_attr_save_dir'],0,-1);
		else
			$itemFilesDir = $CONFIG_VARS['item_input.item_attr_save_dir'];
		
		$thumbnailimgurl = NULL;
		
		$thumbnailurlsize = NULL;
		$imageurlsize = NULL;

		if(file_exists($imageurl))
		{
			$filename = trim(basename($imageurl));
			
			// standard cover, so go looking for thumbnail
			if(file_exists($itemFilesDir.'/'.$filename))
			{
				$size = @getimagesize($itemFilesDir.'/'.$filename);
				if(is_array($size))
				{
					$imageurlsize = array(width=>$size[0], height=>$size[1]);
				}
				
				// check if a thumbnail exists and display that in item_display.
				$thumbnailimgurl = $itemFilesDir.'/'.get_thumbnail_filename($filename);
			
				if(file_exists($thumbnailimgurl))
				{
					$size = @getimagesize($thumbnailimgurl);
					if(is_array($size))
					{
						$thumbnailurlsize = array(width=>$size[0], height=>$size[1]);
					}
				}
				else
				{
					// no thunbnail!!
					$thumbnailimgurl = NULL;
				
					if($default_thumbnailurlsize!=NULL)
						$thumbnailurlsize = $default_thumbnailurlsize;
					else
						$thumbnailurlsize = array(width=>100, height=>140);
				}
			}
			else //should be theme file and we should get the size of the file
			{
				$size = @getimagesize($imageurl);
				if(is_array($size))
				{
					$imageurlsize = array(width=>$size[0], height=>$size[1]);
					$thumbnailurlsize = $imageurlsize;
				}
			}
		}// else - URL reference
		else
		{
			if($default_imageurlsize!=NULL)
				$imageurlsize = $default_imageurlsize;
			else
				$imageurlsize = array(width=>400, height=>300);
				
			$thumbnailurlsize = $imageurlsize;
		}
		
		// override thumbnail size as long thumbnail is not smaller than specified dimensions.
		if($override_thumbnailurlsize != NULL)
		{
			if($thumbnailurlsize['width'] >= ifempty($override_thumbnailurlsize['width'],$thumbnailurlsize['width']) &&
							$thumbnailurlsize['height'] >= ifempty($override_thumbnailurlsize['height'],$thumbnailurlsize['height']))
			{
				$thumbnailurlsize['width'] = $override_thumbnailurlsize['width'];
				$thumbnailurlsize['height'] = $override_thumbnailurlsize['height'];
			}
		}
		
		// format for external access.
		if($CONFIG_VARS['http.stream_external_images']!==FALSE && 
			(is_empty_array($CONFIG_VARS['http.stream_external_images_domain_list']) || 
				is_uri_domain_in_list($imageurl, $CONFIG_VARS['http.stream_external_images_domain_list'])))
		{
			$imageurl = 'external.php?op=streamurl&url='.urlencode($imageurl);
		}
		
		return array(
				'imageurl'=>$imageurl,
				'imageurlsize'=>$imageurlsize,
				'thumbnailurl'=>$thumbnailimgurl,
				'thumbnailurlsize'=>$thumbnailurlsize);
	}
	else
	{
		// no cover image generated.
		return FALSE;
	}
}

/**
	Will split up a 'item_id_instance_no' value into
	its component item_id / instance_no or return FALSE.

	Format of input parameter:
		{item_id}_{instance_no}
*/
function get_item_id_and_instance_no($item_id_instance_no)
{
	if(strlen($item_id_instance_no)>0)
	{
		$splitidx = strpos($item_id_instance_no, "_");
    	if($splitidx !== FALSE)
		{
			$item_id = substr($item_id_instance_no,0,$splitidx);
			$instance_no = substr($item_id_instance_no,$splitidx+1);
			if(is_numeric($item_id) && is_numeric($instance_no))
				return array('item_id'=>$item_id,'instance_no'=>$instance_no);
		}
	}

	//else
	return FALSE;
}

/*
* Return the Key of the correct config for s_item_type
* 
* Check for a $config_var[$s_item_type]
* Check for a $config_var[$s_item_type_group]
* Check for a $config_var['DEFAULT']
* Otherwise return NULL
*/
function get_item_type_config_key($s_item_type_group, $s_item_type, $config_var)
{
	// Don't bother if it not even an array.
	if(is_array($config_var))
	{
		// Look for item_type_group first!
		if(strlen($s_item_type_group)>0 && isset($config_var[$s_item_type_group]))
		{
			return $s_item_type_group;
		}
		
		if(strlen($s_item_type)>0)
		{
			if(isset($config_var[$s_item_type]))
			{
				return $s_item_type;
			}

			$item_type_group_r = fetch_item_type_groups_for_item_type_r($s_item_type);
			if(is_array($item_type_group_r))
			{
				reset($item_type_group_r);
				while(list(,$group) = each($item_type_group_r))
				{
					// looking for first group, even though there may be more than one.
					if(isset($config_var[strtolower($group)]))
					{
						return strtolower($group);
					}
					else if(isset($config_var[strtolower($group)]))
					{
						return $group;
					}
				}
			}
		}//no s_item_type
			
		if(isset($config_var['DEFAULT']))
			return 'DEFAULT';
	}
	
	//else
	return NULL;
}

/**
	Multiple select checkbox javascript here.

	Currently this function only works for single form pages.
*/
function get_navigation_javascript()
{
	return "<script language=\"JavaScript\">
		<!-- // hide from stupid browsers
		
		// Restrict listing to a particular letter.
		function restrictLetter(form, letter)
		{
			// Must reset page numbers for this operation
			form.page_no.value = '1';
			form.letter.value = letter;
			form.submit();
		}
		
		function toggleSubmit(form)
		{
			form.submit();
		}
		
		function doInternalOperation(form, operation)
		{
			form.op.value = operation;
			form.internal_link.value = 'true';
			form.submit();
		}
		
		function doOperation(form, script_uri, operation)
		{
			form.action = script_uri;
			form.op.value = operation;
			form.page_no.value = '';
			form.internal_link.value = '';
			form.submit();
		}
		
		// Restrict listing to a particular letter.
		function restrictSubmit(form)
		{
			// Must reset page numbers for this operation
			form.page_no.value = '1';
			form.submit();
		}
		
		// Modify sort order of items.
		function sortOrder(form, order_by, sortorder)
		{
			// Must reset page numbers for this operation
			form.page_no.value = '1';
			form.order_by.value = order_by;
			form.sortorder.value = sortorder;
			form.submit();
		}
		
		// Navigate to page function.
		function gotoPage(form, page_no)
		{
			form.page_no.value = page_no;
			form.submit();
		}
		// -->
		</script>";
}

/**
	Multiple select checkbox javascript here.
*/
function get_checked_javascript()
{
	return "<script language=\"JavaScript\">
		<!-- // hide from stupid browsers
		function doChecks(checked, form, cbname)
		{
			for (var i=0; i < form.length; i++)
			{
				if (form.elements[i].type.toLowerCase() == 'checkbox' && form.elements[i].name == cbname)
					form.elements[i].checked = checked;
			}
		}

		// At least one element must be checked.
		function isChecked(form, cbname)
		{
			for (var i=0; i < form.length; i++)
			{
				if (form.elements[i].type.toLowerCase() == 'checkbox' && form.elements[i].name == cbname && form.elements[i].checked)
					return true;
			}
			//else
			return false;
		}
		// -->
		</script>";
}

/**
	Will merge values of the arrays so that any values in $new_item_array are 
	added to $old_item_array if they are not found.  This function ignores the
	array keys, as they are assumed to be numeric.
*/
function process_array($old_item_array, $new_item_array)
{
	// Unless both are arrays there is nothing to do!
	if(is_not_empty_array($old_item_array) && is_not_empty_array($new_item_array))
	{
		reset($old_item_array);									
		while( list(,$value) = each($new_item_array))
		{
			if(!in_array($value, $old_item_array))
			{
				array_push($old_item_array, $value);
			}
		}
		return $old_item_array;
	}
	else if(is_not_empty_array($old_item_array))
	{
		return $old_item_array;								
	}
	else if(is_not_empty_array($new_item_array))
	{
		return $new_item_array;
	}
	else
		return NULL;
}

/**
	Assumes all arrays are indexed by integer and are not more
	than two dimensions deep.
	
	Will return a new $old_item_array, with any values removed, that are found in 
	$checked_item_array but not in $new_item_array.
*/
function remove_array_values($old_item_array, $new_item_array, $checked_item_array)
{
	// In order to work out what to remove from the $session_array, the $old_item_array
	// must exist.
	if(is_not_empty_array($session_array) && is_not_empty_array($checked_item_array))
	{
		$new_array = array();
	
		reset($old_item_array);
		while(list(,$value) = each($old_item_array))
		{
			// $value must exist in $old_item_array.  If $new_item_array is not an array, or the 
			// $value is not found, remove from $session_array
			if( !( in_array($value, $checked_item_array) && @!in_array($value, $new_item_array) ))
			{
				array_push($new_array, $value);
			}			
		}
		return $new_array;
	}
	else
		return $old_item_array;		
}

/*
* Any values found in $item_array, should be removed from $old_item_array
*/
function minus_array_values($old_item_array, $item_array)
{
	// In order to work out what to remove from the $session_array, the $old_item_array
	// must exist.
	if(is_not_empty_array($old_item_array) && is_not_empty_array($item_array))
	{
		$new_array = array();
	
		reset($old_item_array);
		while(list(,$value) = each($old_item_array))
		{
			if( !in_array($value, $item_array))
			{
				array_push($new_array, $value);
			}			
		}
		return $new_array;
	}
	else
		return $old_item_array;		
}

function convert_array_to_csv_list($array_list)
{
	$csvlist = '';

	if(is_array($array_list))
	{
		reset($array_list);
		while(list(,$value) = each($array_list))
		{
			if(strlen($csvlist)>0)
				$csvlist .= ',';
			$csvlist .= $value;
		}
	}
	return $csvlist;
}
?>