<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

//
// Administrator Config file
//

// defines the menu link in the main system tools page.
$menu_link_name = 'Attributes';
$type_description = 'System Attribute Type';

// Display help footer in specific item type edit form.
$new_sat_form_help = array('Attributes with a \'S_\' prefix are reserved for internal use and cannot be inserted or deleted.',
						'The Prompt field for existing \'S_\' prefixed attributes is the only field that can be updated.');

// legal s_field_type values.
$_FIELD_TYPES = array(
		''=>'', // empty option
		'TITLE'=>'Item Title',
		'CATEGORY'=>'Category',
		'STATUSTYPE'=>'Status Indicator',
		'STATUSCMNT'=>'Status Comment',
		'DURATION'=>'Borrow Duration',
		'ITEM_ID'=>'Item ID',
		'IMAGE'=>'Cover Image',
		'RATING'=>'System rating attribute'
	);

$argument_types = array(
			'width'=>array('prompt'=>'Width',
							'description'=>'Specify the width of window',
							'input_type'=>'number(3)'),
							
			'height'=>array('prompt'=>'Height',
							'description'=>'Specify the height of window',
							'input_type'=>'number(3)'),
			
			'maxrange'=>array('prompt'=>'Max Range',
							'description'=>'Specify the maximum range',
							'input_type'=>'number(3)'),
			
			'ratingmask'=>array('prompt'=>'Rating Display Mask',
							'description'=>'Specify the rating display mask, with the following special variables:'.
							'<table border=1>'.
							'<tr><th>Mask</th><th>Description</th>'.
			 				'<tr><td>%value%</td><td>The real rating value</td></tr>'.
			 				'<tr><td>%maxrange%</td><td>The maximum range of the rating</td></tr>'.
			 				'<tr><td>%starrating%</td><td>The star rating itself</td></tr>'.
							'</table><br>',
							'input_type'=>'text(20,100)'),
							
			'viewbutton'=>array('prompt'=>'View Button',
							'description'=>'Include view button. [Y|N]',
							'input_type'=>'checkbox(Y,N,)'),
							
			'saveurl-checked'=>array('prompt'=>'Save URL by Default',
							'description'=>'Save URL by Default',
							'input_type'=>'checkbox(Y,N,)'),
			
			'theme_img'=>array(prompt=>'Image',
							description=>'Image (literal or if/switch mask statement).',
							input_type=>'url(50,100,"gif,jpg,jpeg,png"'),
							
			'auto_datetime'=>array('prompt'=>'Auto Datetime',
							'description'=>'Provide current date/time as default for new field',
							'input_type'=>'checkbox(Y,N,)'),

			'length'=>array('prompt'=>'Length',
							'description'=>'Specify the visible size of the text field',
							'input_type'=>'number(3)'),

			'maxlength'=>array('prompt'=>'Maxlength',
							'description'=>'Specify the maximum length of the text input for the text field',
							'input_type'=>'number(3)'),

			'display_mask'=>array('prompt'=>'Mask',
							'description'=>'Specifies the format of each lookup value. The %value%, %display% and '
											.'%img% mask variables correspond to the <i>value</i>,<i>display</i> '
											.'and <i>img</i> columns in the s_attribute_type_lookup_table.  This '
											.'table is where the lookup values are sourced for this input field.',
							'input_type'=>'text(50,100)'),
			'input_datetime_mask'=>array('prompt'=>'Datetime Mask',
							'description'=>'A mask consisting of the following mask variables:'.
							'<table border=1>'.
							'<tr><th>Mask</th><th>Description</th>'.
			 				'<tr><td>DD</td><td>Days (01 - 31)</td></tr>'.
			 				'<tr><td>MM</td><td>Months (01 -12)</td></tr>'.
			 				'<tr><td>YYYY</td><td>Years</td></tr>'.
			 				'<tr><td>HH24</td><td>Hours (00 - 23)</td></tr>'.
			 				'<tr><td>HH</td><td>Hours (01 - 12)</td></tr>'.
			 				'<tr><td>MI</td><td>Minutes (00 - 59)</td></tr>'.
			 				'<tr><td>SS</td><td>Seconds (00 - 59)</td></tr>'.
							'</table><br>',
							'input_type'=>'text(50,100)'),
							
			'display_datetime_mask'=>array('prompt'=>'Datetime Mask',
							'description'=>'A mask consisting of the following mask variables:'.
							'<table border=1>'.
							'<tr><th>Mask</th><th>Description</th>'.
							'<tr><td>Month</td><td>Month name</td></tr>'.
					 		'<tr><td>Mon</td><td>Abbreviated month, Initcap</td></tr>'.
 					 		'<tr><td>MON</td><td>Abreviated month UPPERCASE</td></tr>'.
			 				'<tr><td>Day</td><td>Weekday name (display widget only!)</td></tr>'.
			 				'<tr><td>DDth</td><td>Day of the month with English suffix (1st, 2nd, 3rd)</td></tr>'.
			 				'<tr><td>DD</td><td>Days (01 - 31)</td></tr>'.
			 				'<tr><td>MM</td><td>Months (01 -12)</td></tr>'.
			 				'<tr><td>YYYY</td><td>Years</td></tr>'.
			 				'<tr><td>HH24</td><td>Hours (00 - 23)</td></tr>'.
			 				'<tr><td>HH</td><td>Hours (01 - 12)</td></tr>'.
			 				'<tr><td>MI</td><td>Minutes (00 - 59)</td></tr>'.
			 				'<tr><td>SS</td><td>Seconds (00 - 59)</td></tr>'.
			 				'<tr><td>AM</td><td>Meridian indicator. Will be \'AM\' or \'PM\', but \'AM\' is used as the mask</td></tr>'.
							'</table><br>',
							'input_type'=>'text(50,100)'),
							
			'field_mask'=>array('prompt'=>'Mask',
							'description'=>'Free text formatting encompassing the actual field.  The %field% specifies the '
											.'location of the field in the mask.',
							'input_type'=>'text(50,100)'),

			'legalchars'=>array('prompt'=>'Legal Char List',
							'description'=>'Specify a list of legal characters that can be used for this field. '
											.'You can specify this as a comma delimited list, or as a range. '
											.'<br>Example: <b>a-z,1,2,3</b> This list will allow all lowercase '
											.'characters and the numbers 1 2 and 3 to be used.',
							'input_type'=>'text(50,100)'),

			'checked-val'=>array('prompt'=>'Checked Value',
							'description'=>'Specify the value the checkbox should be when it IS checked.',
							'input_type'=>'text(50,100)'),

			'unchecked-val'=>array('prompt'=>'Unchecked Value',
							'description'=>'Specify the value the checkbox should be when it IS NOT checked.',
							'input_type'=>'text(50,100)'),

			'cols'=>array('prompt'=>'Columns',
							'description'=>'How many columns wide should this field be?',
							'input_type'=>'number(2)'),

			'rows'=>array('prompt'=>'Columns',
							'description'=>'How many rows high should this field be?',
							'input_type'=>'number(2)'),

			'orientation'=>array('prompt'=>'Orientation',
							'description'=>'Which way should this field be formatted?'
										.'<br><br>Options are:'
										.'<ul>'
										.'<li>VERTICAL</li>'
										.'<li>HORIZONTAL</li>'
										.'</ul><br>',
							'input_type'=>'value_select("VERTICAL,HORIZONTAL", 1)'),
							
			'alignment'=>array('prompt'=>'Alignment',
							'description'=>'Which way should this field be aligned?'
										.'<br><br>Options are:'
										.'<ul>'
										.'<li>LEFT</li>'
										.'<li>RIGHT</li>'
										.'<li>CENTRE</li>'
										.'</ul><br>',
							'input_type'=>'value_select("LEFT,RIGHT,CENTRE", 1)'),

			'ext_list'=>array('prompt'=>'File Extensions',
							'description'=>'Specify which file types (based on extension) this field will accept as legal.'
											.'<br>Example: <b>gif,jpg,jpeg,png</b>',
							'input_type'=>'text(50,100)'),

			'columns'=>array('prompt'=>'Columns',
							'description'=>'How many columns wide should this field be?',
							'input_type'=>'number(2)'),

			'border'=>array('prompt'=>'Border',
							'description'=>'What size table border to put around this field?',
							'input_type'=>'number(2)'),

			'size'=>array('prompt'=>'Size',
							'description'=>'What size should this select field be.  A size >1 will cause the '
											.'select field to be a MULTIPLE select as well.',
							'input_type'=>'number(2)'),

			'value_list'=>array('prompt'=>'Value List',
							'description'=>'Provide the value options for the widget, comma delimited.'
											.'<br>Example: <b>one,two,three</b>',
							'input_type'=>'text(50,100)'),

			'delimiter'=>array('prompt'=>'Delimiter',
							'description'=>'Specify a single character delimiter to tokenise the text.',
							'input_type'=>'text(1,1)'),

			'list_type'=>array('prompt'=>'List Type',
							'description'=>'Specify a list format type.'
										.'<br><br>Options are: '
										.'<ul>'
										.'<li>plain - Use the delimiter to reconstitute the list.  Useful when using '
										.'the list-link parameter for a text field, and you don\'t want to modify the '
										.'layout.</li>'
										.'<li>nl2br - Each token will be separated by a newline &lt;br&gt;</li>'
										.'<li>ordered - Will display the tokens in a HTML &lt;OL&gt; list.</li>'
										.'<li>unordered - Will display the tokens in a unordered list, much like a '
										.'HTML &lt;OL&gt; list, except that \'dot.gif\' is used for each list item.</li>'
										.'<li>ticks - As for unordered, except that \'ticks.gif\' is used.</li>'
										.'</ul><br>',
							'input_type'=>'value_select("plain,nl2br,ordered,unordered,ticks", 1)'),

			'list-link'=>array('prompt'=>'List Link',
							'description'=>'Include a listings.php link for each element/token of the displayed attribute.',
							'input_type'=>'checkbox(list-link,,)'),
			
			'time_mask'=>array('prompt'=>'Time Mask',
							'description'=>'Specify time format mask.'
											.'<br><br>The mask components supported are: '
											.'<ul>'
											.'<li>%h - hour value only</li>'
											.'<li>%H - text &quot;hour&quot; or &quot;hours&quot;</li>'
											.'<li>%m - minute value only</li>'
											.'<li>%M - text &quot;minute&quot; or &quot;minutes&quot;</li>'
											.'</ul><br>',
							'input_type'=>'text(50,100)'),
		);

// input type functions
$input_type_functions = 
		array(
			'hidden'=>array(
						'args'=>array(),
						'description'=>'A hidden field'),
			'readonly'=>array(
						'args'=>array(),
						'description'=>'A readonly field'),
			'text'=>array(
						'args'=>array('length[Y]','maxlength','field_mask'),
						'description'=>'A text field'),
			'textarea'=>array(
						'args'=>array('cols[Y]','rows[Y]','field_mask'),
						'description'=>'A textarea field'),

			'htmlarea'=>array(
						'args'=>array('cols[Y]','rows[Y]','field_mask'),
						'description'=>'A HTML textarea field'),
						
			'email'=>array(
						'args'=>array('length[Y]','maxlength','field_mask'),
						'description'=>'A text field with email format validation'),

			'filtered'=>array(
						'args'=>array('length[Y]','maxlength','legalchars[Y]','field_mask'),
						'description'=>'A text field with validation controlled by legalchars parameter.'),
						
			'datetime'=>array(
						'args'=>array('input_datetime_mask[Y]', 'auto_datetime', 'field_mask'),
						'description'=>'A datetime field, which much match the Datetime Mask exactly.'.
						'Must be used with the matching \'datetime\' display type widget.'),

			'number'=>array(
						'args'=>array('length[Y]','field_mask'),
						'description'=>'A text field with numeric validation'),

			'checkbox'=>array(
						'args'=>array('checked-val[Y]','unchecked-val','field_mask'),
						'description'=>'A two state checkbox.  This differs from normal check boxes, '
										.'because this one can send a value to OpenDb whether checked '
									 	.'or not.'),

			'review_options'=>array(
						'args'=>array('display_mask','orientation'),
						'description'=>'Item Review / Search specific widget.'),

			'url'=>array(
						'args'=>array('length[Y]','maxlength','ext_list','viewbutton'),
						'description'=>'Specify a external extension validated url value, with provision to view in popup window.'),
						
			'upload'=>array(
						'args'=>array('length[Y]','maxlength','ext_list'),
						'description'=>'A file upload field with extension validation controlled by the ext_list parameter.'),
						
			'saveurl'=>array(
						'args'=>array('length[Y]','maxlength','ext_list','viewbutton','saveurl-checked'),
						'description'=>'This function provides functionality to download the URL in the text field and save it locally. '
										.'However the field is <i>just</i> a text field with extension validation, unless the <i>Save</i> '
										.'checkbox is checked.  The extension validation is controlled by the ext_list parameter.'),
			'upload_or_saveurl'=>array(
						'args'=>array('length[Y]','maxlength','ext_list','viewbutton','saveurl-checked'),
						'description'=>'A upload field and saveurl all in one.  This function provide the option of '
										.'either a file upload or specifying a URL to be downloaded and saved locally.'),
			'radio_grid'=>array(
						'args'=>array('display_mask','columns','border'),
						'description'=>'A formatted (according to columns and border parameters) grid of radio buttons, one '
										.'for each matching (according to the item_attribute s_attribute_type) lookup record.'),
										
			'checkbox_grid'=>array(
						'args'=>array('display_mask','columns','border'),
						'description'=>'A formatted (according to columns and border parameters) grid of checkboxes, one '
										.'for each matching (according to the item_attribute s_attribute_type) lookup record.'),
			
			'value_radio_grid'=>array(
						'args'=>array('value_list[Y]','columns','border'),
						'description'=>'A formatted (according to columns and border parameters) grid of radio buttons, '
										.'for each value in the comma delimited value_list.'),
										
			'single_select'=>array(
						'args'=>array('display_mask','length'),
						'description'=>'A <i>single</i> select field, with a option for each matching (according to '
										.'the item_attribute s_attribute_type) lookup record.'),
			'multi_select'=>array(
						'args'=>array('display_mask','length','size'),
						'description'=>'A <i>multiple / single</i> (size parameter controls this) select field, with a '
										.'option for each matching (according to the item_attribute s_attribute_type) lookup record.'),
			'value_select'=>array(
						'args'=>array('value_list[Y]','size'),
						'description'=>'A <i>multiple / single</i> (size parameter controls this) select object which formats a '
									.' select object with the specified value_list')
		);

// Display type functions.
$display_type_functions = 
		array(
			'list'=>array(
						'args'=>array('list_type[Y]', 'delimiter', 'list-link'),
						'description'=>'Tokenise the attribute value based on the delimiter  (or newline if no delimiter '
										.'specified).  The list_type parameter controls how these tokens are formatted.'),

			'urlpopup'=>array(
						'args'=>array('theme_img','width','height'),
						'description'=>'This widget, will display a URL value, with a popup link to display '.
										'it in a new window with external.php OpenDb script.  The width & height arguments are optional, to '.
										'control the dimensions of the window.  The window will be opened '.
										'with 640x480 dimensions by default.'),
										
			'urlpopup2'=>array(
						'args'=>array('theme_img','width','height'),
						'description'=>'This widget, will display a URL value, with a popup link to display '.
										'it in a new window.  The width & height arguments are optional, to '.
										'control the dimensions of the window.  The window will be opened '.
										'with 640x480 dimensions by default.'),
																
			'format_mins'=>array(
						'args'=>array('time_mask[Y]'),
						'description'=>'Format a time value.'),
						
			'star_rating'=>array(
						'args'=>array('maxrange[Y]', 'ratingmask', 'list-link'),
						'description'=>'Format a star rating.'),
						
			'datetime'=>array(
						'args'=>array('display_datetime_mask[Y]'),
						'description'=>'Display a datetime populated with the matching \'datetime\' input type.'),

			'display'=>array(
						'args'=>array('display_mask[Y]', 'orientation', 'alignment', 'list-link'),
						'description'=>'Format the display value using the %display% and %img% attributes of the matching '
										.'lookup table record, or %value% for the attribute value itself. '
										.'Alignment currently only supported when display mask is set to %value%, while '
										.'orientation is supported for lookup attribute types only.'),

			'category'=>array(
						'args'=>array('display_mask[Y]', 'list-link'),
						'description'=>'A special format function especially designed for item category, to split them up using \'/\'. '
										.' The list-link will use a \'category\' attr_match if specified'),

			'hidden'=>array(
						'args'=>array(),
						'description'=>'A hidden field.  Designed to allow you to hide a value you had once populated, but now '
										.' have no interest in seeing.'),
			
			'popupsize'=>array(
						'args'=>array('width[Y]','height[Y]'),
						'description'=>'A field reserved for use by attributes with an s_field_type of IMAGE to define the size of the popup window.'.
									' The default size is 400x300. It will be treated as a \'hidden\' field otherwise.')
		);
?>