#
# amazonde.sql site plugin definition
#

#
# Cleanup
#
DELETE FROM s_site_plugin WHERE site_type = 'amazonde';
DELETE FROM s_site_plugin_conf WHERE site_type = 'amazonde';
DELETE FROM s_site_plugin_input_field WHERE site_type = 'amazonde';
DELETE FROM s_site_plugin_link WHERE site_type = 'amazonde';
DELETE FROM s_site_plugin_s_attribute_type_map WHERE site_type = 'amazonde';
DELETE FROM s_site_plugin_s_attribute_type_lookup_map WHERE site_type = 'amazonde';

INSERT INTO s_site_plugin (site_type, classname, order_no, title, image, description, external_url, items_per_page, more_info_url)
VALUES('amazonde', 'amazonde', 1, 'Amazon.de', 'amazonde.gif', 'A good source of CD, DVD (Region 2), VHS, Books, Games, etc.', 'http://www.amazon.de', 25, 'http://www.amazon.de/exec/obidos/ASIN/{amazdeasin}');

#
# Input Fields
#	
INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('amazonde', 'title', 1, '', 'Title Search', 'text', '', '{title}');

INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('amazonde', 'amazdeasin', 2, '', 'ASIN/ISBN Number', 'text', '', '{ifdef(amazdeasin,{amazdeasin},{if(s_item_type==BOOK,{isbn},\'\')})}');

#
# Links
#
INSERT INTO s_site_plugin_link(site_type, s_item_type_group, s_item_type, order_no, description, url, title_url)
VALUES('amazonde', '*', '*', 1, 'More Info', 'http://www.amazon.de/exec/obidos/ASIN/{amazdeasin}', '');

INSERT INTO s_site_plugin_link(site_type, s_item_type_group, s_item_type, order_no, description, url, title_url)
VALUES('amazonde', '*', 'GAME', 2, 'Screenshots', 'http://www.amazon.de/exec/obidos/tg/stores/detail/-/videogames/{amazdeasin}/pictures#more-pictures', NULL);

#
# Configuration
#
INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonde', 'item_type_to_index_map', '', 'CD', 'music-de');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonde', 'item_type_to_index_map', '', 'MP3', 'music-de');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonde', 'item_type_to_index_map', '', 'BOOK', 'books-de');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonde', 'item_type_to_index_map', '', 'GAME', 'video-games-de');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonde', 'item_type_to_index_map', '', 'VHS', 'vhs-de');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonde', 'item_type_to_index_map', '', 'DVD', 'dvd-de');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonde', 'item_type_to_index_map', '', 'VCD', 'dvd-de');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonde', 'item_type_to_index_map', '', 'DIVX', 'dvd-de');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonde', 'item_type_to_index_map', '', 'LD', 'dvd-de');

#
# title articles - overrides $CONFIG_VARS['item_input.title_articles']
# 
INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonde', 'item_input.title_articles', '', '0', 'Ein');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonde', 'item_input.title_articles', '', '1', 'Eine');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonde', 'item_input.title_articles', '', '2', 'Der');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonde', 'item_input.title_articles', '', '3', 'Die');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonde', 'item_input.title_articles', '', '4', 'Das');

#
# site variable to s_attribute_type mapping
#
INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonde', 'title', '*', '*', 'ALT_TITLE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonde', 'title', '*', '*', 'S_TITLE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonde', 'genre', 'VIDEO', '*', 'MOVIEGENRE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonde', 'genre', 'AUDIO', '*', 'MUSICGENRE');
	
INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonde', 'genre', '*', 'BOOK', 'BOOKGENRE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonde', 'genre', '*', 'GAME', 'GAMEGENRE');
	
INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonde', 'blurb', 'VIDEO', '*', 'MOVIE_PLOT');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonde', 'blurb', 'AUDIO', '*', 'COMMENTS');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonde', 'blurb', '*', 'BOOK', 'COMMENTS');	

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonde', 'blurb', '*', 'GAME', 'GAME_PLOT');	

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonde', 'listprice', 'VIDEO', '*', 'RET_PRICE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonde', 'listprice', '*', '*', 'COVERPRICE');

# Not sure about this one!
#INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
#VALUES ('amazonde', 'listprice', '*', '*', 'PREIS');

#
# site variable to s_attribute_type_lookup mapping
#
INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Antiquarische Bcher', 'ANTIQ' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Belletristik', 'BELL');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Brse & Geld', 'GELD');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Business & Karriere', 'BUS');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Computer & Internet', 'COMP');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Computers & Internet', 'COMP');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Erotik', 'EROS');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Fachbcher', 'FACH');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Film, Kultur & Comics', 'FILM');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Gebrauchte Bcher', 'USED');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Hrbcher', 'HRCD');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Kinder- & Jugendbcher', 'KIND');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Kochen & Lifestyle', 'KOCH');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Krimis & Thriller', 'KRIMI');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Lernen & Nachschlagen', 'LERNEN');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Musiknoten', 'MUSIK');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Naturwissenschaften & Technik', 'NATUR');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Politik, Biografien & Geschichte', 'POLITIK');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Preis-Hits', 'PREIS');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Ratgeber', 'RATGEBER');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Reise & Sport', 'REISE');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Religion & Esoterik', 'RELIGION');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Science Fiction, Fantasy & Horror', 'SCIFI');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'English Books', 'INTERNAT');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'E-Books', 'EBOOK');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Bestseller aller Ressorts', 'BESTSELL');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Bcher in den Medien', 'BIDM');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Zeitschriften', 'SCHRIFT');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Amazon.de-Sonderausgaben', 'SONDER');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonde', 'BOOKGENRE', 'Kinderwelt', 'KINDER');
			
INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'GAMESYSTEM', 'PlayStation', 'PS1');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'GAMESYSTEM', 'PlayStation2', 'PS2');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'GAMESYSTEM', 'Sega Dreamcast', 'DREAMCAST');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'GAMESYSTEM', 'Nintendo 64', 'N64');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'GAMESYSTEM', 'GameCube', 'GAMECUBE');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'GAMESYSTEM', 'Xbox', 'XBOX');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'GAMESYSTEM', 'Game Boy Color', 'GAMEBOY');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'GAMESYSTEM', 'Game Boy', 'GAMEBOY');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'GAMESYSTEM', 'Game Boy Advance', 'GAMEBOYADVANCE');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'GAMESYSTEM', 'Mac OS', 'MACCDROM');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'GAMESYSTEM', 'Windows', 'PCCDROM');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'GAMERATING', 'Freigegeben ohne Altersbeschrnkung gem  14 JuSchG', 'USK0');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'GAMERATING', 'Freigegeben ab 6 Jahren gem  14 JuSchG', 'USK6');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'GAMERATING', 'Freigegeben ab 12 Jahren gem  14 JuSchG', 'USK12');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'GAMERATING', 'Freigegeben ab 16 Jahren gem  14 JuSchG', 'USK16');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'GAMERATING', 'Keine Jugendfreigabe gem  14 JuSchG', 'USK18');


INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AGE_RATING', 'Ohne Altersbeschrnkung', 'USK0');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AGE_RATING', 'Freigegeben ab 6 Jahren', 'USK6');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AGE_RATING', 'Freigegeben ab 12 Jahren', 'USK12');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AGE_RATING', 'Freigegeben ab 16 Jahren', 'USK16');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AGE_RATING', 'Freigegeben ab 18 Jahren', 'USK18');

# See http:# www.beepworld.de/members42/afg_007/love_u.htm for more
INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Deutsch', 'GERMAN');

#INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
#VALUES( 'amazonde', 'SUBTITLES', 'Deutsch fr Hrgeschdigte', 'GERMAN_FOR_HEARING-IMPAURED');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Englisch', 'ENGLISH');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Franzsisch', 'FRENCH'); #TODO find a movie with french sub and test spelling

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Spanisch', 'SPANISH');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Portugiesisch', 'PORTUGUESE');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Italienisch', 'ITALIAN');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Trkisch', 'TURKISH');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Arabisch', 'ARABIC');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Polnisch', 'POLISH');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Chechisch', 'CZECH');  # TODO spelling???

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Ungarisch', 'HUNGARIAN');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Bulgarisch', 'BULGARIAN');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Griechisch', 'GREEK');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Dnisch', 'DANISH');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Hollndisch', 'DUTCH');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Finnisch', 'FINNISH');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Hebrisch', 'HEBREW');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Norwegisch', 'NORWEGIAN');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Schwedisch', 'SWEDISH');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Chinesisch', 'CHINESE');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Hinduisch', 'HINDOE');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Islndisch', 'ISLANDIC');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Japanisch', 'JAPANESE');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'SUBTITLES', 'Slowenisch', 'SLOVAKIAN');

#
# Audio Language mappings
# 
INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Englisch (Mono)', 'ENGLISH');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Englisch (Dolby Digital 2.0)', 'ENGLISH_2.0');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Englisch (Dolby Surround)', 'ENGLISH_SR');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Englisch (Dolby Digital 5.1)', 'ENGLISH_5.1');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Englisch (Dolby Digital 5.1 EX)', 'ENGLISH_5.1');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Englisch (Dolby Digital 5.1 EX, Dolby Digital 5.1)', 'ENGLISH_5.1');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Englisch (Dolby Digital 5.1, THX Surround EX)', 'ENGLISH_5.1');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Englisch (Dolby Digital 5.1, THX Surround EX)', 'ENGLISH_THX');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Deutsch (Mono)', 'GERMAN');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Deutsch (Dolby Digital 2.0)', 'GERMAN_2.0');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Deutsch (Dolby Surround)', 'GERMAN_SR');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Deutsch (Dolby Digital 5.1 EX)', 'GERMAN_5.1');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Deutsch (Dolby Digital 5.1 EX, Dolby Digital 5.1)', 'GERMAN_5.1');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Deutsch (Dolby Digital 5.1, THX Surround EX)', 'GERMAN_5.1');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Deutsch (Dolby Digital 5.1, THX Surround EX)', 'GERMAN_THX');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Deutsch THX', 'GERMAN_THX');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Deutsch (Dolby Digital 5.1)', 'GERMAN_5.1');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Spanisch (Dolby Surround)', 'SPANISH');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Spanisch (Dolby Digital 5.1)', 'SPANISH');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Italienisch (Dolby Surround)', 'ITALIAN');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES( 'amazonde', 'AUDIO_LANG', 'Italienisch (Dolby Digital 5.1)', 'ITALIAN');

####################################################################################################
# Item Type / Attribute Type relationships
####################################################################################################

INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'AMAZDEASIN', 'Amazon Germany Standard Item Number', 'German Amazon ASIN', 'hidden', 'hidden', NULL, 'amazonde');

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'AMAZDEASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'AMAZDEASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'AMAZDEASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'AMAZDEASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'AMAZDEASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'AMAZDEASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'BOOK', 'AMAZDEASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'AMAZDEASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'MP3', 'AMAZDEASIN', '0',NULL, NULL);

#
# Amazon Book Categorys
#
# http:# www.amazon.de/exec/obidos/tg/stores/static/-/books/browse/
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 0,  'ANTIQ',   'Antiquarische Bcher');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 1,  'BELL',    'Belletristik');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 2,  'GELD',    'Brse & Geld');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 3,  'BUS',     'Business & Karriere');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 4,  'COMP',    'Computer & Internet');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 5,  'EROS',    'Erotik');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 6,  'FACH',    'Fachbcher');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 7,  'FILM',    'Film, Kultur & Comics');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 8,  'USED',    'Gebrauchte Bcher');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 9,  'HRCD',   'Hrbcher');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 10, 'KIND',    'Kinder & Jugendbcher');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 11, 'KOCH',    'Kochen & Lifestyle');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 12, 'KRIMI',   'Krimis & Thriller');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 13, 'LERNEN',  'Lernen & Nachschlagen');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 14, 'MUSIK',   'Musiknoten');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 15, 'NATUR',   'Naturwissenschaften & Technik');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 16, 'POLITIK', 'Politik, Biografien & Geschichte');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 17, 'PREIS',   'Preis-Hits');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 18, 'RATGEBER','Ratgeber');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 19, 'REISE',   'Reise & Sport');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 20, 'RELIGION','Religion & Esoterik');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 21, 'SCIFI',   'Science Fiction, Fantasy & Horror');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 22, 'INTERNAT','English Books');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 23, 'EBOOK',   'E-Books');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 24, 'BESTSELL','Bestseller aller Ressorts');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 25, 'BIDM',    'Bcher in den Medien');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 26, 'SCHRIFT', 'Zeitschriften');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 27, 'SONDER', 'Amazon.de-Sonderausgaben');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display) VALUES ( 'BOOKGENRE', 29, 'KINDER', 'Kinderwelt');