#
# plugin.sql site plugin definition
#

#
# Cleanup
#
DELETE FROM s_site_plugin WHERE site_type = 'imdb';
DELETE FROM s_site_plugin_conf WHERE site_type = 'imdb';
DELETE FROM s_site_plugin_input_field WHERE site_type = 'imdb';
DELETE FROM s_site_plugin_link WHERE site_type = 'imdb';
DELETE FROM s_site_plugin_s_attribute_type_map WHERE site_type = 'imdb';
DELETE FROM s_site_plugin_s_attribute_type_lookup_map WHERE site_type = 'imdb';

INSERT INTO s_site_plugin (site_type, classname, order_no, title, image, description, external_url, items_per_page, more_info_url)
VALUES('imdb', 'imdb', 2, 'Imdb.com', 'imdb.gif', '<i>The</i> source of movie information, but with nothing specific to distribution formats such as DVD and VHS.', 'http://www.imdb.com', 0, 'http://www.imdb.com/title/tt{imdb_id}');

#
# Input Fields
#	
INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('imdb', 'title', 1, '', 'Title Search', 'text', '', '{ifdef(alt_title,\'{alt_title}\',\'{title}\')}{ifdef(year,\' ({year})\')}');

INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('imdb', 'imdb_id', 2, '', 'IMDB ID', 'text', '', '{imdb_id}');

#
# Links
#
INSERT INTO s_site_plugin_link(site_type, s_item_type_group, s_item_type, order_no, description, url, title_url)
VALUES('imdb', 'VIDEO', '*', 1, 'More Info', 'http://www.imdb.com/Title?{imdb_id}', '{ifdef(year, http://www.imdb.com/Tsearch?title={title}&type=substring&year={year})}');

INSERT INTO s_site_plugin_link(site_type, s_item_type_group, s_item_type, order_no, description, url, title_url)
VALUES('imdb', 'VIDEO', '*', 2, 'Trailer', 'http://www.imdb.com/Trailers?{imdb_id}', '');

#
# Configuration
#
INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('imdb', 'age_certification_codes', '', '0', 'Australia');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('imdb', 'age_certification_codes', '', '1', 'USA');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('imdb', 'title_search_match_types', '', '0', 'exact');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('imdb', 'title_search_match_types', '', '1', 'partial');

#INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
#VALUES('imdb', 'title_search_match_types', '', '2', 'approx');

#
# site variable to s_attribute_type mapping
#
INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('imdb', 'title', '*', '*', 'ALT_TITLE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('imdb', 'title', '*', '*', 'S_TITLE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('imdb', 'plot', '*', '*', 'MOVIE_PLOT');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('imdb', 'genre', '*', '*', 'MOVIEGENRE');

#
# site variable to s_attribute_type_lookup mapping
#
INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('imdb', 'AGE_RATING', 'PG-13', 'PG');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('imdb', 'AGE_RATING', 'R', 'MA');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('imdb', 'AGE_RATING', 'NC-17', 'MA');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('imdb', 'AGE_RATING', 'X', 'R');

####################################################################################################
# Item Type / Attribute Type relationships
####################################################################################################

INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'IMDB_ID', 'ImDb ID', 'Imdb ID', 'hidden', 'hidden', NULL, 'imdb');


INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'IMDB_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'IMDB_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'IMDB_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'IMDB_ID', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'IMDB_ID', '0', NULL, NULL);

####################################################################################################
# Even though IMDBRATING is a attribute specifically for IMDB site, it is not explicitly required for the
# site plugin to work, so its not actually be explicitly linked to the plugin here.
####################################################################################################
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'IMDBRATING','IMDB User Rating', 'IMDB Rating', 'hidden', 'star_rating(10, %starrating%%value%/%maxrange%)', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'IMDBRATING', '5', '', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'IMDBRATING', '5', '', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'IMDBRATING', '5', '', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'IMDBRATING', '5', '', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'IMDBRATING', '5', '', NULL);