/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 2019 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
                            | Copyright (C) 2007-2019 PCOpt/NTUA
                            | Copyright (C) 2013-2019 FOSS GP
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.


InClass
    Foam::boundaryFieldsFwd

Description
    Useful typenames for fields defined only at the boundaries

SourceFiles

\*---------------------------------------------------------------------------*/

#ifndef boundaryFieldsFwd_H
#define boundaryFieldsFwd_H

#include "fieldTypes.H"
#include "volFields.H"
#include "List.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

//volFields
typedef typename volScalarField::Boundary boundaryScalarField;
typedef typename volVectorField::Boundary boundaryVectorField;
typedef typename volTensorField::Boundary boundaryTensorField;

//pointFields - actually a plain list of fields with dimension equal to the
// number of points per patch
typedef List<Field<scalar>> pointBoundaryScalarField;
typedef List<Field<vector>> pointBoundaryVectorField;
typedef List<Field<tensor>> pointBoundaryTensorField;


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
