/*  This file is part of the KDE project
    Copyright (C) 2009 Cyrille Berger <cberger@cberger.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef OPENCTL_EXPORT_H
#define OPENCTL_EXPORT_H

/* needed for GTL_EXPORT and GTL_IMPORT macros */
#include <GTLCore/Macros.h>

#ifndef OPENCTL_EXPORT
# if defined(MAKE_OPENCTL_LIB)
   /* We are building this library */ 
#  define OPENCTL_EXPORT GTL_EXPORT
# else
   /* We are using this library */ 
#  define OPENCTL_EXPORT GTL_IMPORT
# endif
#endif

# ifndef OPENCTL_EXPORT_DEPRECATED
#  define OPENCTL_EXPORT_DEPRECATED GTL_DEPRECATED OPENCTL_EXPORT
# endif

# ifdef OPENGTL_ENABLE_TESTS
#  define OPENCTL_TESTS_EXPORT OPENCTL_EXPORT
# else
#  define OPENCTL_TESTS_EXPORT
# endif

#ifdef OPENGTL_ENABLE_DEBUG_OUTPUT
#  define OPENCTL_DEBUG_EXPORT OPENCTL_EXPORT
# else
#  define OPENCTL_DEBUG_EXPORT
# endif

#endif
