/*
 *  Copyright (c) 2007-2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENCTL_COMPILER_H_
#define _OPENCTL_COMPILER_H_

#include "GTLCore/String.h"
#include "GTLCore/Macros.h"
#include "GTLCore/ModuleData_p.h"
#include <GTLCore/CompilerBase_p.h>

#include "../Export.h"

namespace llvm {
  class Module;
};

namespace GTLCore {
  namespace AST {
    class Expression;
  }
  class Function;
  class CodeGenerator;
  class ErrorMessage;
  class ScopedName;
  class Type;
  class TypesManager;
}

#include <GTLCore/CompilerBase_p.h>

namespace OpenCTL {
  /**
   * @internal
   * @ingroup OpenCTL
   * This class is part of the private API of OpenCTL and should not be use
   * directly. But rahter the Module class.
   */
  class Compiler : public GTLCore::CompilerBase {
    public:
      Compiler();
      ~Compiler();
      bool compile(bool _isStandardLibrary, const GTLCore::String& sourceCode, const GTLCore::String& moduleName, GTLCore::ModuleData* moduleData);
      bool importModule(const GTLCore::String& name);
    public:
        virtual GTLCore::TypesManager* typesManager();
        llvm::Module* module();
        GTLCore::CodeGenerator* codeGenerator();
        OPENCTL_EXPORT static void disableStandardLibrary();
    public:
      GTLCore::AST::Expression* standardConstant( const GTLCore::String& _name );
    private:
      struct Private;
      Private* const d;
  };
  
}

#endif
