/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "ErrorMessage.h"

#include "Debug.h"

using namespace GTLCore;

struct ErrorMessage::Private {
  String errorMessage;
  int line;
  String fileName;
};

ErrorMessage::ErrorMessage( const String& errorMessage, int line, const String& fileName ) : d(new Private)
{
  d->errorMessage = errorMessage;
  d->line = line;
  d->fileName = fileName;
}

ErrorMessage::ErrorMessage( const ErrorMessage& errMsg) : d(new Private(*errMsg.d))
{
}

ErrorMessage& ErrorMessage::operator=(const ErrorMessage& rhs)
{
  *d = *rhs.d;
  return *this;
}

ErrorMessage::~ErrorMessage()
{
  delete d;
}

int ErrorMessage::line() const
{
  return d->line;
}

const String& ErrorMessage::errorMessage() const
{
  return d->errorMessage;
}

const String& ErrorMessage::fileName() const
{
  return d->fileName;
}

void ErrorMessage::setLine(int line)
{
  GTL_ASSERT(d->line == -1);
  d->line = line;
}

void ErrorMessage::setFileName(const String& fileName)
{
  GTL_ASSERT(d->fileName == "");
  d->fileName = fileName;
}
