/*
 *  Copyright (c) 2008-2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _PIXEL_DESCRIPTION_H_
#define _PIXEL_DESCRIPTION_H_

#include <vector>
#include <GTLCore/Export.h>

namespace GTLCore {
  class Type;
  /**
   * This class holds the definition of a pixel structure, number of channels
   * and the type of each channel.
   * @ingroup GTLCore
   */
  class GTLCORE_EXPORT PixelDescription {
    public:
      /**
       * Create a PixelDescription with multiple channels of the same type.
       * @param _channelType the type of the channel
       * @param _channels the number of channels
       */
      PixelDescription( const Type* _channelType, int _channels);
      PixelDescription( const Type* _channelType, int _channels, int _alphaPos); // TODO BIC merge with previous constructor and _alphaPos = -1
      /**
       * Create a PixelDescription with multiple channels of different types.
       * @param _channelsType a vector with the list of channels types
       */
      PixelDescription( const std::vector<const Type* >& _channelsType);
      PixelDescription( const std::vector<const Type* >& _channelsType, int _alphaPos); // TODO BIC merge with previous constructor and _alphaPos = -1
      PixelDescription( const PixelDescription& pixelDescription);
      PixelDescription& operator=(const PixelDescription& rhs);
      ~PixelDescription();
      /**
       * @return the list of channels
       */
      const std::vector<const Type*>& channelTypes() const;
      /**
       * @return the number of channels
       */
      std::size_t channels() const;
      /**
       * @return true if all channels have the same type
       */
      GTL_DEPRECATED bool sameTypeChannels() const;
      /**
       * @return true if all channels have the same type
       */
      bool hasSameTypeChannels() const;
      /**
       * @return the list of channel positions
       */
      const std::vector< std::size_t >& channelPositions() const;
      /**
       * This allow to reshuffle the channels position before using with an algorithms.
       * This is usefull if the data buffer is using BGRA and the algorithm assume RGBA.
       */
      void setChannelPositions( const std::vector< std::size_t >& _positions );
      /**
       * @return the size of a pixel in bits
       */
      int bitsSize() const;
      /**
       * @return the position of the alpha channel, or -1 if no alpha channel
       */
      int alphaPos() const;
      bool operator<( const PixelDescription& _rhs ) const;
      bool operator==( const PixelDescription& _rhs ) const;
      bool operator!=( const PixelDescription& _rhs ) const;
    private:
      struct Private;
      Private* const d;
  };
  
}

#endif
