/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENSHIVA_WRAPPER_P_H_
#define _OPENSHIVA_WRAPPER_P_H_

#include "GTLCore/Type_p.h"

struct ImageWrap;

namespace llvm {
  class Function;
  class FunctionType;
  class Module;
  class LLVMContext;
}

namespace GTLCore {
  class ModuleData;
  class PixelDescription;
  class TypesManager;
  class AbstractImage;
  class ConvertCenter;
}

namespace OpenShiva {
  class Kernel;
  /**
   * @internal
   * This class allows all informations related to wrapped types of OpenShiva : imageX, pixelX and
   * region.
   * @ingroup OpenShiva
   */
  class Wrapper {
      class Mem2VecFloatTypeAribtraryTypeFactory;
      class VecFloat2MemTypeAribtraryTypeFactory;
    public:
      Wrapper(Kernel* _kernel, GTLCore::ModuleData* _moduleData);
      ~Wrapper();
      ImageWrap* wrapImage(GTLCore::AbstractImage* _abstractImage);
    private:
      struct Private;
      Private* const d;
    public:
      static void fillTypesManager( GTLCore::ModuleData* _module, GTLCore::TypesManager*, GTLCore::ConvertCenter*, int _channels );
      static llvm::Function* image_wrap_dataFunction( llvm::Module* _module, const GTLCore::Type* _imageType );
      static llvm::Function* image_wrap_const_dataFunction( llvm::Module* _module, const GTLCore::Type* _imageType );
      static llvm::Function* image_alpha_posFunction( llvm::Module* _module, const GTLCore::Type* _imageType );
      static llvm::FunctionType* image_wrap_sample_nearest_type( llvm::LLVMContext& context, GTLCore::TypesManager* _typesManager, const GTLCore::Type* _imageType, const GTLCore::Type* _pixelType );
      static llvm::FunctionType* image_wrap_mem_to_vec_float_type( llvm::LLVMContext& context, GTLCore::TypesManager* _typesManager, int _channels );
      static llvm::FunctionType* image_wrap_vec_float_to_mem_type( llvm::LLVMContext& context, GTLCore::TypesManager* _typesManager, int _channels );
      static llvm::FunctionType* pixel_wrap_set_alpha_type( llvm::LLVMContext& context, GTLCore::TypesManager* _typesManager, const GTLCore::Type* _pixelType);
      static llvm::FunctionType* pixel_wrap_alpha_type( llvm::LLVMContext& context, GTLCore::TypesManager* _typesManager, const GTLCore::Type* _pixelType);
      /**
       * @return the vectory type associated to that number of _channels
       */
      static const GTLCore::Type* vectorType( GTLCore::TypesManager* _typesManager, int _channels );
    private:
      static void createRegionType( GTLCore::ModuleData* _module, GTLCore::TypesManager* _typesManager );
      static const GTLCore::Type* createPixelType( GTLCore::ModuleData* _module, GTLCore::TypesManager* _typesManager, GTLCore::ConvertCenter* _convertCenter, const GTLCore::String& _suffix, int _channels );
      static void createImageType( GTLCore::ModuleData* _moduleData, GTLCore::TypesManager* _typesManager, const GTLCore::String& _suffix, int _channels, const GTLCore::Type* _pixelType );
  };
}


#endif
