/*
 *  Copyright (c) 2008, 2009 Cyrille Berger <cberger@cberger.net>
 *  Copyright (c) 2009 Matthew Woehlke <mw_triad@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __STDC_LIMIT_MACROS
  # define __STDC_LIMIT_MACROS
#endif
# include <stdlib.h>
#include <stdint.h>
#include <math.h>

#include "rand_salt.h"
#include "OpenShiva/Export.h"

inline uint64_t permuteWhole(uint64_t n, uint64_t a, uint64_t b)
{
  return ((n * a) + b);
}

inline uint64_t part(uint64_t n1, uint64_t n2, int p)
{
  int b = p * 8;
  int i = (n1 >> b) & 0xFF;
  int j = (n2 >> b) & 0xFF;
  return uint64_t(salt[i][j]) << b;
}


uint64_t random64At(int64_t x, int64_t y, int64_t seed)
{
  const uint64_t kxa = 427140578808118991LL;
  const uint64_t kya = 166552399647317237LL;
  const uint64_t kxb = 48058817213113801LL;
  const uint64_t kyb = 9206429469018994469LL;

  // Generate salts
  uint64_t n1 = (uint64_t(x + 5) * kxa) * seed;
  uint64_t n2 = (uint64_t(y + 7) * kya) + (seed * 1040097393733LL);
  n1 = permuteWhole(n1, 8759824322359LL, 13);
  n2 = permuteWhole(n2, 200560490131LL, 2707);
  n1 = (n1 >> 32) ^ (n1 << 32);
  n2 = (n2 >> 32) ^ (n2 << 32);
  n1 ^= x ^ (uint64_t(y ^ seed) * kyb);
  n2 ^= y ^ (uint64_t(x + 13)   * kxb);

  // Combine salts
  uint64_t v = 0;
  for (int p = 0; p < 8; ++p)
      v |= part(n1, n2, p);
  return v;
}

extern "C" {
  OPENSHIVA_EXPORT float floatRandomAt(int32_t x, int32_t y, int32_t seed)
  {
    uint64_t r = random64At(x, y, seed);
    float v = r / (float)UINT64_MAX;
    return v;
  }

  OPENSHIVA_EXPORT int32_t intRandomAt(int32_t x, int32_t y, int32_t seed)
  {
    return random64At(x, y, seed);
  }
}