/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "GTLTest/Thread.h"
#include "GTLCore/Image.h"

#ifdef GTLTEST_HAVE_THREAD

class MyThreadTCTLKT : public GTLTest::Thread
{
  public:
    MyThreadTCTLKT(const OpenShiva::Kernel* _kernel, const GTLCore::AbstractImage* srcIm, GTLCore::AbstractImage* dstIm, const GTLCore::Region& _region)
      : m_stop(false), m_kernel(_kernel), m_srcIm(srcIm), m_dstIm(dstIm), m_region(_region)
    {
    }
    void stop()
    {
      m_stop = true;
    }
  protected:
    virtual void run()
    {
      std::list< GTLCore::AbstractImage* > images;
      images.push_back( const_cast<GTLCore::AbstractImage*>(m_srcIm));
      while(not m_stop)
      {
        m_kernel->evaluatePixeles( m_region, images, m_dstIm );
      }
    }
  private:
    bool m_stop;
    const OpenShiva::Kernel* m_kernel;
    const GTLCore::AbstractImage* m_srcIm;
    GTLCore::AbstractImage* m_dstIm;
    GTLCore::Region m_region;
};

class TestKernelThreading : public GTLTest::Case {
  public:
    TestKernelThreading() : GTLTest::Case("KernelThreading")
    {
    }
    virtual void runTest()
    {
      OpenShiva::Kernel k;
      k.setSource(
"kernel PlainGenerator \
{ \
  void evaluatePixel(input image img, out pixel result) \
  { \
    result = img.sampleNearest( result.coord ); \
  } \
}" );
      k.compile();
      GTLTEST_CHECK_REQUIRED(k.isCompiled());
      
      GTLCore::Image img(100, 100, GTLCore::PixelDescription(GTLCore::Type::Integer8, 4));
      GTLCore::Image img2(100, 100, GTLCore::PixelDescription(GTLCore::Type::Integer8, 4));
      
      MyThreadTCTLKT thread1(&k, &img, &img2, GTLCore::Region(0,0,50,50));
      thread1.start();
      MyThreadTCTLKT thread2(&k, &img, &img2, GTLCore::Region(0,50,50,50));
      thread2.start();
      MyThreadTCTLKT thread3(&k, &img, &img2, GTLCore::Region(50,0,50,50));
      thread3.start();
      MyThreadTCTLKT thread4(&k, &img, &img2, GTLCore::Region(50,50,50,50));
      thread4.start();
      sleep(3);
      thread1.stop();
      thread2.stop();
      thread3.stop();
      thread4.stop();
      thread1.wait();
      thread2.wait();
      thread3.wait();
      thread4.wait();
    }
};
#endif
