/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_BUFFER_H_
#define _GTLCORE_BUFFER_H_

namespace GTLCore {
  /**
   * A buffer is an interface for class providing a char* pointer.
   * @ingroup GTLCore
   */
  class Buffer {
    public:
      Buffer();
      virtual ~Buffer();
      /**
       * @return a pointer to the buffer
       */
      virtual char * rawData() = 0;
      /**
       * @return a pointer to the buffer casted to the parameter given as argument
       */
      template<typename _T_>
      inline _T_* data() { return reinterpret_cast<_T_*>( rawData() ); }
      /**
       * @return a constant pointer to the buffer
       */
      virtual const char * rawData() const =0;
      /**
       * @return a constant pointer to the buffer casted to the parameter given as argument
       * @code
       * Array array(10 * sizeof(double)); // Create an array of 10 doubles
       * array.data<double>() == (reinterpret_cast<double*>(array.rawData()) + 10) == (reinterpret_cast<double*>(array.rawData() + 10 *sizeof(double)))
       * @endcode
       */
      template<typename _T_>
      inline const _T_* data() const { return reinterpret_cast<const _T_*>( rawData() ); }
      /**
       * @return the size of the buffer
       */
      virtual int size() const = 0;
  };
}

#endif
