/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPTIMISER_P_H_
#define _OPTIMISER_P_H_

#include "Optimiser.h"

#include <map>

#include "String.h"

namespace llvm {
  class PassManager;
}

namespace GTLCore {
  /**
   * @internal
   * This class is mainly used to maintain the \ref llvm::PassManager used for optimizing the generated modules depending
   * on the current optimization level.
   * @ingroup GTLCore
   */
  class Optimiser::Private {
    friend class Optimiser;
    public:
      Private();
      ~Private();
      llvm::PassManager* passManager();
      void setLevel( int _level );
      bool isActive(const String& _passName ) const;
      void setActive(const String& _passName, bool _active );
    private:
      llvm::PassManager* m_passManager;
      std::map<String, bool> m_passActivity;
      static Optimiser* s_instance;
  };
}

#endif
