/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "GTLTest/Test.h"

#include "../Array.h"
#include "../Debug.h"
#include "../ErrorMessage.h"
#include "../PixelDescription.h"
#include "../String.h"
#include "../Type.h"
#include "../Value.h"
#include "../ConvertCenter_p.h"

using namespace GTLCore;

#include "TestErrorMessage.h"
#include "TestString.h"
#include "TestType.h"
#include "TestValue.h"
#include "TestPixelDescription.h"
#include "TestScopedName.h"
#include "TestConvertCenter.h"
#include "TestMetadata.h"
#include "TestMemoryManager.h"

class TestArray : public GTLTest::Case {
  public:
    TestArray() : GTLTest::Case("TestArray") {}
    virtual void runTest()
    {
      GTLCore::Array a(10);
      GTLTEST_CHECK_EQUAL(a.size(), 10);
      a.rawData()[0] = 42;
      a.rawData()[1] = 12;
      // Test Copy
      GTLCore::Array b = a;
      GTLTEST_CHECK_EQUAL(b.rawData()[0], 42);
      GTLTEST_CHECK_EQUAL(b.rawData()[1], 12);
      // Test Resize
      a.resize(20);
      GTLTEST_CHECK_EQUAL(a.size(), 20);
      GTLTEST_CHECK_NOT_EQUAL(a.rawData()[0], 42);
      GTLTEST_CHECK_NOT_EQUAL(a.rawData()[1], 12);
    }
};

GTLTEST_MAIN_BEGIN(TestGTLCore)
GTLTEST_MAIN_ADD_CASE(TestArray)
GTLTEST_MAIN_ADD_CASE(TestValue)
GTLTEST_MAIN_ADD_CASE(TestType)
GTLTEST_MAIN_ADD_CASE(TestPixelDescription)
GTLTEST_MAIN_ADD_CASE(TestString)
GTLTEST_MAIN_ADD_CASE(TestErrorMessage)
GTLTEST_MAIN_ADD_CASE(TestScopedName)
GTLTEST_MAIN_ADD_CASE(TestConvertCenter)
GTLTEST_MAIN_ADD_CASE(TestMetadata)
GTLTEST_MAIN_ADD_CASE(TestMemoryManager)
GTLTEST_MAIN_END()
