/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

class TestFloatType : public GTLTest::Case {
  public:
    TestFloatType() : GTLTest::Case("Float")
    {
    }
    virtual void runTest()
    {
      GTLTEST_CHECK_EQUAL(Type::Float->dataType(), Type::FLOAT);
      GTLTEST_CHECK_EQUAL(Type::Float->bitsSize(), 32);
      GTLTEST_CHECK_EQUAL(Type::Float->embeddedType(), 0);
      GTLTEST_CHECK_EQUAL(Type::Float->countStructDataMembers(), 0);
    }
};

class TestIntegerType : public GTLTest::Case {
  public:
    TestIntegerType() : GTLTest::Case("Integer")
    {
    }
    virtual void runTest()
    {
      GTLTEST_CHECK_EQUAL(Type::Integer8->dataType(), Type::INTEGER8);
      GTLTEST_CHECK_EQUAL(Type::Integer8->bitsSize(), 8);
      GTLTEST_CHECK_EQUAL(Type::Integer8->embeddedType(), 0);
      GTLTEST_CHECK_EQUAL(Type::Integer8->countStructDataMembers(), 0);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger8->dataType(), Type::UNSIGNED_INTEGER8);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger8->bitsSize(), 8);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger8->embeddedType(), 0);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger8->countStructDataMembers(), 0);
      GTLTEST_CHECK_EQUAL(Type::Integer16->dataType(), Type::INTEGER16);
      GTLTEST_CHECK_EQUAL(Type::Integer16->bitsSize(), 16);
      GTLTEST_CHECK_EQUAL(Type::Integer16->embeddedType(), 0);
      GTLTEST_CHECK_EQUAL(Type::Integer16->countStructDataMembers(), 0);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger16->dataType(), Type::UNSIGNED_INTEGER16);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger16->bitsSize(), 16);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger16->embeddedType(), 0);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger16->countStructDataMembers(), 0);
      GTLTEST_CHECK_EQUAL(Type::Integer32->dataType(), Type::INTEGER32);
      GTLTEST_CHECK_EQUAL(Type::Integer32->bitsSize(), 32);
      GTLTEST_CHECK_EQUAL(Type::Integer32->embeddedType(), 0);
      GTLTEST_CHECK_EQUAL(Type::Integer32->countStructDataMembers(), 0);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger32->dataType(), Type::UNSIGNED_INTEGER32);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger32->bitsSize(), 32);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger32->embeddedType(), 0);
      GTLTEST_CHECK_EQUAL(Type::UnsignedInteger32->countStructDataMembers(), 0);
    }
};

class TestType : public GTLTest::Suite {
  public:
    TestType() : GTLTest::Suite("Type")
    {
      addCase( new TestIntegerType);
      addCase( new TestFloatType);
    }
};

