/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

class TestFloatValue : public GTLTest::Case {
  public:
    TestFloatValue() : GTLTest::Case("Float")
    {
    }
    virtual void runTest()
    {
      Value vf(12.42f);
      GTLTEST_CHECK_NEAR_EQUAL( vf.asFloat(), 12.42);
      GTLTEST_CHECK_EQUAL( vf.asUnsignedInt32(), 12);
      GTLTEST_CHECK_EQUAL( vf.asBoolean(), true);
      GTLTEST_CHECK_EQUAL( vf.asInt32(), 12);
      GTLTEST_CHECK_EQUAL( vf.type(), Type::Float);
    }
};

class TestBooleanValue : public GTLTest::Case {
  public:
    TestBooleanValue() : GTLTest::Case("Boolean")
    {
    }
    virtual void runTest()
    {
      Value vbt(true);
      GTLTEST_CHECK( vbt.asBoolean());
      GTLTEST_CHECK_NEAR_EQUAL( vbt.asFloat(), 1.0);
      GTLTEST_CHECK_EQUAL( vbt.asInt32(), 1);
      GTLTEST_CHECK_EQUAL( vbt.asUnsignedInt32(), 1);
      GTLTEST_CHECK_EQUAL( vbt.type(), Type::Boolean);
      Value vbf(false);
      GTLTEST_CHECK_NEAR_EQUAL( vbf.asFloat(), 0.0);
      GTLTEST_CHECK_EQUAL( vbf.asInt32(), 0);
      GTLTEST_CHECK_EQUAL( vbf.asUnsignedInt32(), 0);
      GTLTEST_CHECK( not vbf.asBoolean());
      GTLTEST_CHECK_EQUAL( vbf.type(), Type::Boolean);
    }
};

class TestIntegerValue : public GTLTest::Case {
  public:
    TestIntegerValue() : GTLTest::Case("Integer")
    {
    }
    virtual void runTest()
    {
      Value vi(-42);
      GTLTEST_CHECK_EQUAL( vi.asInt32(), -42);
      GTLTEST_CHECK_NEAR_EQUAL( vi.asFloat(), -42.0);
      GTLTEST_CHECK_EQUAL( vi.asBoolean(), true);
      GTLTEST_CHECK_EQUAL( vi.asUnsignedInt32(), (0xFFFFFFFF - 42) + 1);
      GTLTEST_CHECK_EQUAL( vi.type(), Type::Integer32);
      vi.setInt32(20);
      GTLTEST_CHECK_EQUAL( vi.asInt32(), 20);
      GTLTEST_CHECK_NEAR_EQUAL( vi.asFloat(), 20);
      GTLTEST_CHECK_EQUAL( vi.asBoolean(), true);
      GTLTEST_CHECK_EQUAL( vi.asUnsignedInt32(), 20);
      GTLTEST_CHECK_EQUAL( vi.type(), Type::Integer32);
    }
};

class TestUnsignedIntegerValue : public GTLTest::Case {
  public:
    TestUnsignedIntegerValue() : GTLTest::Case("UnsignedInteger")
    {
    }
    virtual void runTest()
    {
      Value vui((unsigned int)32);
      GTLTEST_CHECK_EQUAL( vui.asUnsignedInt32(), 32);
      GTLTEST_CHECK_NEAR_EQUAL( vui.asFloat(), 32.0);
      GTLTEST_CHECK_EQUAL( vui.asBoolean(), true);
      GTLTEST_CHECK_EQUAL( vui.asInt32(), 32);
      GTLTEST_CHECK_EQUAL( vui.type(), Type::UnsignedInteger32);
    }
};

class TestValue : public GTLTest::Suite {
  public:
    TestValue() : GTLTest::Suite("Value")
    {
      addCase(new TestFloatValue);
      addCase(new TestBooleanValue);
      addCase(new TestIntegerValue);
      addCase(new TestUnsignedIntegerValue);
    }
};

