/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENSHIVA_CODE_GENERATOR_P_H_
#define _OPENSHIVA_CODE_GENERATOR_P_H_

#include <vector>
#include "Kernel_p.h"

namespace llvm {
  class BasicBlock;
  class Function;
  class Module;
  class Value;
}

namespace GTLCore {
  class Function;
  class GenerationContext;
  class ModuleData;
  class Type;
  class PixelDescription;
}

namespace OpenShiva {
  class Kernel;
  /**
   * @internal
   * Provide code generation function for specific features of OpenShiva
   * @ingroup OpenShiva
   */
  class CodeGenerator {
    public:
      /**
       * Copy a pixel from memory to the vector.
       */
      static llvm::BasicBlock* memToPixel( GTLCore::GenerationContext& _gc, llvm::BasicBlock* _currentBlock, llvm::Value* _dataPointer, llvm::Value* _pixel, llvm::Value* _image );
      static llvm::BasicBlock* pixelToMem( GTLCore::GenerationContext& _gc, llvm::BasicBlock* _currentBlock, llvm::Value* _pixel, llvm::Value* _dataPointer, llvm::Value* _image );
      static llvm::Function* generateEvaluatePixeles( Kernel* _kernel, int _channels );
      static llvm::Function* generateMemToVec( GTLCore::ModuleData* _moduleData, const GTLCore::PixelDescription& _pixelDescription );
      static llvm::Function* generateVecToMem( GTLCore::ModuleData* _moduleData, const GTLCore::PixelDescription& _pixelDescription );
      /**
       * Generate a sample nearest function.
       */
      static llvm::Function* generateImageSampleNearest( GTLCore::ModuleData* _moduleData, const GTLCore::Type* _imageType, const GTLCore::Type* _type );
      /**
       * @return a pointer to the data pointer of a pixel (as a pointer to a vector of float)
       */
      static llvm::Value* accessPixelDataPtr( GTLCore::GenerationContext& _gc, llvm::BasicBlock* _currentBlock, llvm::Value* _pixel);
      /**
       * @return a pointer to the data pointer of a pixel cast to a (float*)
       */
      static llvm::Value* accessPixelDataAsF32Ptr( GTLCore::GenerationContext& _gc, llvm::BasicBlock* _currentBlock, llvm::Value* _pixel);
    private:
      static llvm::Function* createMemCpyFunction( llvm::Module* _module );
      static llvm::Value* accessPixelDataAsU8Ptr( GTLCore::GenerationContext& _gc, llvm::BasicBlock* _currentBlock, llvm::Value* _pixel);
      static llvm::Value* callMemcpy( GTLCore::GenerationContext& _gc, llvm::BasicBlock* _currentBlock, llvm::Value* _dst, llvm::Value* _src, llvm::Value* _n );
      static void setPixelCoordinates( GTLCore::GenerationContext& _gc, llvm::BasicBlock* _currentBlock, llvm::Value* _dst, llvm::Value* _iVal, const GTLCore::Type* _iValType, llvm::Value* _jVal, const GTLCore::Type* _jValType );
      /**
       * Call a "virtual" member of a structure, aka, a member with a pointer.
       */
      static llvm::Value* callVirtualMember( GTLCore::GenerationContext& _gc, llvm::BasicBlock* _currentBlock, llvm::Value* _pointer, int _member_index , std::vector<llvm::Value*> arguments);
      static llvm::Value* callImageWrapData( GTLCore::GenerationContext& _gc, llvm::BasicBlock* _currentBlock, const GTLCore::Type* _imageType, llvm::Value* _imageWrap, llvm::Value* _x, llvm::Value* _y );
    private:
      static int s_evaluatePixelesId;
  };
}

#endif
