/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENSHIVA_KERNEL_H_
#define _OPENSHIVA_KERNEL_H_

#include <list>

namespace GTLCore {
  class AbstractImage;
  class ModuleData;
  class Region;
}

#include <OpenShiva/Library.h>
#include <GTLCore/Macros.h>

namespace OpenShiva {
  /**
   * This is the main class in OpenShiva, it is used to compile the kernel, and to apply it on
   * a set of images.
   * 
   * @ingroup OpenShiva
   */
  class Kernel : public Library {
    friend class CodeGenerator;
    public:
      /**
       * Use \ref Kernel(int) instead
       */
      GTL_DEPRECATED Kernel(const GTLCore::String& _name, int _channelsNb = 4 );
      /**
       * @param indicates the number of channel for the 'pixel' and 'image' type
       */
      Kernel(int _channelsNb = 4 );
      virtual ~Kernel();
    private:
      virtual void cleanup();
      virtual void postCompilation();
    public: // Function call
      void evaluatePixeles( const GTLCore::Region& _region, const std::list< GTLCore::AbstractImage* >& _inputImages, GTLCore::AbstractImage* _outputImage) const;
      /**
       * Run the function called "int runTest()" in the Kernel.
       */
      int runTest() const;
      /**
       * @return true if the test function is available
       */
      bool hasTestFunction() const;
      
      GTLCore::Region needed( GTLCore::Region output_region, int input_index, const std::list< GTLCore::Region>& input_DOD);
      bool hasNeededFunction() const;
      GTLCore::Region changed( GTLCore::Region changed_input_region, int input_index, const std::list< GTLCore::Region>& input_DOD);
      bool hasChangedFunction() const;
      GTLCore::Region generated();
      bool hasGeneratedFunction() const;
    private:
      struct Private;
      Private * const d;
  };
}

#endif
