#!/usr/bin/ruby
#   Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation;
#  version 2 of the License, or (at your option) any later version of the License.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
# 
#  You should have received a copy of the GNU Lesser General Public License
#  along with this library; see the file COPYING.  If not, write to
#  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA 02110-1301, USA.

# Generate callers for up to 4 parameters (change this value to get more), but compilation
# time increase drastically for maxparameters > 4 (not really anymore that there is no
# templates involved, but 4 generates a 50000 lines file, and 6 a 200000 lines, ...)
maxparameters = 4

puts <<ENDOFPUTS
/*
 * This file was generated by generate-function-callers.rb. Don't make
 * direct modification to that file but rather to the generator.
 *
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
ENDOFPUTS

parameters = maxparameters

TypeArray = [ [ "int", ["INTEGER32"] ], [ "bool", ["BOOLEAN"] ], ["unsigned int", ["UNSIGNED_INTEGER32"] ], [ "float", [ "HALF", "FLOAT" ] ] ]

ReturnTypeArray = TypeArray.clone
ReturnTypeArray << [ "void", ["VOID"] ]

def typeToString( type )
  return type.gsub(" ", "_").gsub("*", "p" )
end

def className( indexRT, index )
  name = "FunctionCaller"
  name += "_#{typeToString(ReturnTypeArray[indexRT][0])}"
  for i in 0...index.size
    name += "_#{typeToString(TypeArray[index[i]][0])}"
  end
  return name
end

def updateIndex( index, indexIndex )
  if( indexIndex + 1 > index.size)
    return false
  end
  index[indexIndex] += 1
  if( index[indexIndex] >= TypeArray.size )
    index[indexIndex] = 0
    return updateIndex( index, indexIndex + 1)
  else
    return true
  end
end

while( parameters >= 0 )
  puts "// Number of parameters = #{parameters}"
  
  index = []
  for i in 0...parameters
    index[i] = 0
  end
  
  for indexRT in 0...ReturnTypeArray.size
    begin
      klassName = className( indexRT, index )
      puts <<ENDOFCLASS
// #{indexRT} #{index.join(",")}
class #{klassName} : public FunctionCaller {
  public:
    #{klassName}(llvm::Function* llvmFunction, const Function* function) : FunctionCaller( llvmFunction, function)
    {
    }
    virtual GTLCore::Value call(const std::vector<GTLCore::Value>& arguments )
    {
      GTL_ASSERT(function());
      GTL_ASSERT(arguments.size() == #{parameters});
ENDOFCLASS
      # Convert the parameters
      listType = ""
      listArgs = ""
      for i in 0...parameters
        typeName = TypeArray[index[i]][0]
        listType += typeName
        listArgs += "arg#{i+1}"
        unless( i == parameters - 1)
          listType += ","
          listArgs += ","
        end
        puts <<ENDOFINITPARAMETERS
      #{typeName} arg#{i+1} = GTLCore::PrimitiveTypeTrait<#{typeName}>::convert( arguments[#{i}] );
ENDOFINITPARAMETERS
      end
      # Convert the function
      typeReturn = ReturnTypeArray[indexRT][0]
      puts <<ENDOFCONVERTFUNCTION
      #{typeReturn} (*PF)(#{listType}) = (#{typeReturn}(*)(#{listType})) VirtualMachine::instance()->getPointerToFunction(function());
ENDOFCONVERTFUNCTION
      if( typeReturn == "void" )
        puts "      PF(#{listArgs});\n      return GTLCore::Value();"
      else
        puts "      return GTLCore::Value( PF(#{listArgs}) );"
      end
      puts <<ENDOFCALLBEGINOFCREATEFUNCTION
    }
  public:
    static FunctionCaller* create(llvm::Function* llvmFunction, const Function* function)
    {
      if( function->parameters().size() == #{parameters} )
      {
        return new #{klassName}(llvmFunction, function);
      } else {
ENDOFCALLBEGINOFCREATEFUNCTION
      if( parameters == maxparameters )
        puts "        return new FunctionCallerFallBack(llvmFunction, function);"
      else
        puts <<ENDOFCREATESWITCHBEGIN
        switch( function->parameters()[#{parameters}].type()->dataType() )
        {
ENDOFCREATESWITCHBEGIN
        TypeArray.each() { |x|
          x[1].each() { |y|
            puts "          case GTLCore::Type::#{y}:"
          }
          puts "            return #{klassName}_#{typeToString(x[0])}::create(llvmFunction, function);"
        }
        puts <<ENDOFCREATESWITCHEND
          default:
            return new FunctionCallerFallBack(llvmFunction, function);
        }
ENDOFCREATESWITCHEND
      end
      puts <<ENDOFCLASS
      }
    }
};
ENDOFCLASS
    
    end while( updateIndex( index, 0 ) )
  end
  
  parameters -= 1
end

# Create creator

puts <<CREATOR
FunctionCaller* createFunctionCaller( llvm::Function* llvmFunction, const Function* function)
{
  switch( function->returnType()->dataType() )
  {
CREATOR
ReturnTypeArray.each() { |x|
  x[1].each() { |y|
    puts "    case GTLCore::Type::#{y}:"
  }
  puts "      return FunctionCaller_#{typeToString(x[0])}::create(llvmFunction, function);"
}

puts <<ENDCREATOR
    default:
      return new FunctionCallerFallBack(llvmFunction, function);
  }
}
ENDCREATOR
