Name: OpenIPMI
Summary: %{name} - Library interface to IPMI
Version: 2.0.1
Release: 1
License: LGPL
URL: http://openipmi.sourceforge.net
Group: Utilities
Vendor: OpenIPMI Project
Packager: Tariq Shureih <tariq.shureih@intel.com>
Source: %{name}-2.0.1.tar.gz
Buildroot: /var/tmp/%{name}-root
BuildRequires: pkgconfig, perl >= 5, swig >= 1.3
Summary: IPMI Library
Group: Utilities

# Perl is usually installed in /usr/lib, not /usr/lib64 on 64-bit platforms.
%define perl_libdir %{_exec_prefix}/lib

%description 
This package contains a shared library implementation of IPMI and the
basic tools used with OpenIPMI.

%package devel
Summary: Development files for OpenIPMI
Group: Utilities
Requires: OpenIPMI = %{version}, pkgconfig

%description devel
Contains additional files need for a developer to create applications
and/or middleware that depends on libOpenIPMI

%package perl
Summary: Perl interface for OpenIPMI
Group: Utilities
Requires: OpenIPMI = %{version}, perl >= 5

%description perl
A Perl interface for OpenIPMI.

%package python
Summary: Python interface for OpenIPMI
Group: Utilities
Requires: OpenIPMI = %{version}, python

%description python
A Python interface for OpenIPMI.

%package ui
Summary: User Interface (ui)
Group: Utilities
Requires: OpenIPMI = %{version}

%description ui
This package contains a user interface

%package lanserv
Summary: Emulates an IPMI network listener
Group: Utilities
Requires: OpenIPMI = %{version}

%description lanserv
This package contains a network IPMI listener.

###################################################
%prep
###################################################
%setup

###################################################
%build
###################################################
%configure
make

###################################################
%install
###################################################
rm -rf %{buildroot}
make DESTDIR=%{buildroot} install

###################################################
%files
###################################################
%defattr(-,root,root)
%{_libdir}/libOpenIPMIcmdlang.so*
%{_libdir}/libOpenIPMIcmdlang.la
%{_libdir}/libOpenIPMIglib.so*
%{_libdir}/libOpenIPMIglib.la
%{_libdir}/libOpenIPMIposix.so*
%{_libdir}/libOpenIPMIposix.la
%{_libdir}/libOpenIPMIpthread.so*
%{_libdir}/libOpenIPMIpthread.la
%{_libdir}/libOpenIPMI.so*
%{_libdir}/libOpenIPMI.la
%{_libdir}/libOpenIPMIutils.so*
%{_libdir}/libOpenIPMIutils.la
%doc COPYING COPYING.LIB FAQ INSTALL README README.Force
%doc README.MotorolaMXP

###################################################
%files perl
###################################################
%defattr(-,root,root)
%{perl_libdir}/perl5
%doc swig/OpenIPMI.i swig/perl/sample swig/perl/ipmi_powerctl

###################################################
%files python
###################################################
%defattr(-,root,root)
%{_exec_prefix}/lib/python*
%doc swig/OpenIPMI.i swig/python/ipmigui.py

###################################################
%files devel
###################################################
%defattr(-,root,root)
%{_includedir}/OpenIPMI
%{_libdir}/*.a
%{_libdir}/pkgconfig
%doc doc/IPMI.pdf

###################################################
%files ui
###################################################
%defattr(-,root,root)
%{_bindir}/ipmi_ui
%{_bindir}/ipmicmd
%{_bindir}/ipmish
%{_bindir}/solterm
%{_libdir}/libOpenIPMIui.so*
%{_libdir}/libOpenIPMIui.la
%doc %{_mandir}/man1/ipmi_ui.1*
%doc %{_mandir}/man1/ipmicmd.1*
%doc %{_mandir}/man1/ipmish.1*
%doc %{_mandir}/man7/ipmi_cmdlang.7*

###################################################
%files lanserv
###################################################
%defattr(-,root,root)
%{_bindir}/ipmilan
%{_libdir}/libIPMIlanserv.so*
%{_libdir}/libIPMIlanserv.la
%doc %{_mandir}/man8/ipmilan.8*

