; -*- Mode: Lisp; Package: CCL; -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html


#+allow-in-package
(in-package "CCL")

(defsparclapfunction %address-of ((arg %arg_z))
  ; %address-of a fixnum is a fixnum, just for spite.
  ; %address-of anything else is the address of that thing as an integer.
  (andcc arg arch::fixnummask %rzero)
  (be @done)
    (mov arg %imm0)
  (box-unsigned-byte-32 %imm0 %imm1 %arg_z)
  @done
  (retl)
    (nop))


;;; "areas" are fixnum-tagged and, for the most part, so are their
;;; contents.

;;; The nilreg-relative global all-areas is a doubly-linked-list header
;;; that describes nothing.  Its successor describes the current/active
;;; dynamic heap.  The nilreg-relative globals current-cs, current-vs, and
;;; current-ts describe the current thread's stack areas.

;;; In general, the "active" pointers in these areas are really the values
;;; in the stack- and free-pointer registers.  Update the "area" data structures,
;;; and return a pointer to the active dynamic area.

; This is called by resume-stack-group in a context where it's
; not OK to signal a lisp error. Hence, it must remain in LAP
; so that it can't possibly cause a control stack overflow.
; The current-vs (current-ts) area is guranteed to point to
; the area containing vsp (tsp) or a younger area.
(defsparclapfunction %normalize-areas ()
  (let ((address %imm0)
        (temp %imm2)
        (sg %arg_z))
    (ld (%nfn '*current-stack-group*) %temp0)
    (ld (%temp0 arch::symbol.vcell) sg)

    ; update active pointer for tsp area.
    (b @tsploop)
      (ref-global address current-ts)
@nexttsp
    (ld (address arch::area.older) address)
    (tst address)
    (be.a @tsploop)
      (unimp 0) ; can't error during stack-group-resume
@tsploop
    (ld (address arch::area.low) temp)
    (cmp temp %tsp)
    (ld (address arch::area.high) temp)
    (bg @nexttsp)
      (cmp temp %tsp)
    (ble @nexttsp)
      (nop)
    (set-global address current-ts)
    (svset address sg.ts-area sg t)
    (st %tsp (address arch::area.active))
@tsploop2
    ; Younger tsp areas all have no active area. Make it so.
    (ld (address arch::area.younger) address)
    (tst address)
    (be @tspdone)
      (nop)
    (ld (address arch::area.high) temp)
    (b @tsploop2)
      (st temp (address arch::area.active))
@tspdone    
    ; Update active pointer for vsp area.
    (b @vsploop)
      (ref-global address current-vs)
    @nextvsp
    (ld (address arch::area.older) address)
    (tst address)
    (bne @vsploop)
      (nop)
    (unimp 0)  ; can't error during stack-group-resume
    @vsploop
    (ld (address arch::area.low) temp)
    (cmp temp %vsp)
    (bg @nextvsp)
      (ld (address arch::area.high) temp)
    (cmp temp %vsp)
    (ble @nextvsp)
      (nop)
    (set-global address current-vs)
    (svset address sg.vs-area sg t)
    (st %vsp (address arch::area.active))
    @vsploop2
    ; Younger vsp areas all have no active area. Make it so.
    (ld (address arch::area.younger) address)
    (tst address)
    (be @vspdone)
      (nop)
    (ld (address arch::area.high) temp)
    (b @vsploop2)
      (st temp (address arch::area.active))
    @vspdone
    
    ; Update active pointer for SP area
    (ref-global %arg_z current-cs)
    (st %sp (%arg_z arch::area.active))

    ; Update active pointer for dynamic heap area
    (ref-global %arg_z all-areas)
    (ld (%arg_z arch::area.succ) %arg_z)
    (retl)
      (st %freeptr (%arg_z arch::area.active))))

(defsparclapfunction %object-in-stack-area-p ((object %arg_y) (area %arg_z))
  (ld (area arch::area.active) %imm0)
  (ld (area arch::area.high) %imm1)
  (cmp object %imm0)
  (mov 0 %imm0)
  (bl @done)
    (cmp object %imm1)
  (bl.a @done)
    (mov arch::t-offset %imm0)
  @done
  (retl)
    (add %rnil %imm0 %arg_z))

(defsparclapfunction %object-in-heap-area-p ((object %arg_y) (area %arg_z))
  (ld (area arch::area.low) %imm0)
  (ld (area arch::area.active) %imm1)
  (cmp object %imm0)
  (mov 0 %imm0)
  (bl @done)
    (cmp object %imm1)
  (bl.a @done)
    (mov arch::t-offset %imm0)
  @done
  (retl)
    (add %rnil %imm0 %arg_z))

(defsparclapfunction walk-static-area ((a %arg_y) (f %arg_z))
  (let ((fun %save0)
        (obj %save1)
        (limit %save2)
        (header %imm0)
        (tag %imm1)
        (subtag %imm2)
        (bytes %imm3)
        (elements %imm0))
    (save-lisp-context)
    (:regsave limit 0)
    (vpush fun)
    (vpush obj)
    (vpush limit)
    (mov f fun)
    (ld (a arch::area.active) limit)
    (b @test)
      (ld (a arch::area.low) obj)
    @loop
    (ld (obj) header)
    (extract-fulltag header tag)
    (cmp tag arch::fulltag-immheader)
    (be @misc)
      (cmp tag arch::fulltag-nodeheader)
    (be @misc)
      (nop)
    (add obj arch::fulltag-cons %arg_z)
    (set-nargs 1)
    (call-subprim .SPFuncall)
      (mov fun %temp0)
    (b @test)
    (inc arch::cons.size obj)
    @misc
    (add obj arch::fulltag-misc %arg_z)
    (set-nargs 1)
    (call-subprim .SPFuncall)
      (mov fun %temp0)
    (ld (obj 0) header)
    (extract-fulltag header tag)
    (extract-subtag header subtag)
    (header-size header elements)
    (sll elements 2 bytes)
    (cmp tag arch::fulltag-nodeheader)
    (be @bump)
      (cmp subtag arch::max-32-bit-ivector-subtag)
    (ble @bump)
    (mov elements bytes)
    (cmp subtag arch::max-8-bit-ivector-subtag)
    (ble @bump)
      (cmp subtag arch::max-16-bit-ivector-subtag)
    (ble @bump)
      (sll elements 1 bytes)
    (cmp subtag arch::subtag-double-float-vector)
    (be.a @bump)
      (sll elements 3 bytes)
    (inc 7 elements)
    (srl elements 3 bytes)
    @bump
    (inc (+ 4 7) bytes)
    (andn bytes arch::fulltagmask bytes)
    (inc bytes obj)
    @test
    (cmp obj limit)
    (bl @loop)
      (nop)
    (vpop limit)
    (vpop obj)
    (vpop fun)
    (restore-full-lisp-context)
    (retl)
      (nop)))

; This walks the active "dynamic" area.  Objects might be moving
; around while we're doing this, so we have to be a lot more careful
; than we are when walking a static area.  We use the %loc-g register
; to point at objects on doubleword boundaries, and set some bits in
; the %freeptr register to tell a (hypothetical) preemptively scheduled
; GC to be careful ...
; There are a couple of approaches to termination:
;  a) Allocate a "sentinel" cons, and terminate when we run into it.
;  b) Check the area limit (which is changing if we're consing) and
;     terminate when we hit it.
; (b) loses if the function conses.  (a) conses.  I can't think of anything
; better than (a).
; This, of course, assumes that any GC we're doing does in-place compaction
; (or at least preserves the relative order of objects in the heap.)
    
(defsparclapfunction walk-dynamic-area ((a %arg_y) (f %arg_z))
  (let ((fun %save0)
        (obj %save1)
        (sentinel %save2)
	(walk %save3)
        (header %imm0)
        (tag %imm1)
        (subtag %imm2)
        (bytes %imm3)
        (elements %imm4))
    (save-lisp-context)
    (vpush fun)
    (vpush obj)
    (vpush sentinel)
    (phys-alloc arch::cons.size arch::fulltag-cons)
    (sub %freeptr arch::cons.size sentinel)
    (untag-freeptr)
    (ref-global %imm0 tenured-area)
    (tst %imm0)
    (mov f fun)
    (bne.a @0)
      (mov %imm0 a)
    @0
    (tag-freeptr arch::fulltag-nil)
    (ld (a arch::area.low) %loc-g)
    @loop
    (ld (%loc-g) header)
    (extract-fulltag header tag)
    (cmp tag arch::fulltag-immheader)
    (be @misc)
      (cmp tag arch::fulltag-nodeheader)
    (be @misc)
      (nop)
    (add %loc-g arch::fulltag-cons obj)
    (clr %loc-g)
    (cmp obj sentinel)
    (be @done)
      (untag-freeptr)
    (mov obj %arg_z)
    (set-nargs 1)
    (call-subprim .SPfuncall)
      (mov fun %temp0)
    (tag-freeptr arch::fulltag-nil)
    (b @loop)
      (add obj (- arch::cons.size arch::fulltag-cons) obj)
    @misc
    (add %loc-g arch::fulltag-misc obj)
    (clr %loc-g)
    (untag-freeptr)
    (mov obj %arg_z)
    (set-nargs 1)
    (call-subprim .SPFuncall)
      (mov fun %temp0)
    (getvheader obj header)
    (extract-fulltag tag header)
    (extract-fulltag header tag)
    (extract-subtag header subtag)
    (header-size header elements)
    (sll elements 2 bytes)
    (cmp tag arch::fulltag-nodeheader)
    (be @bump)
      (cmp subtag arch::max-32-bit-ivector-subtag)
    (ble @bump)
    (mov elements bytes)
    (cmp subtag arch::max-8-bit-ivector-subtag)
    (ble @bump)
      (cmp subtag arch::max-16-bit-ivector-subtag)
    (ble @bump)
      (sll elements 1 bytes)
    (cmp subtag arch::subtag-double-float-vector)
    (be.a @bump)
      (sll elements 3 bytes)
    (inc 7 elements)
    (srl elements 3 bytes)
    @bump
    (inc (+ 4 7) bytes)
    (bclr arch::fulltagmask bytes)
    (tag-freeptr arch::fulltag-cons)
    (b @loop)
      (andn obj arch::fulltagmask %loc-g)
    @done
    (mov %rnil %arg_z)
    (vpop sentinel)
    (vpop obj)
    (vpop fun)
    (restore-full-lisp-context)
    (retl)
     (nop)))




    


  

; end
