; -*- Mode: Lisp;  Package: CCL; -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html



; l0-utils.lisp


#+allow-in-package
(in-package "CCL")

(defun %proclaim-notspecial (sym)
  (%symbol-bits sym (logandc2 (%symbol-bits sym) (ash 1 $sym_bit_special))))





; It doesn't make sense to call this with a fixnum or imm-tagged object
(defun %area-containing-object (object)
  (do* ((a (%normalize-areas) (%lisp-word-ref a (ash arch::area.succ -2))))
       ()
    (let* ((code (%lisp-word-ref a (ash arch::area.code -2))))
      (declare (fixnum code))
      (if (= code arch::area-void)
        (return nil)
        (if (if (>= code arch::min-heap-area-code)
              (%object-in-heap-area-p object a)
              (%object-in-stack-area-p object a))
          (return a))))))

; We MAY need a scheme for finding all of the areas in a lisp library.
(defun %map-areas (function &optional (maxcode arch::area-dynamic) (mincode arch::area-readonly))
  (declare (fixnum maxcode mincode))
  (do* ((a (%normalize-areas) (%lisp-word-ref a (ash arch::area.succ -2)))
        (code arch::area-dynamic (%lisp-word-ref a (ash arch::area.code -2)))
        (dynamic t nil))
       ((= code arch::area-void))
    (declare (fixnum code))
    (if (and (<= code maxcode)
             (>= code mincode))
      (if dynamic 
        (walk-dynamic-area a function)
        (unless (= code arch::area-dynamic)        ; ignore egc areas, 'cause walk-dynamic-area sees them.
          (walk-static-area a function))))))


   ; there'll be functions in static lib areas.


(defun %map-lfuns (f)
  (let* ((filter #'(lambda (obj) (when (functionp obj) (funcall f obj)))))
    (declare (dynamic-extent filter))
    (%map-areas filter arch::area-dynamic arch::area-staticlib)))


(defun ensure-simple-string (s)
  (cond ((simple-string-p s) s)
        ((stringp s)
         (let* ((len (length s))
                (new (make-string len :element-type 'base-char)))
           (declare (fixnum len)(optimize (speed 3)(safety 0)))
           (multiple-value-bind (ss offset) (array-data-and-offset s)
	     (%copy-ivector-to-ivector ss offset new 0 len))
           new))
        (t (report-bad-arg s 'string))))

; Returns two fixnums: low, high
#+ppc-target
(defppclapfunction macptr-to-fixnums ((macptr arg_z))
  (check-nargs 1)
  (trap-unless-typecode= macptr arch::subtag-macptr)
  (lwz imm0 arch::macptr.address macptr)
  (rlwinm imm1 imm0 2 14 29)
  (vpush imm1)
  (rlwinm imm1 imm0 18 14 29)
  (vpush imm1)
  (set-nargs 2)
  (la temp0 8 vsp)
  (ba .SPvalues))

#+sparc-target
(defsparclapfunction macptr-to-fixnums ((macptr %arg_z))
  (check-nargs 1)
  (trap-unless-typecode= macptr arch::subtag-macptr)
  (ld (macptr arch::macptr.address) %imm0)
  (sll %imm0 16 %imm1)
  (srl %imm1 (- 16 arch::fixnumshift) %imm1)
  (vpush %imm1)
  (srl %imm0 (- 16 arch::fixnumshift) %imm1)
  (vpush %imm1)
  (set-nargs 2)
  (jump-subprim .SPvalues)
  (add %vsp 8 %temp0))



(defun macptr<= (p1 p2)
  (multiple-value-bind (p1-low p1-high) (macptr-to-fixnums p1)
    (declare (fixnum p1-low p1-high))
    (multiple-value-bind (p2-low p2-high) (macptr-to-fixnums p2)
      (declare (fixnum p2-low p2-high))
      (or (< p1-high p2-high)
          (and (eql p1-high p2-high)
               (<= p1-low p2-low))))))

(defun macptr-evenp (p)
  (let ((low (macptr-to-fixnums p)))
    (declare (fixnum low))
    (evenp low)))

; If OBJECT is in a read-only area, return the number of words between
; the start of that area and the first word of data in the object.
; Since only vector-like objects can be allocated in a readonly area,
; "the first word of data" means "the first word beyond the header".
; If OBJECT isn't in a read-only area, return nil.
; The "skip" argument indicates the number of words beyond the start
; of the area that we aren't interested in, e.g., there's a header &
; pad word between the start of the readonly area and the subprims
; jump table.
(defun %readonly-area-word-offset (object &optional (skip 0))
  (let* ((a (%area-containing-object object)))
    (if (and a (eql (%lisp-word-ref a (ash arch::area.code -2))
                    arch::area-readonly))
      (%i- (strip-tag-to-fixnum object)
           (%i+ skip (%lisp-word-ref a (ash arch::area.low -2)))))))

; end
