/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of OpenMCL.  

   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
   License , known as the LLGPL and distributed with OpenMCL as the
   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
   which is distributed with OpenMCL as the file "LGPL".  Where these
   conflict, the preamble takes precedence.  

   OpenMCL is referenced in the preamble as the "LIBRARY."

   The LLGPL is also available online at
   http://opensource.franz.com/preamble.html
*/
	include(m4macros.m4)
	_beginfile
	
	.globl C(import_ptrs_base)
define([defimport],[
	.globl C($1)
	.long C($1)
# __line__
])
	.data
import_ptrs_start:

	defimport(fd_setsize_bytes)
	defimport(do_fd_set)
	defimport(do_fd_clr)
	defimport(do_fd_is_set)
	defimport(do_fd_zero)
	defimport(xMakeDataExecutable)
	defimport(xGetSharedLibrary)
	defimport(xFindSymbol)
	defimport(allocate)
	defimport(deallocate)
	defimport(allocate_tstack)
	defimport(allocate_vstack)
	defimport(register_cstack)
	defimport(condemn_area_chain)
	defimport(metering_control)
	defimport(restore_soft_stack_limit)
	defimport(lisp_egc_control)
	defimport(lisp_bug)
	defimport(xNewThread)
	defimport(xYieldToThread)
	defimport(xDisposeThread)
	defimport(xThreadCurrentStackSpace)
	defimport(usage_exit)
	defimport(save_fp_context)
	defimport(restore_fp_context)
	defimport(put_altivec_registers)
	defimport(get_altivec_registers)

ifdef([PROXY_SCHEDULER],[
	define([proxy_import],[
	.globl C($1)
	.long C($1)
# __line__
])

.proxy_ptrs_start:
	proxy_import(create_proxy_task)
	proxy_import(pop_proxy_q)
	proxy_import(kill_proxy)
	proxy_import(proxy_wait)
	proxy_import(proxy_wait_mutex)
	proxy_import(proxy_wait_select_input)
	proxy_import(proxy_wait_counting_semaphore)
	proxy_import(proxy_wait_timeout)
	proxy_import(current_task_priority)
	proxy_import(allocate_proxy_events)
	proxy_import(retrieve_proxy_events)
	proxy_import(record_proxy_event)
	proxy_import(proxy_interrupt)
	proxy_import(proxy_restore)

	.globl C(proxy_ptrs_base)
C(proxy_ptrs_base):
	.long proxy_ptrs_start
])

C(import_ptrs_base):
	.long import_ptrs_start

	.globl C(subprims_base)
	.globl C(ret1valn)
	.globl C(lexpr_return)
	.globl C(lexpr_return1v)
	.globl C(start_lisp)
ifdef([LINUX],[
	.globl __trampoline_setup
	.long  __trampoline_setup
])

ifdef([VXWORKS],[
C(subprims_base):	
	.long 0
C(start_lisp):	
	.long 0
C(ret1valn):	
	.long 0
C(lexpr_return):	
	.long 0
C(lexpr_return1v):	
	.long 0
	
	.globl C(vx_signal)
	.globl C(init_vxlow)
	.globl C(vxlow_cleanup)
C(vx_signal):
	.long 0
C(init_vxlow):
	.long 0
C(vxlow_cleanup):
	.long 0

],[
	WEAK(.subprims_base)
	WEAK(.start_lisp)
	WEAK(.nvalret)
	WEAK(.popj)
	WEAK(.ret1valn)

C(subprims_base):	
	.long .subprims_base
C(start_lisp):	
	.long .start_lisp
C(ret1valn):	
	.long .ret1valn
C(lexpr_return):	
	.long .nvalret
C(lexpr_return1v):	
	.long .popj
])

	_endfile
