/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of OpenMCL.  

   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
   License , known as the LLGPL and distributed with OpenMCL as the
   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
   which is distributed with OpenMCL as the file "LGPL".  Where these
   conflict, the preamble takes precedence.  

   OpenMCL is referenced in the preamble as the "LIBRARY."

   The LLGPL is also available online at
   http://opensource.franz.com/preamble.html
*/

	
/* Traps, foreign-function calls, callbacks. */



	include(lisp.s)
	_beginfile

	.globl jmpsym

/* These are leftovers from MacOS MCL ;  some of them weren't even
   used there in recent memory.  None of them should be called ;
   enter the lisp kernel debugger (via _SPbreakpoint) if any of them
   is.
*/

_spentry(regtrap)
_spentry(strap)
_spentry(ffcalladdress)

/* Enter the debugger */
_spentry(breakpoint)
	__(li r3,0)
	__(tw 28,sp,sp)	/* 28 = lt|gt|eq (assembler bug for the latter) */
	__(blr)		/* if handler didn't */


/*
  Do a system call in Darwin.  The stack is set up much as it would be
  for a PowerOpen ABI ff-call:	register parameters are in the stack
  frame, and there are 4 extra words at the bottom of the frame that
  we can carve a lisp frame out of.

  System call return conventions are a little funky in Darwin: if "@sc"
  is the address of the "sc" instruction, errors return to @sc+4 and
  non-error cases return to @sc+8.  Error values are returned as
  positive values in r3; this is true even if the system call returns
  a doubleword (64-bit) result.  Since r3 would ordinarily contain
  the high half of a doubleword result, this has to be special-cased.

  The caller should set the c_frame.crsave field of the stack frame
  to 0 if the result is to be interpreted as anything but a doubleword
  and to non-zero otherwise.  (This only matters on an error return.)
*/
_spentry(darwin_syscall)
	__(mflr loc_pc)
	__(vpush_saveregs())
	__(lwz imm1,0(sp))
	__(la imm2,-lisp_frame.size(imm1))
	__(stw imm1,0(imm2))
	__(stw imm2,0(sp))
	__(stw loc_pc,lisp_frame.savelr(imm2))
	__(stw vsp,lisp_frame.savevsp(imm2))
	__(stw fn,lisp_frame.savefn(imm2))
	__(ref_global(imm3,current_cs))
	__(stw imm2,area.active(imm3))
	__(set_global(freeptr,save_freeptr))
	__(set_global(memo,save_memo))
	__(set_global(tsp,save_tsp))
	__(set_global(vsp,save_vsp))
	__(set_global(rzero,ffi_exception))
	__(mr save0,rnil)
	__(li rnil,0)
	__(lwz r3,c_frame.param0(sp))
	__(lwz r4,c_frame.param1(sp))
	__(lwz r5,c_frame.param2(sp))
	__(lwz r6,c_frame.param3(sp))
	__(lwz r7,c_frame.param4(sp))
	__(lwz r8,c_frame.param5(sp))
	__(lwz r9,c_frame.param6(sp))
	__(lwz r10,c_frame.param7(sp))
	__(unbox_fixnum(r0,arg_z))
	__(sc)
	__(b 1f)
	__(b 9f)
1:
	__(lwz imm2,c_frame.crsave(sp))
	__(cmpwi cr0,imm2,0)
	__(bne cr0,2f)
	/* 32-bit result */
	__(neg r3,r3)
	__(b 9f)
2:
	/* 64-bit result */
	__(neg r4,r3)
	__(li r3,-1)

9:
	__(mr imm2,save0)	/* recover NIL */
	__(lwz sp,c_frame.backlink(sp))
	__(li rzero,0)
	__(mr loc_g,imm2)
	__(mr arg_x,imm2)
	__(mr arg_y,imm2)
	__(mr arg_z,imm2)
	__(mr temp0,imm2)
	__(mr temp1,imm2)
	__(mr temp2,imm2)
	__(mr temp3,imm2)
	__(mr fn,imm2)
	__(vpop_saveregs)
	__(mr rnil,imm2)
	__(ref_global(freeptr,save_freeptr))
	__(ref_global(memo,save_memo))
	__(mr initptr,freeptr)
	__(ref_global(tsp,save_tsp))
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(mtlr loc_pc)
	__(lwz fn,lisp_frame.savefn(sp))
	__(discard_lisp_frame)
	__(blr)
	
/*
  A PowerOpen ff-call.  arg_z is either a fixnum (word-aligned entrypoint)
  or a macptr (whose address had better be word-aligned as well.)  A
  PowerOpen stack frame is on top of the stack; 4 additional words (to
  be used a a lisp frame) sit under the C frame.

  Since we probably can't deal with FP exceptions in foreign code, we
  disable them in the FPSCR, then check on return to see if any previously
  enabled FP exceptions occurred.

  As it turns out, we can share a lot of code with the eabi version of
  ff-call.  Some things that happen up to the point of call differ between
  the ABIs, but everything that happens after is the same.
*/
_spentry(ffcall)
	__(check_stack_alignment(imm0))
	__(mflr loc_pc)
	__(stw rnil,c_frame.savelr(sp))
	__(vpush_saveregs())		/* Now we can use save0-save7 to point to stacks */
	__(mr save0,rnil)	/* or address globals. */
	__(extract_typecode(imm0,arg_z))
	__(cmpwi imm0,subtag_macptr)
	__(lwz save1,0(sp))	/* bottom of reserved lisp frame */
	__(la save2,-lisp_frame.size(save1))	/* top of lisp frame*/
	__(stw save1,lisp_frame.backlink(save2))
	__(stw rnil,lisp_frame.savefn(save2))	/* for preemptive GC someday */
	__(stw save2,c_frame.backlink(sp))
	__(bne 1f)
	__(lwz imm0,macptr.address(arg_z))
	__(clrrwi arg_z,imm0,nlisptagbits)
1:
	__(stw loc_pc,lisp_frame.savelr(save2))
	__(stw vsp,lisp_frame.savevsp(save2))
	__(stw fn,lisp_frame.savefn(save2))
	__(ref_global(save3,current_cs))
	__(stw save2,area.active(save3))
	__(set_global(freeptr,save_freeptr))
	__(set_global(memo,save_memo))
	__(set_global(tsp,save_tsp))
	__(set_global(vsp,save_vsp))
	__(mtctr arg_z)
	__(set_global(rzero,ffi_exception))
	__(mffs f0)
	__(stfd f0,lisp_globals.fpscr_save_high(save0))	/* remember lisp's fpscr */
	__(mtfsf 0xff,fp_zero)	/* zero foreign fpscr */
	__(li rnil,0)
	__(lwz r3,c_frame.param0(sp))
	__(lwz r4,c_frame.param1(sp))
	__(lwz r5,c_frame.param2(sp))
	__(lwz r6,c_frame.param3(sp))
	__(lwz r7,c_frame.param4(sp))
	__(lwz r8,c_frame.param5(sp))
	__(lwz r9,c_frame.param6(sp))
	__(lwz r10,c_frame.param7(sp))
	/* Darwin is allegedly very picky about what register points
	   to the function on entry. */
	__(mr r12,arg_z)
	__(bctrl)
	__(b _local_label(FF_call_return_common))


/* On entry, R12 -> nilreg, R11 ->callback-index */
/* Restore lisp context, then funcall #'%pascal-functions% with */
/* two args: callback-index, args-ptr (a macptr pointing to the args on the stack) */
_spentry(callback)
	/* Save C argument registers */
	__(stw r3,c_frame.param0(sp))
	__(stw r4,c_frame.param1(sp))
	__(stw r5,c_frame.param2(sp))
	__(stw r6,c_frame.param3(sp))
	__(stw r7,c_frame.param4(sp))
	__(stw r8,c_frame.param5(sp))
	__(stw r9,c_frame.param6(sp))
	__(stw r10,c_frame.param7(sp))
	__(mflr imm3)
	__(stw imm3,c_frame.savelr(sp))
	__(mfcr imm0)
	__(stw imm0,c_frame.crsave(sp))
	/* This code depends on the fact that imm0, imm1, imm3 & tsp are */
	/* not r13-r31 (the non-volatile C registers). */
	__(mr imm1,r12)
	__(mr imm0,r11)
	__(la rnil,-1(imm1))	/* Marker for TSP overflow code */
	__(lwz tsp,lisp_globals.save_tsp(imm1))
	/* Save the non-volatile registers on the sp stack */
	/* This is a non-standard stack frame, but noone will ever see it, */
        /* so it doesn't matter. It will look like more of the stack frame pushed below. */
	__(stwu sp,-(stack_align(c_reg_save.size))(sp))
	__(stmw r13,c_reg_save.save_gprs(sp))
	__(check_stack_alignment(r0))
	__(mffs f0)
	__(stfd f0,c_reg_save.save_fp_zero(sp))
	__(lwz r31,c_reg_save.save_fp_zero+4(sp))	/* recover FPSCR image */
	__(stw r31,c_reg_save.save_fpscr(sp))
	__(lwi(r30,0x43300000))
	__(lwi(r31,0x80000000))
	__(stw r30,c_reg_save.save_fp_zero(sp))
	__(stw r31,c_reg_save.save_fp_zero+4(sp))
	__(stfd fp_s32conv,c_reg_save.save_fps32conv(sp))
	__(lfd fp_s32conv,c_reg_save.save_fp_zero(sp))
	__(stfd fp_zero,c_reg_save.save_fp_zero(sp))
	__(lfs fp_zero,lisp_globals.short_float_zero(imm1))	/* ensure that fp_zero contains 0.0 */
	__(lfd f0,lisp_globals.fpscr_save_high(imm1))
	__(mtfsf 0xff,f0)

/* Restore rest of Lisp context. */
/* Could spread out the memory references here to gain a little speed */
	__(lwz freeptr,lisp_globals.save_freeptr(imm1))
	__(mr initptr,freeptr)
	__(lwz memo,lisp_globals.save_memo(imm1))
	__(lwz vsp,lisp_globals.save_vsp(imm1))
	__(li rzero,0)
	__(mtxer rzero) /* eventually, lisp may depend on the overflow 
			bit being clear */

	__(mr loc_g,rzero)
	__(mr loc_pc,rzero)
	__(mr fn,rzero)                     /* subprim, not a lisp function */
	__(mr temp3,imm1)
	__(mr temp2,imm1)
	__(mr temp1,imm1)
	__(mr temp0,imm1)
	__(mr arg_x,imm1)
	/* restore saved registers. */
	/* They are in exception_saved_registers if it is non-zero. */
	/* Otherwise, they are on top of the VSP stack (but 1) */
	__(lwz imm2,lisp_globals.exception_saved_registers(imm1))
	__(cmpwi cr0,imm2,0)
	__(beq+ cr0,1f)
	__(stw rzero,lisp_globals.exception_saved_registers(imm1))
	__(b 2f)
1:
	__(la imm2,4(vsp))
2:
	__(restore_saveregs(imm2))
	/* load the arg registers & nargs and callback to the lisp */
	__(box_fixnum(arg_y,imm0))	/* callback-index */
	__(la arg_z,stack_align(c_reg_save.size)+c_frame.param0(sp))	/* parameters (tagged as a fixnum) */
	__(set_nargs(2))
	__(mr rnil,imm1)	/* lisp context restored */
	__(ref_global(imm2,current_cs))
	__(lwz imm4,area.active(imm2))
	__(stwu imm4,-lisp_frame.size(sp))
	__(stw imm3,lisp_frame.savelr(sp))
	__(stw vsp,lisp_frame.savevsp(sp))	/* for stack overflow code */
	__(la fname,nrs.callbacks(rnil))	/* %pascal-functions% */
	__(bl jmpsym)
	__(lwz imm2,lisp_frame.backlink(sp))
	__(clrrwi imm2,imm2,nlisptagbits)
	__(ref_global(imm3,current_cs))
	__(stw imm2,area.active(imm3))
	__(discard_lisp_frame())
	/* save_freeptr & save_memo may be different due to consing */
	/* save_vsp will be restored from ff_call's stack frame, but */
	/* I included it here for consistency. */
	/* save_tsp is set below after we exit Lisp context. */
	__(set_global(freeptr,save_freeptr))
	__(set_global(memo,save_memo))
	__(set_global(vsp,save_vsp))
	/* Exit lisp context */
	/* This is not necessary yet, but will be once we can be interrupted */
	__(mr imm1,rnil)
	__(ref_global(rnil,saveTOC))
	/* Restore the non-volatile registers & fpscr */
	__(lfd fp_zero,c_reg_save.save_fp_zero(sp))
	__(lwz r31,c_reg_save.save_fpscr(sp))
	__(stw r31,c_reg_save.save_fp_zero+4(sp))
	__(lfd f0,c_reg_save.save_fp_zero(sp))
	__(mtfsf 0xff,f0)
	__(lmw r13,c_reg_save.save_gprs(sp))
	__(lfd fp_s32conv,c_reg_save.save_fps32conv(sp))
	__(lwz sp,0(sp))
	__(stw tsp,lisp_globals.save_tsp(imm1))

	__(lwz r3,c_frame.param0(sp))
	__(lwz r4,c_frame.savelr(sp))
	__(mtlr r4)
	__(lwz r4,c_frame.crsave(sp))
	__(mtcr r4)
	__(blr)



_spentry(eabi_ff_call)
/*
	We're entered with an eabi_c_frame on the C stack.  There's a
	lisp_frame reserved underneath it; we'll link it in in a minute.
	Load the outgoing GPR arguments from eabi_c_frame.param[0-7],
	then shrink the eabi_c_frame.
*/
	__(mflr loc_pc)
	__(stw rnil,eabi_c_frame.savelr(sp))
	__(vpush_saveregs())		/* Now we can use save0-save7 to point to stacks */
	__(mr save0,rnil)	/* or address globals. */
	__(extract_typecode(imm0,arg_z))
	__(cmpwi imm0,subtag_macptr)
	__(lwz save1,0(sp))	/* bottom of reserved lisp frame */
	__(la save2,-lisp_frame.size(save1))	/* top of lisp frame*/
	__(stw save1,lisp_frame.backlink(save2))
	__(stw rnil,lisp_frame.savefn(save2))	/* for preemptive GC someday */
	__(stw save2,0(sp))
	__(bne 1f)
	__(lwz imm0,macptr.address(arg_z))
	__(clrrwi arg_z,imm0,nlisptagbits)
1:
	__(stw loc_pc,lisp_frame.savelr(save2))
	__(stw vsp,lisp_frame.savevsp(save2))
	__(stw fn,lisp_frame.savefn(save2))
	__(ref_global(save3,current_cs))
	__(stw save2,area.active(save3))
	__(set_global(freeptr,save_freeptr))
	__(set_global(memo,save_memo))
	__(set_global(tsp,save_tsp))
	__(set_global(vsp,save_vsp))
	__(mtctr arg_z)
	__(set_global(rzero,ffi_exception))
	__(mffs f0)
	__(stfd f0,lisp_globals.fpscr_save_high(save0))	/* remember lisp's fpscr */
	__(mtfsf 0xff,fp_zero)	/* zero foreign fpscr */
	__(ref_global(r2,saveTOC))
	__(lwz r13,lisp_globals.saveR13(save0))
	__(lwz r3,eabi_c_frame.param0(sp))
	__(lwz r4,eabi_c_frame.param1(sp))
	__(lwz r5,eabi_c_frame.param2(sp))
	__(lwz r6,eabi_c_frame.param3(sp))
	__(lwz r7,eabi_c_frame.param4(sp))
	__(lwz r8,eabi_c_frame.param5(sp))
	__(lwz r9,eabi_c_frame.param6(sp))
	__(lwz r10,eabi_c_frame.param7(sp))
	__(la save1,eabi_c_frame.minsiz-eabi_c_frame.param0(sp))
	__(stw rzero,eabi_c_frame.savelr(save1))
	__(stw save2,eabi_c_frame.backlink(save1))
	__(mr sp,save1)
	/* If we're calling a varargs C function, it'll want to
	know whether or not we've passed any args in FP regs.
	Better to say that we did (and force callee to save FP
	arg regs on entry) than to say that we didn't and get
	garbage results */
	__(crset 6)
	__(bctrl)
_local_label(FF_call_return_common):
	/* C should have preserved save0 (= lisp_nil) for us. */
	__(lwz sp,0(sp))
	__(mr imm2,save0)
	__(lwz vsp,lisp_frame.savevsp(sp))
	__(vpop_saveregs())
	__(li rzero,0)
	__(mr loc_g,rzero)
	__(mr loc_g,rzero)
	__(mr arg_x,imm2)
	__(mr arg_y,imm2)
	__(mr arg_z,imm2)
	__(mr temp0,imm2)
	__(mr temp1,imm2)
	__(mr temp2,imm2)
	__(mr temp3,imm2)
	__(mr fn,imm2)
	__(mr rnil,imm2)
	__(ref_global(freeptr,save_freeptr))
	__(ref_global(memo,save_memo))
	__(mr initptr,freeptr)
	__(ref_global(tsp,save_tsp))
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(mtlr loc_pc)
	__(lwz fn,lisp_frame.savefn(sp))
	__(mffs f0)
	__(stfd f0,8(sp))
	__(lwz imm3,12(sp))	/* imm3 = FPSCR after call */
	/* Darwin's math library doesn't set FX when it sets other xX
	   bits in the FPSCR.  If any of those bits are set in imm3
	   now, set the FX bit image */
	__(andis. imm2,imm3,0x3ff8)
	__(li imm2,0)	/* assume no FP exception */	
	__(discard_lisp_frame())
	__(beq cr0,Lstore_ffi_exception)
	__(ref_global(imm4,fpscr_save))	/*  lisp's FPSCR */
	__(mtcrf 0xfc,imm3)	/* CR = FPSCR[0-23] */
	__(mtcrf 0x03,imm4)	/* CR now = FFI_FPSCR[0-23]|LISP_FPSCR[24-31] */
	__(crand fpscr_FEX,fpscr_VX,fpscr_VE)
	__(bt fpscr_FEX,Lset_FEX)
	__(crand fpscr_FEX,fpscr_OX,fpscr_OE)
	__(bt fpscr_FEX,Lset_FEX)
	__(crand fpscr_FEX,fpscr_UX,fpscr_UE)
	__(bt fpscr_FEX,Lset_FEX)
	__(crand fpscr_FEX,fpscr_ZX,fpscr_ZE)
	__(bt fpscr_FEX,Lset_FEX)
	__(crand fpscr_FEX,fpscr_XX,fpscr_XE)
	__(bt fpscr_FEX,Lset_FEX)
	__(bf fpscr_VE,Lstore_ffi_exception)
	__(andis. imm4,imm3,0x01f8)  /* any VX bits ? */
	__(beq Lstore_ffi_exception)
Lset_FEX:
	__(oris imm2,imm3,0xc000) /* set FEX, FX */
	__(rlwinm imm2,imm2,32-8+fixnum_shift,(32-24)-fixnum_shift,31-fixnum_shift)
Lstore_ffi_exception:
	__(set_global(imm2,ffi_exception))
	__(lfd f0,lisp_globals.fpscr_save_high(rnil))
	__(mtfsf 0xff,f0)
	__(blr)

/*
	Do a linux system call:	 the system call index is (boxed)
	in arg_z, and other arguments are in an eabi_c_frame on
	the C stack.  As is the case with an eabi_ff_call, there's
	a lisp frame reserved underneath the eabi_c_frame.

	This is a little simpler than eabi_ff_call, because we
	can assume that there are no synchronous callbacks to
	lisp (that might cause a GC.)  It's also simpler for the
	caller, since we return error status atomically.

	A system call can clobber any or all of r9-r12, so we need
	to save and restore freeptr, memo, and tsp.
	*/
_spentry(syscall)
/*
	We're entered with an eabi_c_frame on the C stack.  There's a
	lisp_frame reserved underneath it; we'll link it in in a minute.
	Load the outgoing GPR arguments from eabi_c_frame.param[0-7],
	then shrink the eabi_c_frame.
*/
	__(mflr loc_pc)
	__(stw rnil,eabi_c_frame.savelr(sp))
	__(mr arg_x,rnil)
	__(mr temp0,rnil)
	__(lwz temp1,0(sp))	/* bottom of reserved lisp frame */
	__(la temp2,-lisp_frame.size(temp1))	/* top of lisp frame */
	__(stw temp1,lisp_frame.backlink(temp2))
	__(stw rnil,lisp_frame.savefn(temp2))	/* for preemptive GC someday */
	__(stw temp2,0(sp))
	__(stw loc_pc,lisp_frame.savelr(temp2))
	__(stw vsp,lisp_frame.savevsp(temp2))
	__(stw fn,lisp_frame.savefn(temp2))
	__(ref_global(temp3,current_cs))
	__(stw temp2,area.active(temp3))
	__(set_global(freeptr,save_freeptr))
	__(set_global(memo,save_memo))
	__(set_global(tsp,save_tsp))
	__(set_global(vsp,save_vsp))
	__(set_global(rzero,ffi_exception))
	__(ref_global(r2,saveTOC))
	__(lwz r13,lisp_globals.saveR13(temp0))
	__(lwz r3,eabi_c_frame.param0(sp))
	__(lwz r4,eabi_c_frame.param1(sp))
	__(lwz r5,eabi_c_frame.param2(sp))
	__(lwz r6,eabi_c_frame.param3(sp))
	__(lwz r7,eabi_c_frame.param4(sp))
	__(lwz r8,eabi_c_frame.param5(sp))
	__(lwz r9,eabi_c_frame.param6(sp))
	__(lwz r10,eabi_c_frame.param7(sp))
	__(la temp1,eabi_c_frame.minsiz-eabi_c_frame.param0(sp))
	__(stw rzero,eabi_c_frame.savelr(temp1))
	__(stw temp2,eabi_c_frame.backlink(temp1))
	__(mr sp,temp1)
	__(unbox_fixnum(r0,arg_z))
	__(sc)
	__(nop)
	/* C should have preserved temp0 (= lisp_nil) for us. */
	__(lwz sp,0(sp))
	__(mr imm2,temp0)
	__(lwz vsp,lisp_frame.savevsp(sp))
	__(li rzero,0)
	__(mr loc_g,rzero)
	__(mr loc_pc,rzero)
	__(mr arg_x,imm2)
	__(mr arg_y,imm2)
	__(mr arg_z,imm2)
	__(mr temp0,imm2)
	__(mr temp1,imm2)
	__(mr temp2,imm2)
	__(mr temp3,imm2)
	__(mr fn,imm2)
	__(mr rnil,imm2)
	__(ref_global(freeptr,save_freeptr))
	__(ref_global(memo,save_memo))
	__(mr initptr,freeptr)
	__(ref_global(tsp,save_tsp))
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(mtlr loc_pc)
	__(lwz fn,lisp_frame.savefn(sp))
	__(discard_lisp_frame())
	__(bnslr)
	__(neg r3,r3)
	__(mcrxr 0)	/* clear cr0_SO */
	__(blr)


/* 
	This gets called with R11 holding the unboxed callback index
	and R12 pointing at lisp_nil.

*/

_spentry(eabi_callback)
	/* First, we extend the C frame so that it has room for
	incoming arg regs. */
	__(lwz r0,eabi_c_frame.backlink(sp))
	__(stwu r0,eabi_c_frame.param0-varargs_eabi_c_frame.incoming_stack_args(sp))
	__(mflr r0)
	__(stw r0,varargs_eabi_c_frame.savelr(sp))
	__(stw r3,varargs_eabi_c_frame.gp_save+(0*4)(sp))
	__(stw r4,varargs_eabi_c_frame.gp_save+(1*4)(sp))
	__(stw r5,varargs_eabi_c_frame.gp_save+(2*4)(sp))
	__(stw r6,varargs_eabi_c_frame.gp_save+(3*4)(sp))
	__(stw r7,varargs_eabi_c_frame.gp_save+(4*4)(sp))
	__(stw r8,varargs_eabi_c_frame.gp_save+(5*4)(sp))
	__(stw r9,varargs_eabi_c_frame.gp_save+(6*4)(sp))
	__(stw r10,varargs_eabi_c_frame.gp_save+(7*4)(sp))
	/* Could check the appropriate CR bit and skip saving FP regs here */
	__(stfd f1,varargs_eabi_c_frame.fp_save+(0*8)(sp))
	__(stfd f2,varargs_eabi_c_frame.fp_save+(1*8)(sp))
	__(stfd f3,varargs_eabi_c_frame.fp_save+(2*8)(sp))
	__(stfd f4,varargs_eabi_c_frame.fp_save+(3*8)(sp))
	__(stfd f5,varargs_eabi_c_frame.fp_save+(4*8)(sp))
	__(stfd f6,varargs_eabi_c_frame.fp_save+(5*8)(sp))
	__(stfd f7,varargs_eabi_c_frame.fp_save+(6*8)(sp))
	__(stfd f8,varargs_eabi_c_frame.fp_save+(7*8)(sp))
	__(la r0,varargs_eabi_c_frame.incoming_stack_args(sp))
	__(stw r0,varargs_eabi_c_frame.overflow_arg_area(sp))
	__(la r0,varargs_eabi_c_frame.regsave(sp))
	__(stw r0,varargs_eabi_c_frame.reg_save_area(sp))
	__(li r0,0)
	__(stw r0,varargs_eabi_c_frame.flags(sp))
	/* This code depends on the fact that imm0, imm1, imm3 & tsp are */
	/* not r13-r31 (the non-volatile C registers). */
	__(mr imm1,r12)
	__(mr imm0,r11)
	__(la rnil,-1(imm1))	/* Marker for TSP overflow code */
	__(lwz tsp,lisp_globals.save_tsp(imm1))
	/* Save the non-volatile registers on the sp stack */
	/* This is a non-standard stack frame, but noone will ever see it, */
        /* so it doesn't matter. It will look like more of the stack frame pushed below. */
	__(stwu sp,-(c_reg_save.size)(sp))
	__(stmw r13,c_reg_save.save_gprs(sp))
	__(mffs f0)
	__(stfd f0,c_reg_save.save_fp_zero(sp))
	__(lwz r31,c_reg_save.save_fp_zero+4(sp))	/* recover FPSCR image */
	__(stw r31,c_reg_save.save_fpscr(sp))
	__(lwi(r30,0x43300000))
	__(lwi(r31,0x80000000))
	__(stw r30,c_reg_save.save_fp_zero(sp))
	__(stw r31,c_reg_save.save_fp_zero+4(sp))
	__(stfd fp_s32conv,c_reg_save.save_fps32conv(sp))
	__(lfd fp_s32conv,c_reg_save.save_fp_zero(sp))
	__(stfd fp_zero,c_reg_save.save_fp_zero(sp))
	__(lfs fp_zero,lisp_globals.short_float_zero(imm1))	/* ensure that fp_zero contains 0.0 */
	__(lfd f0,lisp_globals.fpscr_save_high(imm1))
	__(mtfsf 0xff,f0)

/* Restore rest of Lisp context. */
/* Could spread out the memory references here to gain a little speed */
	__(lwz freeptr,lisp_globals.save_freeptr(imm1))
	__(mr initptr,freeptr)
	__(lwz memo,lisp_globals.save_memo(imm1))
	__(lwz vsp,lisp_globals.save_vsp(imm1))
	__(li rzero,0)
	__(mtxer rzero) /* eventually, lisp may depend on the overflow 
			bit being clear */

	__(mr loc_g,rzero)
	__(mr loc_pc,rzero)
	__(mr fn,rzero)                     /* subprim, not a lisp function */
	__(mr temp3,imm1)
	__(mr temp2,imm1)
	__(mr temp1,imm1)
	__(mr temp0,imm1)
	__(mr arg_x,imm1)
	/* restore saved registers. */
	/* They are in exception_saved_registers if it is non-zero. */
	/* Otherwise, they are on top of the VSP stack (but 1) */
	__(lwz imm2,lisp_globals.exception_saved_registers(imm1))
	__(cmpwi cr0,imm2,0)
	__(beq+ cr0,1f)
	__(stw rzero,lisp_globals.exception_saved_registers(imm1))
	__(b 2f)
1:
	__(la imm2,4(vsp))
2:
	__(restore_saveregs(imm2))
	/* load the arg registers & nargs and callback to the lisp */
	__(box_fixnum(arg_y,imm0))	/* callback-index */
	__(la arg_z,c_reg_save.size+varargs_eabi_c_frame.gp_save(sp))	/* parameters (tagged as a fixnum) */
	__(set_nargs(2))
	__(mr rnil,imm1)	/* lisp context restored */
	__(ref_global(imm2,current_cs))
	__(lwz imm4,area.active(imm2))
	__(stwu imm4,-lisp_frame.size(sp))
	__(stw imm3,lisp_frame.savelr(sp))
	__(stw vsp,lisp_frame.savevsp(sp))	/* for stack overflow code */
	__(la fname,nrs.callbacks(rnil))	/* %pascal-functions% */
	__(bl jmpsym)
	__(lwz imm2,lisp_frame.backlink(sp))
	__(clrrwi imm2,imm2,nlisptagbits)
	__(ref_global(imm3,current_cs))
	__(stw imm2,area.active(imm3))
	__(discard_lisp_frame())
	/* save_freeptr & save_memo may be different due to consing */
	/* save_vsp will be restored from ff_call's stack frame, but */
	/* I included it here for consistency. */
	/* save_tsp is set below after we exit Lisp context. */
	__(set_global(freeptr,save_freeptr))
	__(set_global(memo,save_memo))
	__(set_global(vsp,save_vsp))
	/* Exit lisp context */
	/* This is not necessary yet, but will be once we can be interrupted */
	__(mr imm1,rnil)
	__(ref_global(rnil,saveTOC))
	/* Restore the non-volatile registers & fpscr */
	__(lfd fp_zero,c_reg_save.save_fp_zero(sp))
	__(lwz r31,c_reg_save.save_fpscr(sp))
	__(stw r31,c_reg_save.save_fp_zero+4(sp))
	__(lfd f0,c_reg_save.save_fp_zero(sp))
	__(mtfsf 0xff,f0)
	__(lmw r13,c_reg_save.save_gprs(sp))
	__(lfd fp_s32conv,c_reg_save.save_fps32conv(sp))
	__(lwz sp,0(sp))
	__(stw tsp,lisp_globals.save_tsp(imm1))

	__(lwz r3,varargs_eabi_c_frame.gp_save+(0*4)(sp))
	__(lwz r4,varargs_eabi_c_frame.gp_save+(1*4)(sp))
	__(lfd f1,varargs_eabi_c_frame.fp_save+(8*8)(sp))
	__(lwz r5,varargs_eabi_c_frame.savelr(sp))
	__(stw r5,varargs_eabi_c_frame.old_savelr(sp))
	__(mtlr r5)
	__(lwz r5,varargs_eabi_c_frame.backlink(sp))
	__(stw r5,varargs_eabi_c_frame.old_backlink(sp))
	__(la sp,varargs_eabi_c_frame.old_backlink(sp))
	__(blr)
	_endfile
