/*
 * Copyright (c) 2000, Amnon BARAK (amnon@cs.huji.ac.il). All rights reserved.
 *
 *
 * Permission to use, copy and distribute this software is hereby granted 
 * under the terms of version 2 or any later version of the GNU General Public
 * License, as published by the Free Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED IN ITS "AS IS" CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Ariel Rosenblatt, Amnon Shiloh
 * Code derived from previous work by Amnon Shiloh and Oren Laadan.
 */





/*  Adapted to OpenMosix from Mosix and bugfixing by David Santo Orcero */
/*  irbis@orcero.org  http://www.orcero.org/irbis                       */
/* Mosix is (c) of prof. Amnon Barak http://www.mosix.org               */
/* Original code is (c) of prof. Amnon Barak http://www.mosix.org       */
/* OpenMosix is (c) of Moshe Bar http://www.openmosix.com               */
/* Each respective trademark is of its own owner                        */
/* All rights reserved.                                                 */
/* This software is distributed under GPL 2                             */

/* THIS SOFTWARE IS PROVIDED "AS IS". NO WARRANTY IS ASSUMED.               */
/* NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING            */
/* FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED. IT CAN BURN              */
/* YOUR HARD DISK, ERASE ALL YOUR DATA AND BROKE DOWN YOUR                  */
/* MICROWAVE OVEN. YOU ARE ADVISED.                                         */


#ifndef __libmosix__
#define __libmosix__

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include <sys/socket.h>
#include <linux/config.h>
#include <linux/hpcctl.h>
#include <linux/hpc.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/utsname.h>
struct decay_params
{
	int interval; 
	int slow; 
	int fast;
};

struct process_info {
	pid_t pid;
	int where;
};

enum msx_cmd { 
	D_STAY,      /* Disable automatic migration from here */
	D_NOSTAY,    /* Allow automatic migrations from here */
	D_LSTAY,     /* Disable automatic mig. of local processes */
	D_NOLSTAY,   /* Allow automatic mig.  of local processes */
	D_BLOCK,     /* Block automatic migration to here */
	D_NOBLOCK,   /* Enable automatic migration to here */
	D_EXPEL,     /* Expel all processes to remote processors */
	D_BRING,     /* Bring back all processes */
	D_GETLOAD,   /* Get current load */
	D_QUIET,     /* Stop internal load-balancing activity */
	D_NOQUIET,   /* Resume internal load-balancing activity */
	D_TUNE,      /* Enter tuning mode */
	D_NOTUNE,    /* Exit tuning mode */
	D_NOMFS,     /* Disallow MFS access to this node */
	D_MFS,       /* Reallow MFS access to this node */
	D_SETSSPEED,/* Set the standard speed, affecting D_GETLOAD */
	D_GETSSPEED, /* Get the standard speed (default=1000) */
	D_GETSPEED,  /* Get machine's speed */
	D_SETSPEED,  /* Set machine's speed */
	D_MOSIX_TO_IP,    /* Convert MOSIX to IP address */
	D_IP_TO_MOSIX,    /* Convert IP to MOSIX address */
	D_GETNTUNE,       /* get number of kernel tuning parameters */
	D_GETTUNE,        /* get kernel tuning parameters */
	D_GETSTAT,        /* get MOSIX status */
	D_GETMEM,         /* get current memory (free and total) */
	D_GETDECAY,       /* get decay parameters */
	D_SETDECAY,       /* set decay parameters */
	D_GETRMEM,        /* get OS's idea of memory (free and total) */
	D_GETUTIL,        /* get CPU utilizability % */
	D_SETWHERETO,     /* send a process somewhere */
	D_GETPE,	 /* get node number */
	D_GETCPUS,	/* get number of CPUs */
        D_GETLOADLOCAL,
	D_GETLOADREMOTE,
	D_GETCPULOCAL,
	D_GETCPUREMOTE,
	D_SETLOADLIMIT,
	D_SETLLIMITMODE,
	D_SETCPULIMIT,
	D_SETCPULIMITMODE,
	D_GETLOADLIMIT,
	D_GETLLIMITMODE,
	D_GETCPULIMIT,
	D_GETCPULIMITMODE
};

#define D_GOBACKHOME    0       /* just go back home */
#define D_BALANCE       (-1)    /* perform load balancing */
#define D_LEAVE         (-2)    /* leave the process where it is */

#define D_UNLOCK        0
#define D_LOCK          1
#define D_NOCHANGE      2
#define D_MIGNOLOCK     3
	
typedef enum msx_cmd msx_cmd_t;
int64_t msxctl(msx_cmd_t cmd, int arg, void *resp, int len);
#define msxctl1(x) (msxctl((x), 0, NULL, 0))
#define msxctl2(x,y) (msxctl((x), (y), NULL, 0))
#define msxctl3(x,y,z) (msxctl((x), (y), (z), sizeof(*(z))))

int msx_readval(const char *path, int64_t *val);
int msx_readval2(const char *path, int *val1, int *val2);
int msx_write(const char *path, int val);
int msx_write2(const char *path, int val1, int val2);
int64_t msx_readnode(int node, const char *item);
int msx_readproc(int pid, const char *item);
int msx_read(const char *path);
int msx_writeproc(int pid, const char *item, int val);
int msx_readdata(const char *fn, void *into, int max, int size);
int msx_writedata(char *fn, char *from, int size);
int msx_replace(const char *fn, int val);
int msx_count_ints(const char *fn);
int msx_fill_ints(const char *fn, int *, int);

#endif
