#!/bin/bash


ARGS=$@

function usage() {
 echo "Usage: joingroup [process-ID] ...... [process-group]"
 echo
 exit -1
}

if (($# < 2)); then
 usage
fi

for CHECK in $ARGS; do

 echo $CHECK | grep [0-9] 1>/dev/null 2>&1
 if [ $? != 0 ]; then
  echo "ERROR: wrong process ID"
  usage
 fi

done;

MIGGROUP=`echo $ARGS | sed -e "s/.* //"`
PROCESSES=`echo $ARGS | sed -e "s/$MIGGROUP$//"`

echo "miggroup = $MIGGROUP"
echo "processes = $PROCESSES"

for PROC in $PROCESSES; do
 if [ -f /proc/$PROC/miggroup ]; then
  echo "process $PROC joins the miggroup $MIGGROUP now"
  echo $MIGGROUP > /proc/$PROC/miggroup
 fi
done











