#!/bin/bash


MIGGROUP=$1
NODEID=$2
PROCESSES=`ls /proc | grep [0-9]`

function usage() {
 echo "Usage: miggroup [process-group] [node-ID]"
 echo
 exit -1
}

if [ $# != 2 ]; then
 usage
fi

echo $MIGGROUP | grep [0-9] 1>/dev/null 2>&1
if [ $? != 0 ]; then
 echo "ERROR: wrong miggroup"
 usage
fi

echo $NODEID | grep [0-9] 1>/dev/null 2>&1
if [ $? != 0 ]; then
 echo "ERROR: wrong node ID"
 usage
fi


for PROC in $PROCESSES; do
 if [ -f /proc/$PROC/miggroup ]; then
  PROCGROUP=`cat /proc/$PROC/miggroup`
  if [ "$MIGGROUP" == "$PROCGROUP" ]; then
   echo "migrate $PROC to $NODEID"
   migrate $PROC $NODEID
  fi
 fi
done









