#!/bin/bash


MIGGROUP=$1
PROCESSES=`ls /proc | grep [0-9]`

function usage() {
 echo "Usage: resetgroup [process-group]"
 echo
 exit -1
}

if [ $# != 1 ]; then
 usage
fi

echo $MIGGROUP | grep [0-9] 1>/dev/null 2>&1
if [ $? != 0 ]; then
 echo "ERROR: wrong miggroup"
 usage
fi

for PROC in $PROCESSES; do
 if [ -f /proc/$PROC/miggroup ]; then
  PROCGROUP=`cat /proc/$PROC/miggroup`
  if [ "$MIGGROUP" == "$PROCGROUP" ]; then
   echo 0 > /proc/$PROC/miggroup
   echo "resetet $PROC"
  fi
 fi
done



