Summary: The userland tools of the openMosix-system
Name: openmosix-tools
Version: 0.3.4
Release: 1
URL: http://openmosix.sourceforge.net/
License: GPL
Group: System Environment/Kernel
BuildRoot: %{_tmppath}/%{name}
Source0: %{name}-%{version}.tar.bz2


%description
openMosix is a Linux kernel extension for single-system image
clustering. This package contains the necessary user-land tools for an
openMosix cluster. It also contains openMosix versions of ps and top
(mps and mtop) that has an additional column which shows on what node
the processes are running.

%prep

%setup

%build
./configure --enable-rpmbuild --bindir=/bin --sbindir=/sbin --includedir=/usr/include --mandir=/usr/share/man --libdir=/lib --with-kerneldir=/usr/src/linux-openmosix
make all

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT

%pre

%post
/sbin/ldconfig
chkconfig --add openmosix
if [ "$1" = "1" ] ; then  # first install
   # Add mosrun-commands in /etc/inittab
   perl -pi -e 's!:(/etc/rc.d/rc)!:/bin/mosrun -h $1!' /etc/inittab
   perl -pi -e 's!:(/sbin/update)!:/bin/mosrun -h $1!' /etc/inittab
   perl -pi -e 's!:(/sbin/shutdown)!:/bin/mosrun -h $1!' /etc/inittab
   # Add nolock-command in /etc/init.d/sshd
   perl -i -e 'local $/; $_ = <>; s!(start\(\)\s+{\n)!$1\ttest -f /proc/\$\$/lock && echo 0 \> /proc/\$\$/lock\n\n!; print' /etc/init.d/sshd
   # Add mfs to slocate.cron
   perl -pi -e 's!(/usr/bin/updatedb -f \"nfs)!$1,mfs!' /etc/cron.daily/slocate.cron
   # Tell user to edit mosix.map
   echo -e "\nEdit /etc/openmosix.map if you don't want to use the autodiscovery daemon.\n"
fi


%preun
if [ "$1" = "0" ] ; then # last uninstall
   # Remove links to startup-script
   chkconfig --del openmosix
   # Remove mosrun-commands in /etc/inittab
   perl -pi -e 's!:/bin/mosrun -h !:!' /etc/inittab
   # Remove nolock-command in /etc/rc.d/init.d/sshd
   perl -i -e 'local $/; $_ = <>; s!\ttest -f /proc/\$\$/lock && echo 0 \> /proc/\$\$/lock\n\n!!g; print' /etc/init.d/sshd
   # Remove mfs from slocate.cron
   perl -pi -e 's/mfs,//' /etc/cron.daily/slocate.cron
fi


%postun
/sbin/ldconfig


%files
%defattr(-,root,root)
%dir /etc/openmosix
%config /etc/openmosix.map
%config /etc/openmosix/openmosix.config
%config /etc/init.d/openmosix
%doc /usr/share/man/man1/*
/bin/*
/lib/*
/sbin/*
/usr/include/*


%changelog
* Sun Jun 22 2003 Mirko Caserta <mirko@mcaserta.com>
- Updated to version 0.3.4 (Mirko Caserta)
- added moslimit tool (Cristiano De Michele)
- minor fixes to the moslimit man page (Mirko Caserta)
- mosrun is now installed in /bin since it is used at boot time by
  /etc/inittab (Cristiano De Michele)

* Tue Jun 12 2003 Mirko Caserta <mirko@mcaserta.com>
- Updated to version 0.3.3 (Mirko Caserta)
- minor bug fixes in autoconf stuff (Cristiano De Michele)
- fixed README file (Mirko Caserta)
- autoconfiscated the whole thing (Cristiano De Michele)
- special thanks to Jens Finkhoer for the hints about autoconf
- fixed wrong path to openmosix.config in init-script found 
  by Mirko Caserta (Matt Rechenburg)
- Makefiles cleanup, now supports DESTDIR and easy rpm-creation (Martin Hy)
- Added the mps package (mps and mtop commands) (Martin Hy)
- New startup-script which starts omdiscd in case of no or invalid
  static map-file (Martin Hy)

* Fri Aug  9 2002 Martin Hy <martin.hoy@pvv.ntnu.no>
- Updated to version 0.2.4
- Disabled ALPHA-mode for autodiscovery

* Fri Jul  5 2002 Martin Hy <martin.hoy@pvv.ntnu.no>
- Updated to version 0.2.2

* Tue Apr 23 2002 Martin Hy <martin.hoy@pvv.ntnu.no>
- Updated to version 0.2.0

* Tue Mar 19 2002 Martin Hy <martin.hoy@pvv.ntnu.no>
- Moved mosrun to /bin and setpe to /sbin
- Changed init-file to touch /var/lock/subsys/openmosix, not mosix

* Mon Mar 18 2002 Martin Hy <martin.hoy@pvv.ntnu.no>
- Added scripts to run when installing/removing. The scripts changes these
  files: /etc/inittab, /etc/rc.d/init.d/sshd and /etc/cron.daily/slocate.cron
- Added an empty mosix.map to the package

* Thu Mar 14 2002 Martin Hy <martin.hoy@pvv.ntnu.no>
- Initial build.


