#ifndef _BARMANAGERH
#define _BARMANAGERH

#include <stdio.h>
#include <fcntl.h>
#include <iostream>
#include <list>
#include <math.h>
#include <time.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <GL/glx.h>     // Header file fot the glx libraries.

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <signal.h>
#include <unistd.h>

#include "mosstat.h"

#include "objects.h"
#include "colors.h"
#define PI 3.14159

#include "rand.h"
#include "spin.h"


#define LOAD 1 //values for display mode
#define MEM 2
#define UTIL 3

using namespace std;

extern int DISPLAYMODE;
// static int DISPLAYMODE = LOAD;


// the number for the selected node
extern int selectednode;

//
//
struct bar_record
{
    int mosix_number;
    CBar *bar;
};


// to store the selected node values
struct nodevalues {
  int number;
  int load;
  int speed;
  int availmem;
  int usemem;
  int cpus;
  int stat;
  int mosversion;
};


class BarManager
{
private:
	//TwoDMosixMap map;
//        map MosixMap;
	list <CObject *> ObjectList;
	list<CObject *> ::iterator ObjectIter;
	
	list <bar_record> BarList;
	list <bar_record> ::iterator BarIter;

	int Spin;


	int static_world_list_base;
	int static_world_list_cnt;
	
	int xsquares, ysquares, zsquares;
	int gridsize;
	int transparent;
	int NumBars;
	int BytesRead;
	int sd;
	struct node_info read_data;
	int size;
	int NumNodes;
	int ConnectToServer(char *addr, char *prt);
	int GetNumNodes(); // this is a hack to read a packet once 
			   // before we start the main loop to know
			   // how many nodes to expect.
			   
	void printnode(struct node_info *info);

	void SetupBarBase(int node, struct CObject_struct &base);
	void NodeToBar(struct node_info &node);
	int ReadNumNodes();
	void print_CObject_struct(CObject_struct &s);


public:
	BarManager();
	
	void GetMosixData(int a);
	
	int UpdateOrCreateBar(int node, int realnodeid, struct CBar_struct b);
	void PrintObjectCount() { printf("Object Count : %d\n", ObjectList.size()); }
	int GenerateGrid();
	int DestroyWorld();
	int AddObject(CObject *obj);
	int ReadNewData();
	int UpdateNode(int node, struct CBar_struct);
	int AddBar(bar_record b);
	int Show();
	int ShowObjects(); 
	int ShowBars();
	int SetTransparent(int i) {transparent = i; return 1;}
	int GetTransparent() { return transparent; } 
	int SetXsquares(int x) { xsquares = x; }
	int GetXsquares () { return xsquares; }
	int SetYsquares(int y) { ysquares = y; }
	int GetYsquares() { return ysquares; }
	int SetZsquares(int z) { zsquares = z; }
	int GetZsquares() { return zsquares; }
	int SetGridSize(int x) {gridsize = x;}
	int GetGridSize() { return gridsize;}
	int SetSpin(int s) {if (s) Spin = 1; else Spin = 0; }
	int GetSpin() { return Spin; }
	int ToggleSpin() { Spin++; if (Spin > MAXSPIN) Spin = NOSPIN;}
	void dealloc();        
	int init(char *server, char *port);
	void quit();

	void BuildFont();
	void KillFont();
	void glPrint(char *text);
	void nodeinfo();
	~BarManager();
	
};

//World TheWorld;

#endif
