/***************************************************************************
                          openmosixcollector.h  -  description
                             -------------------
    begin                : Sat Jul 27 2002
    copyright            : (C) 2002 by Matt Rechenburg
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPENMOSIXCOLLECTOR_H
#define OPENMOSIXCOLLECTOR_H

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <iostream>
#include <fstream>
#include <string>
#include <list>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/resource.h>
#include <time.h>


#define collectorpid "/var/run/openMosixcollector.pid"
#define clusterdirectory "/proc/hpc/nodes/"
#define logdirectory "/tmp/openmosixcollector"
#define syncfile "sync.count"

using namespace std;


/**
  *@author Matt Rechenburg
  */

class openmosixcollector {
public: 
	openmosixcollector();
	~openmosixcollector();

	// fork
	int daemonize();

	// stops the collector
	int kill();

	// get how many nodes we are
	int gethowmanynodes();

	// check if the cluster configuration changed
	bool checknodes();

	// update nodelist
	void updatenodelist();

	// log dynamic values of the cluster to logfiles
	void openmosixcollector::lognodes();

	// returns values from the proc-interface
	string getprocvalue( string nodeid, string what );

	// logs the all processes in a histrory-file
	void logprocesshistory(int tsecs);

	// checkpoint the clusterlogfiles
	void checkpoint();

	// store logfiles
	void storelogfiles();


   // the nodelist
   list<string> nodelist;

	// howmany nodes we are
	int clusternodes;

	// increment sync file
	int incrementcounter();


};









#endif
